/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import io.joynr.arbitration.ArbitrationCallback;
import io.joynr.arbitration.ArbitrationResult;
import io.joynr.arbitration.Arbitrator;
import io.joynr.arbitration.ArbitratorFactory;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyFactory;
import io.joynr.proxy.ProxyInvocationHandler;
import io.joynr.proxy.ProxyInvocationHandlerFactory;
import io.joynr.util.VersionUtil;
import java.util.Set;
import java.util.UUID;
import joynr.system.DiscoveryAsync;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyBuilderDefaultImpl<T>
implements ProxyBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(ProxyBuilderDefaultImpl.class);
    private DiscoveryQos discoveryQos;
    MessagingQos messagingQos;
    private Arbitrator arbitrator;
    private DiscoveryAsync localDiscoveryAggregator;
    private Set<String> domains;
    private String proxyParticipantId;
    private boolean buildCalled;
    Class<T> myClass;
    private final String interfaceName;
    private Version interfaceVersion;
    private ProxyInvocationHandlerFactory proxyInvocationHandlerFactory;
    private final long maxMessagingTtl;
    private final long defaultDiscoveryTimeoutMs;
    private final long defaultDiscoveryRetryIntervalMs;
    private T proxy;

    ProxyBuilderDefaultImpl(DiscoveryAsync localDiscoveryAggregator, Set<String> domains, Class<T> interfaceClass, ProxyInvocationHandlerFactory proxyInvocationHandlerFactory, long maxMessagingTtl, long defaultDiscoveryTimeoutMs, long defaultDiscoveryRetryIntervalMs) {
        this.proxyInvocationHandlerFactory = proxyInvocationHandlerFactory;
        this.maxMessagingTtl = maxMessagingTtl;
        this.defaultDiscoveryTimeoutMs = defaultDiscoveryTimeoutMs;
        this.defaultDiscoveryRetryIntervalMs = defaultDiscoveryRetryIntervalMs;
        try {
            this.interfaceName = (String)interfaceClass.getField("INTERFACE_NAME").get(String.class);
        }
        catch (Exception e) {
            logger.error("INTERFACE_NAME needs to be set in the interface class {}", interfaceClass);
            throw new IllegalStateException(e);
        }
        this.interfaceVersion = VersionUtil.getVersionFromAnnotation(interfaceClass);
        this.myClass = interfaceClass;
        this.proxyParticipantId = UUID.randomUUID().toString();
        this.localDiscoveryAggregator = localDiscoveryAggregator;
        this.domains = domains;
        this.setDiscoveryQos(new DiscoveryQos());
        this.messagingQos = new MessagingQos();
        this.buildCalled = false;
    }

    @Override
    public String getParticipantId() {
        return this.proxyParticipantId;
    }

    @Override
    public void setParticipantId(String participantId) {
        this.proxyParticipantId = participantId;
    }

    @Override
    public ProxyBuilder<T> setDiscoveryQos(DiscoveryQos discoveryQos) throws DiscoveryException {
        if (discoveryQos.getDiscoveryTimeoutMs() < 0L && discoveryQos.getDiscoveryTimeoutMs() != -1L) {
            throw new DiscoveryException("Discovery timeout cannot be less than zero");
        }
        if (discoveryQos.getRetryIntervalMs() < 0L && discoveryQos.getRetryIntervalMs() != -1L) {
            throw new DiscoveryException("Discovery retry interval cannot be less than zero");
        }
        this.applyDefaultValues(discoveryQos);
        this.discoveryQos = discoveryQos;
        this.arbitrator = ArbitratorFactory.create(this.domains, this.interfaceName, this.interfaceVersion, discoveryQos, this.localDiscoveryAggregator);
        return this;
    }

    @Override
    public ProxyBuilder<T> setMessagingQos(MessagingQos messagingQos) {
        if (messagingQos.getRoundTripTtl_ms() > this.maxMessagingTtl) {
            logger.warn("Error in MessageQos. domains: {} interface: {} Max allowed ttl: {}. Passed ttl: {}", new Object[]{this.domains, this.interfaceName, this.maxMessagingTtl, messagingQos.getRoundTripTtl_ms()});
            messagingQos.setTtl_ms(this.maxMessagingTtl);
        }
        this.messagingQos = messagingQos;
        return this;
    }

    @Override
    public T build() {
        return this.build(new ProxyBuilder.ProxyCreatedCallback<T>(){

            @Override
            public void onProxyCreationFinished(T result) {
                logger.trace("proxy created: interface: {} domains: {}", (Object)ProxyBuilderDefaultImpl.this.interfaceName, (Object)ProxyBuilderDefaultImpl.this.domains);
            }

            @Override
            public void onProxyCreationError(JoynrRuntimeException error) {
                logger.error("error creating proxy: interface: {} domains: {}, error: {}", new Object[]{ProxyBuilderDefaultImpl.this.interfaceName, ProxyBuilderDefaultImpl.this.domains, error.getMessage()});
            }
        });
    }

    @Override
    public T build(ProxyBuilder.ProxyCreatedCallback<T> callback) {
        try {
            ProxyInvocationHandler proxyInvocationHandler = this.createProxyInvocationHandler(callback);
            this.proxy = ProxyFactory.createProxy(this.myClass, this.messagingQos, proxyInvocationHandler);
            this.arbitrator.scheduleArbitration();
            return this.proxy;
        }
        catch (JoynrRuntimeException e) {
            logger.debug("error building proxy", (Throwable)e);
            callback.onProxyCreationError(e);
            throw e;
        }
    }

    private ProxyInvocationHandler createProxyInvocationHandler(final ProxyBuilder.ProxyCreatedCallback<T> callback) {
        if (this.buildCalled) {
            throw new JoynrIllegalStateException("Proxy builder was already used to build a proxy. Please create a new proxy builder for each proxy.");
        }
        this.buildCalled = true;
        final ProxyInvocationHandler proxyInvocationHandler = this.proxyInvocationHandlerFactory.create(this.domains, this.interfaceName, this.proxyParticipantId, this.discoveryQos, this.messagingQos);
        this.arbitrator.setArbitrationListener(new ArbitrationCallback(){

            @Override
            public void onSuccess(ArbitrationResult arbitrationResult) {
                logger.debug("DISCOVERY proxy created for:{}", arbitrationResult.getDiscoveryEntries());
                proxyInvocationHandler.createConnector(arbitrationResult);
                callback.onProxyCreationFinished(ProxyBuilderDefaultImpl.this.proxy);
            }

            @Override
            public void onError(Throwable throwable) {
                JoynrRuntimeException reason = throwable instanceof JoynrRuntimeException ? (JoynrRuntimeException)throwable : new JoynrRuntimeException(throwable);
                proxyInvocationHandler.abort(reason);
                callback.onProxyCreationError(reason);
            }
        });
        return proxyInvocationHandler;
    }

    private void applyDefaultValues(DiscoveryQos discoveryQos) {
        if (discoveryQos.getDiscoveryTimeoutMs() == -1L) {
            discoveryQos.setDiscoveryTimeoutMs(this.defaultDiscoveryTimeoutMs);
        }
        if (discoveryQos.getRetryIntervalMs() == -1L) {
            discoveryQos.setRetryIntervalMs(this.defaultDiscoveryRetryIntervalMs);
        }
    }
}

