/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import io.joynr.common.ExpiryDate;
import io.joynr.dispatching.DispatcherUtils;
import io.joynr.dispatching.RequestReplyManager;
import io.joynr.dispatching.rpc.ReplyCallerDirectory;
import io.joynr.dispatching.rpc.RpcAsyncRequestReplyCaller;
import io.joynr.dispatching.rpc.RpcUtils;
import io.joynr.dispatching.rpc.SynchronizedReplyCaller;
import io.joynr.dispatching.subscription.SubscriptionManager;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.ConnectorInvocationHandler;
import io.joynr.proxy.Future;
import io.joynr.proxy.ICallback;
import io.joynr.proxy.JoynrMessagingConnectorFactory;
import io.joynr.proxy.invocation.AttributeSubscribeInvocation;
import io.joynr.proxy.invocation.BroadcastSubscribeInvocation;
import io.joynr.proxy.invocation.MulticastSubscribeInvocation;
import io.joynr.proxy.invocation.UnsubscribeInvocation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.annotation.CheckForNull;
import joynr.MethodMetaInformation;
import joynr.OneWayRequest;
import joynr.Reply;
import joynr.Request;
import joynr.exceptions.ApplicationException;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JoynrMessagingConnectorInvocationHandler
implements ConnectorInvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(JoynrMessagingConnectorInvocationHandler.class);
    private final Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries;
    private final String fromParticipantId;
    private final MessagingQos qosSettings;
    private final RequestReplyManager requestReplyManager;
    private final ReplyCallerDirectory replyCallerDirectory;
    private final SubscriptionManager subscriptionManager;

    JoynrMessagingConnectorInvocationHandler(Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, String fromParticipantId, MessagingQos qosSettings, RequestReplyManager requestReplyManager, ReplyCallerDirectory replyCallerDirectory, SubscriptionManager subscriptionManager) {
        this.toDiscoveryEntries = toDiscoveryEntries;
        this.fromParticipantId = fromParticipantId;
        this.qosSettings = qosSettings;
        this.requestReplyManager = requestReplyManager;
        this.replyCallerDirectory = replyCallerDirectory;
        this.subscriptionManager = subscriptionManager;
    }

    public Future<?> executeAsyncMethod(Method method, Object[] params, Future<?> future) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        if (this.toDiscoveryEntries.size() > 1) {
            throw new JoynrIllegalStateException("You can't execute async methods for multiple participants.");
        }
        if (this.toDiscoveryEntries.isEmpty()) {
            throw new JoynrIllegalStateException("You must have exactly one participant to be able to execute an async method.");
        }
        MethodMetaInformation methodMetaInformation = JoynrMessagingConnectorFactory.ensureMethodMetaInformationPresent(method);
        if (methodMetaInformation.getCallbackAnnotation() == null) {
            throw new JoynrIllegalStateException("All async methods need to have a annotated callback parameter.");
        }
        int callbackIndex = methodMetaInformation.getCallbackIndex();
        ICallback callback = (ICallback)params[callbackIndex];
        Object[] paramsWithoutCallback = new Object[params.length - 1];
        this.copyArrayWithoutElement(params, paramsWithoutCallback, callbackIndex);
        Object[] paramDatatypes = method.getParameterTypes();
        Object[] paramDatatypesWithoutCallback = new Class[paramDatatypes.length - 1];
        this.copyArrayWithoutElement(paramDatatypes, paramDatatypesWithoutCallback, callbackIndex);
        Request request = new Request(method.getName(), paramsWithoutCallback, (Class<?>[])paramDatatypesWithoutCallback);
        String requestReplyId = request.getRequestReplyId();
        RpcAsyncRequestReplyCaller callbackWrappingReplyCaller = new RpcAsyncRequestReplyCaller(requestReplyId, callback, future, method, methodMetaInformation);
        ExpiryDate expiryDate = DispatcherUtils.convertTtlToExpirationDate(this.qosSettings.getRoundTripTtl_ms());
        this.replyCallerDirectory.addReplyCaller(requestReplyId, callbackWrappingReplyCaller, expiryDate);
        this.requestReplyManager.sendRequest(this.fromParticipantId, this.toDiscoveryEntries.iterator().next(), request, this.qosSettings);
        return future;
    }

    private void copyArrayWithoutElement(Object[] fromArray, Object[] toArray, int removeIndex) {
        System.arraycopy(fromArray, 0, toArray, 0, removeIndex);
        System.arraycopy(fromArray, removeIndex + 1, toArray, removeIndex, toArray.length - removeIndex);
    }

    @Override
    @CheckForNull
    public Object executeSyncMethod(Method method, Object[] args) throws ApplicationException {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        if (this.toDiscoveryEntries.size() > 1) {
            throw new JoynrIllegalStateException("You can't execute sync methods for multiple participants.");
        }
        if (this.toDiscoveryEntries.isEmpty()) {
            throw new JoynrIllegalStateException("You must have exactly one participant to be able to execute a sync method.");
        }
        MethodMetaInformation methodMetaInformation = JoynrMessagingConnectorFactory.ensureMethodMetaInformationPresent(method);
        Request request = new Request(method.getName(), args, method.getParameterTypes());
        String requestReplyId = request.getRequestReplyId();
        SynchronizedReplyCaller synchronizedReplyCaller = new SynchronizedReplyCaller(this.fromParticipantId, requestReplyId, request);
        ExpiryDate expiryDate = DispatcherUtils.convertTtlToExpirationDate(this.qosSettings.getRoundTripTtl_ms());
        this.replyCallerDirectory.addReplyCaller(requestReplyId, synchronizedReplyCaller, expiryDate);
        Reply reply = (Reply)this.requestReplyManager.sendSyncRequest(this.fromParticipantId, this.toDiscoveryEntries.iterator().next(), request, synchronizedReplyCaller, this.qosSettings);
        if (reply.getError() == null) {
            if (method.getReturnType().equals(Void.TYPE)) {
                return null;
            }
            Object response = RpcUtils.reconstructReturnedObject(method, methodMetaInformation, reply.getResponse());
            logger.debug("REQUEST returns successful: requestReplyId: {}, method {}, response: {}", new Object[]{requestReplyId, method.getName(), response});
            return response;
        }
        if (reply.getError() instanceof ApplicationException) {
            logger.debug("REQUEST returns error: requestReplyId: {}, method {}, response: {}", new Object[]{requestReplyId, method.getName(), reply.getError()});
            throw (ApplicationException)reply.getError();
        }
        logger.debug("REQUEST returns error: requestReplyId: {}, method {}, response: {}", new Object[]{requestReplyId, method.getName(), reply.getError()});
        throw (JoynrRuntimeException)reply.getError();
    }

    @Override
    public void executeOneWayMethod(Method method, Object[] args) {
        if (method == null) {
            throw new IllegalArgumentException("Method cannot be null");
        }
        if (this.toDiscoveryEntries.isEmpty()) {
            throw new JoynrIllegalStateException("You must have at least one participant to be able to execute an oneWayMethod.");
        }
        logger.debug("ONEWAYREQUEST call proxy: method: {}, params: {}, proxy participantId: {}, provider discovery entries: {}", new Object[]{method.getName(), args, this.fromParticipantId, this.toDiscoveryEntries});
        OneWayRequest request = new OneWayRequest(method.getName(), args, method.getParameterTypes());
        this.requestReplyManager.sendOneWayRequest(this.fromParticipantId, this.toDiscoveryEntries, request, this.qosSettings);
    }

    @Override
    public void executeSubscriptionMethod(UnsubscribeInvocation unsubscribeInvocation) {
        if (this.toDiscoveryEntries.isEmpty()) {
            throw new JoynrIllegalStateException("You must have at least one participant to be able to execute a subscription method.");
        }
        this.subscriptionManager.unregisterSubscription(this.fromParticipantId, this.toDiscoveryEntries, unsubscribeInvocation.getSubscriptionId(), this.qosSettings);
    }

    @Override
    public void executeSubscriptionMethod(AttributeSubscribeInvocation attributeSubscription) {
        if (this.toDiscoveryEntries.isEmpty()) {
            throw new JoynrIllegalStateException("You must have at least one participant to be able to execute a subscription method.");
        }
        logger.debug("SUBSCRIPTION call proxy: subscriptionId: {}, attribute: {}, qos: {}, proxy participantId: {}, provider discovery entries: {}", new Object[]{attributeSubscription.getSubscriptionId(), attributeSubscription.getSubscriptionName(), attributeSubscription.getQos(), this.fromParticipantId, this.toDiscoveryEntries});
        this.subscriptionManager.registerAttributeSubscription(this.fromParticipantId, this.toDiscoveryEntries, attributeSubscription);
    }

    @Override
    public void executeSubscriptionMethod(BroadcastSubscribeInvocation broadcastSubscription) {
        if (this.toDiscoveryEntries.isEmpty()) {
            throw new JoynrIllegalStateException("You must have at least one participant to be able to execute a subscription method.");
        }
        logger.debug("SUBSCRIPTION call proxy: subscriptionId: {}, broadcast: {}, qos: {}, proxy participantId: {}, provider discovery entries: {}", new Object[]{broadcastSubscription.getSubscriptionId(), broadcastSubscription.getBroadcastName(), broadcastSubscription.getQos(), this.fromParticipantId, this.toDiscoveryEntries});
        this.subscriptionManager.registerBroadcastSubscription(this.fromParticipantId, this.toDiscoveryEntries, broadcastSubscription);
    }

    @Override
    public void executeSubscriptionMethod(MulticastSubscribeInvocation multicastSubscription) {
        this.subscriptionManager.registerMulticastSubscription(this.fromParticipantId, this.toDiscoveryEntries, multicastSubscription);
    }
}

