/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.inject.Inject;
import io.joynr.dispatching.RequestReplyManager;
import io.joynr.dispatching.rpc.ReplyCallerDirectory;
import io.joynr.dispatching.subscription.SubscriptionManager;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.JoynrMessagingConnectorInvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import joynr.MethodMetaInformation;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrMessagingConnectorFactory {
    private static final Logger logger = LoggerFactory.getLogger(JoynrMessagingConnectorFactory.class);
    private static final ConcurrentMap<Method, MethodMetaInformation> metaInformationMap = new ConcurrentHashMap<Method, MethodMetaInformation>();
    private RequestReplyManager requestReplyManager;
    private SubscriptionManager subscriptionManager;
    private ReplyCallerDirectory replyCallerDirectory;

    @Inject
    public JoynrMessagingConnectorFactory(RequestReplyManager requestReplyManager, ReplyCallerDirectory replyCallerDirectory, SubscriptionManager subscriptionManager) {
        this.requestReplyManager = requestReplyManager;
        this.replyCallerDirectory = replyCallerDirectory;
        this.subscriptionManager = subscriptionManager;
    }

    public JoynrMessagingConnectorInvocationHandler create(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, MessagingQos qosSettings) {
        return new JoynrMessagingConnectorInvocationHandler(toDiscoveryEntries, fromParticipantId, qosSettings, this.requestReplyManager, this.replyCallerDirectory, this.subscriptionManager);
    }

    public static MethodMetaInformation ensureMethodMetaInformationPresent(Method method) {
        MethodMetaInformation metaInformation;
        if (metaInformationMap.containsKey(method)) {
            return (MethodMetaInformation)metaInformationMap.get(method);
        }
        try {
            metaInformation = new MethodMetaInformation(method);
        }
        catch (JsonMappingException e) {
            throw new JoynrRuntimeException((Throwable)e);
        }
        MethodMetaInformation existingMetaInformation = metaInformationMap.putIfAbsent(method, metaInformation);
        if (existingMetaInformation != null) {
            logger.debug("There was already a metaInformation object for that method in the map.");
        }
        return metaInformation;
    }
}

