/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.arbitration.ArbitrationResult;
import io.joynr.messaging.MessagingQos;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.proxy.ConnectorInvocationHandler;
import io.joynr.proxy.JoynrMessagingConnectorFactory;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.inject.Named;
import joynr.system.RoutingTypes.Address;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.ProviderScope;

@Singleton
public class ConnectorFactory {
    JoynrMessagingConnectorFactory joynrMessagingConnectorFactory;
    private MessageRouter messageRouter;
    private Address libjoynrMessagingAddress;

    @Inject
    public ConnectorFactory(JoynrMessagingConnectorFactory joynrMessagingConnectorFactory, MessageRouter messageRouter, @Named(value="joynr.messaging.dispatcheraddress") Address dispatcherAddress) {
        this.joynrMessagingConnectorFactory = joynrMessagingConnectorFactory;
        this.messageRouter = messageRouter;
        this.libjoynrMessagingAddress = dispatcherAddress;
    }

    @CheckForNull
    public ConnectorInvocationHandler create(String fromParticipantId, ArbitrationResult arbitrationResult, MessagingQos qosSettings) {
        boolean isGloballyVisible = false;
        Set<DiscoveryEntryWithMetaInfo> entries = arbitrationResult.getDiscoveryEntries();
        for (DiscoveryEntryWithMetaInfo entry : entries) {
            if (entry.getQos().getScope() != ProviderScope.GLOBAL) continue;
            isGloballyVisible = true;
            break;
        }
        this.messageRouter.addNextHop(fromParticipantId, this.libjoynrMessagingAddress, isGloballyVisible);
        return this.joynrMessagingConnectorFactory.create(fromParticipantId, arbitrationResult.getDiscoveryEntries(), qosSettings);
    }
}

