/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import com.google.inject.Inject;
import io.joynr.dispatching.RequestCallerFactory;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.provider.JoynrProvider;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.provider.ProviderContainer;
import io.joynr.provider.SubscriptionPublisherFactory;
import io.joynr.provider.SubscriptionPublisherObservable;
import java.util.HashMap;
import java.util.Map;

public class ProviderContainerFactory {
    private final Map<Object, ProviderContainer> providerContainers;
    private final SubscriptionPublisherFactory subscriptionPublisherFactory;
    private final RequestCallerFactory requestCallerFactory;

    @Inject
    public ProviderContainerFactory(SubscriptionPublisherFactory subscriptionPublisherFactory, RequestCallerFactory requestCallerFactory) {
        this.subscriptionPublisherFactory = subscriptionPublisherFactory;
        this.requestCallerFactory = requestCallerFactory;
        this.providerContainers = new HashMap<Object, ProviderContainer>();
    }

    public ProviderContainer create(Object provider) {
        if (this.providerContainers.get(provider) == null) {
            this.providerContainers.put(provider, this.createInternal(provider));
        }
        return this.providerContainers.get(provider);
    }

    private ProviderContainer createInternal(Object provider) throws JoynrRuntimeException {
        return new ProviderContainer(ProviderAnnotations.getInterfaceName((Object)provider), ProviderAnnotations.getProvidedInterface((Object)provider), this.requestCallerFactory.create(provider), (SubscriptionPublisherObservable)this.subscriptionPublisherFactory.create(provider));
    }

    public void removeProviderContainer(JoynrProvider provider) {
        this.providerContainers.remove(provider);
    }
}

