/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.joynr.messaging.serialize.DeserializerUtils;
import io.joynr.messaging.serialize.ParamsAndParamDatatypesHolder;
import java.io.IOException;
import joynr.OneWayRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneWayRequestDeserializer
extends JsonDeserializer<OneWayRequest> {
    private static final Logger logger = LoggerFactory.getLogger(OneWayRequestDeserializer.class);
    private ObjectMapper objectMapper;

    public OneWayRequestDeserializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public OneWayRequest deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String methodName = node.get("methodName").asText();
        ParamsAndParamDatatypesHolder paramsAndParamDatatypes = DeserializerUtils.deserializeParams(this.objectMapper, node, logger);
        return new OneWayRequest(methodName, paramsAndParamDatatypes.params, paramsAndParamDatatypes.paramDatatypes);
    }
}

