/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.serialize;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.joynr.dispatcher.rpc.ReflectionUtils;
import io.joynr.messaging.serialize.ParamsAndParamDatatypesHolder;
import org.slf4j.Logger;

class DeserializerUtils {
    DeserializerUtils() {
    }

    static ParamsAndParamDatatypesHolder deserializeParams(ObjectMapper objectMapper, JsonNode node, Logger logger) {
        Object[] params;
        String[] paramDatatypes;
        Class[] javaClasses = null;
        ArrayNode paramDatatypesNode = (ArrayNode)node.get("paramDatatypes");
        if (paramDatatypesNode != null) {
            paramDatatypes = new String[paramDatatypesNode.size()];
            int i = 0;
            for (JsonNode paramDatatypeNode : paramDatatypesNode) {
                paramDatatypes[i] = paramDatatypeNode.asText();
                ++i;
            }
            javaClasses = ReflectionUtils.toJavaClasses((String[])paramDatatypes);
        } else {
            paramDatatypes = new String[]{};
        }
        ArrayNode paramsNode = (ArrayNode)node.get("params");
        if (paramsNode != null && javaClasses != null) {
            params = new Object[paramsNode.size()];
            int i = 0;
            for (JsonNode paramNode : paramsNode) {
                try {
                    params[i] = objectMapper.treeToValue((TreeNode)paramNode, javaClasses[i]);
                }
                catch (Exception e) {
                    logger.error("unable to deserialize to " + javaClasses[i] + " reason: " + e.getMessage());
                    params[i] = null;
                }
                ++i;
            }
        } else {
            params = new Object[]{};
        }
        return new ParamsAndParamDatatypesHolder(paramDatatypes, params);
    }
}

