/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.routing;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.messaging.MessagingSkeletonFactory;
import io.joynr.messaging.inprocess.InProcessAddress;
import io.joynr.messaging.routing.AbstractMessageRouter;
import io.joynr.messaging.routing.AddressManager;
import io.joynr.messaging.routing.DelayableImmutableMessage;
import io.joynr.messaging.routing.MessagingStubFactory;
import io.joynr.messaging.routing.MulticastReceiverRegistry;
import io.joynr.messaging.routing.RoutingTable;
import io.joynr.runtime.ShutdownNotifier;
import io.joynr.statusmetrics.StatusReceiver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.ScheduledExecutorService;
import joynr.ImmutableMessage;
import joynr.exceptions.ProviderRuntimeException;
import joynr.system.RoutingProxy;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.BrowserAddress;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LibJoynrMessageRouter
extends AbstractMessageRouter {
    private Logger logger = LoggerFactory.getLogger(LibJoynrMessageRouter.class);
    private Address parentRouterMessagingAddress;
    private RoutingProxy parentRouter;
    private Address incomingAddress;
    private Set<ParticipantIdAndIsGloballyVisibleHolder> deferredParentHopsParticipantIds = new HashSet<ParticipantIdAndIsGloballyVisibleHolder>();
    private Map<String, DeferrableRegistration> deferredMulticastRegistrations = new HashMap<String, DeferrableRegistration>();

    @Inject
    public LibJoynrMessageRouter(RoutingTable routingTable, @Named(value="libjoynr_messaging_address") Address incomingAddress, @Named(value="io.joynr.messaging.scheduledthreadpool") ScheduledExecutorService scheduler, @Named(value="joynr.messaging.sendmsgretryintervalms") long sendMsgRetryIntervalMs, @Named(value="joynr.messaging.maximumparallelsends") int maxParallelSends, @Named(value="joynr.messaging.routingtablegraceperiodms") long routingTableGracePeriodMs, @Named(value="joynr.messaging.routingtablecleanupintervalms") long routingTableCleanupIntervalMs, MessagingStubFactory messagingStubFactory, MessagingSkeletonFactory messagingSkeletonFactory, AddressManager addressManager, MulticastReceiverRegistry multicastReceiverRegistry, DelayQueue<DelayableImmutableMessage> messageQueue, ShutdownNotifier shutdownNotifier, StatusReceiver statusReceiver) {
        super(routingTable, scheduler, sendMsgRetryIntervalMs, maxParallelSends, routingTableGracePeriodMs, routingTableCleanupIntervalMs, messagingStubFactory, messagingSkeletonFactory, addressManager, multicastReceiverRegistry, messageQueue, shutdownNotifier, statusReceiver);
        this.incomingAddress = incomingAddress;
    }

    protected Set<Address> getAddresses(ImmutableMessage message) {
        String toParticipantId;
        Boolean parentHasNextHop;
        Set result = super.getAddresses(message);
        if (result.isEmpty() && this.parentRouter != null && message.getType() != "m" && (parentHasNextHop = this.parentRouter.resolveNextHop(toParticipantId = message.getRecipient())).booleanValue()) {
            super.addNextHop(toParticipantId, this.parentRouterMessagingAddress, true);
            result.add(this.parentRouterMessagingAddress);
        }
        return result;
    }

    public void addNextHop(String participantId, Address address, boolean isGloballyVisible) {
        super.addNextHop(participantId, address, isGloballyVisible);
        if (this.parentRouter != null) {
            this.addNextHopToParent(participantId, isGloballyVisible);
        } else {
            this.deferredParentHopsParticipantIds.add(new ParticipantIdAndIsGloballyVisibleHolder(participantId, isGloballyVisible));
        }
    }

    private void addNextHopToParent(String participantId, boolean isGloballyVisible) {
        this.logger.trace("Adding next hop with participant id " + participantId + " to parent router");
        if (this.incomingAddress instanceof ChannelAddress) {
            this.parentRouter.addNextHop(participantId, (ChannelAddress)this.incomingAddress, Boolean.valueOf(isGloballyVisible));
        } else if (this.incomingAddress instanceof BrowserAddress) {
            this.parentRouter.addNextHop(participantId, (BrowserAddress)this.incomingAddress, Boolean.valueOf(isGloballyVisible));
        } else if (this.incomingAddress instanceof WebSocketAddress) {
            this.parentRouter.addNextHop(participantId, (WebSocketAddress)this.incomingAddress, Boolean.valueOf(isGloballyVisible));
        } else if (this.incomingAddress instanceof WebSocketClientAddress) {
            this.parentRouter.addNextHop(participantId, (WebSocketClientAddress)this.incomingAddress, Boolean.valueOf(isGloballyVisible));
        } else {
            throw new ProviderRuntimeException("Failed to add next hop to parent: unknown address type" + this.incomingAddress.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMulticastReceiver(final String multicastId, final String subscriberParticipantId, final String providerParticipantId) {
        super.addMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        DeferrableRegistration registerWithParent = new DeferrableRegistration(){

            @Override
            public void register() {
                Address providerAddress = LibJoynrMessageRouter.this.routingTable.get(providerParticipantId);
                if (providerAddress == null || !(providerAddress instanceof InProcessAddress)) {
                    LibJoynrMessageRouter.this.parentRouter.addMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
                }
            }
        };
        if (this.parentRouter != null) {
            registerWithParent.register();
        } else {
            Map<String, DeferrableRegistration> map = this.deferredMulticastRegistrations;
            synchronized (map) {
                this.deferredMulticastRegistrations.put(multicastId + subscriberParticipantId + providerParticipantId, registerWithParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMulticastReceiver(String multicastId, String subscriberParticipantId, String providerParticipantId) {
        super.removeMulticastReceiver(multicastId, subscriberParticipantId, providerParticipantId);
        if (this.parentRouter == null) {
            Map<String, DeferrableRegistration> map = this.deferredMulticastRegistrations;
            synchronized (map) {
                this.deferredMulticastRegistrations.remove(multicastId + subscriberParticipantId + providerParticipantId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParentRouter(RoutingProxy parentRouter, Address parentRouterMessagingAddress, String parentRoutingProviderParticipantId, String routingProxyParticipantId) {
        this.parentRouter = parentRouter;
        this.parentRouterMessagingAddress = parentRouterMessagingAddress;
        boolean isGloballyVisible = false;
        super.addNextHop(parentRoutingProviderParticipantId, parentRouterMessagingAddress, false);
        this.addNextHopToParent(routingProxyParticipantId, false);
        for (ParticipantIdAndIsGloballyVisibleHolder participantIds : this.deferredParentHopsParticipantIds) {
            this.addNextHopToParent(participantIds.participantId, participantIds.isGloballyVisible);
        }
        Map<String, DeferrableRegistration> map = this.deferredMulticastRegistrations;
        synchronized (map) {
            for (DeferrableRegistration registerWithParent : this.deferredMulticastRegistrations.values()) {
                registerWithParent.register();
            }
        }
        this.deferredParentHopsParticipantIds.clear();
    }

    public void setIncomingAddress(Address incomingAddress) {
        this.incomingAddress = incomingAddress;
    }

    private static class ParticipantIdAndIsGloballyVisibleHolder {
        final String participantId;
        final boolean isGloballyVisible;

        public ParticipantIdAndIsGloballyVisibleHolder(String participantId, boolean isGloballyVisible) {
            this.participantId = participantId;
            this.isGloballyVisible = isGloballyVisible;
        }
    }

    private static interface DeferrableRegistration {
        public void register();
    }
}

