/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging.inprocess;

import com.google.inject.Inject;
import io.joynr.dispatching.Dispatcher;
import io.joynr.messaging.FailureAction;
import io.joynr.messaging.SuccessAction;
import io.joynr.messaging.inprocess.InProcessMessagingSkeleton;
import joynr.ImmutableMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InProcessLibjoynrMessagingSkeleton
implements InProcessMessagingSkeleton {
    private static final Logger LOG = LoggerFactory.getLogger(InProcessLibjoynrMessagingSkeleton.class);
    private final Dispatcher dispatcher;

    @Inject
    public InProcessLibjoynrMessagingSkeleton(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void transmit(ImmutableMessage message, SuccessAction successAction, FailureAction failureAction) {
        LOG.trace("InProcess call for message id {}", (Object)message.getId());
        try {
            this.dispatcher.messageArrived(message);
            successAction.execute();
        }
        catch (Exception e) {
            failureAction.execute((Throwable)e);
        }
    }

    public void init() {
    }

    public void shutdown() {
    }
}

