/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.dispatching.Dispatcher;
import io.joynr.dispatching.subscription.MissedPublicationTimer;
import io.joynr.dispatching.subscription.MulticastIdUtil;
import io.joynr.dispatching.subscription.PubSubState;
import io.joynr.dispatching.subscription.SubscriptionManager;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.messaging.util.MulticastWildcardRegexFactory;
import io.joynr.proxy.Future;
import io.joynr.proxy.invocation.AttributeSubscribeInvocation;
import io.joynr.proxy.invocation.BroadcastSubscribeInvocation;
import io.joynr.proxy.invocation.MulticastSubscribeInvocation;
import io.joynr.proxy.invocation.SubscriptionInvocation;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import io.joynr.pubsub.SubscriptionQos;
import io.joynr.pubsub.subscription.AttributeSubscriptionListener;
import io.joynr.pubsub.subscription.BroadcastSubscriptionListener;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import joynr.BroadcastSubscriptionRequest;
import joynr.MulticastSubscriptionRequest;
import joynr.SubscriptionReply;
import joynr.SubscriptionRequest;
import joynr.SubscriptionStop;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SubscriptionManagerImpl
implements SubscriptionManager,
ShutdownListener {
    private ConcurrentMap<String, AttributeSubscriptionListener<?>> subscriptionListenerDirectory;
    private ConcurrentMap<String, BroadcastSubscriptionListener> broadcastSubscriptionListenerDirectory;
    private ConcurrentMap<Pattern, Set<String>> multicastSubscribersDirectory;
    private ConcurrentMap<String, Future<String>> subscriptionFutureMap;
    private ConcurrentMap<String, Class<?>> subscriptionTypes;
    private ConcurrentMap<String, Class<?>[]> unicastBroadcastTypes;
    private ConcurrentMap<Pattern, Class<?>[]> multicastBroadcastTypes;
    private ConcurrentMap<String, PubSubState> subscriptionStates;
    private ConcurrentMap<String, MissedPublicationTimer> missedPublicationTimers;
    private ConcurrentMap<String, ScheduledFuture<?>> subscriptionEndFutures;
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionManagerImpl.class);
    private ScheduledExecutorService cleanupScheduler;
    private Dispatcher dispatcher;
    private final MulticastWildcardRegexFactory multicastWildcardRegexFactory;

    @Inject
    public SubscriptionManagerImpl(@Named(value="joynr.scheduler.cleanup") ScheduledExecutorService cleanupScheduler, Dispatcher dispatcher, MulticastWildcardRegexFactory multicastWildcardRegexFactory, ShutdownNotifier shutdownNotifier) {
        this.cleanupScheduler = cleanupScheduler;
        this.dispatcher = dispatcher;
        this.subscriptionListenerDirectory = Maps.newConcurrentMap();
        this.broadcastSubscriptionListenerDirectory = Maps.newConcurrentMap();
        this.multicastSubscribersDirectory = Maps.newConcurrentMap();
        this.subscriptionStates = Maps.newConcurrentMap();
        this.missedPublicationTimers = Maps.newConcurrentMap();
        this.subscriptionEndFutures = Maps.newConcurrentMap();
        this.subscriptionTypes = Maps.newConcurrentMap();
        this.unicastBroadcastTypes = Maps.newConcurrentMap();
        this.multicastBroadcastTypes = Maps.newConcurrentMap();
        this.subscriptionFutureMap = Maps.newConcurrentMap();
        this.multicastWildcardRegexFactory = multicastWildcardRegexFactory;
        shutdownNotifier.registerForShutdown((ShutdownListener)this);
    }

    public SubscriptionManagerImpl(ConcurrentMap<String, AttributeSubscriptionListener<?>> attributeSubscriptionDirectory, ConcurrentMap<String, BroadcastSubscriptionListener> broadcastSubscriptionDirectory, ConcurrentMap<Pattern, Set<String>> multicastSubscribersDirectory, ConcurrentMap<String, PubSubState> subscriptionStates, ConcurrentMap<String, MissedPublicationTimer> missedPublicationTimers, ConcurrentMap<String, ScheduledFuture<?>> subscriptionEndFutures, ConcurrentMap<String, Class<?>> subscriptionAttributeTypes, ConcurrentMap<String, Class<?>[]> unicastBroadcastTypes, ConcurrentMap<Pattern, Class<?>[]> multicastBroadcastTypes, ConcurrentMap<String, Future<String>> subscriptionFutureMap, ScheduledExecutorService cleanupScheduler, Dispatcher dispatcher, MulticastWildcardRegexFactory multicastWildcardRegexFactory) {
        this.subscriptionListenerDirectory = attributeSubscriptionDirectory;
        this.broadcastSubscriptionListenerDirectory = broadcastSubscriptionDirectory;
        this.multicastSubscribersDirectory = multicastSubscribersDirectory;
        this.subscriptionStates = subscriptionStates;
        this.missedPublicationTimers = missedPublicationTimers;
        this.subscriptionEndFutures = subscriptionEndFutures;
        this.subscriptionTypes = subscriptionAttributeTypes;
        this.unicastBroadcastTypes = unicastBroadcastTypes;
        this.multicastBroadcastTypes = multicastBroadcastTypes;
        this.cleanupScheduler = cleanupScheduler;
        this.dispatcher = dispatcher;
        this.subscriptionFutureMap = subscriptionFutureMap;
        this.multicastWildcardRegexFactory = multicastWildcardRegexFactory;
    }

    private void cancelExistingSubscriptionEndRunnable(String subscriptionId) {
        ScheduledFuture scheduledFuture = (ScheduledFuture)this.subscriptionEndFutures.get(subscriptionId);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    private void registerSubscription(SubscriptionQos qos, String subscriptionId) {
        this.cancelExistingSubscriptionEndRunnable(subscriptionId);
        PubSubState subState = new PubSubState();
        subState.updateTimeOfLastPublication();
        this.subscriptionStates.put(subscriptionId, subState);
        long expiryDate = qos.getExpiryDateMs();
        logger.trace("subscription: {} expiryDate: " + (expiryDate == 0L ? "never" : Long.valueOf(expiryDate - System.currentTimeMillis())), (Object)subscriptionId);
        if (expiryDate != 0L) {
            SubscriptionEndRunnable endRunnable = new SubscriptionEndRunnable(subscriptionId);
            ScheduledFuture<?> subscriptionEndFuture = this.cleanupScheduler.schedule(endRunnable, expiryDate, TimeUnit.MILLISECONDS);
            this.subscriptionEndFutures.put(subscriptionId, subscriptionEndFuture);
        }
    }

    @Override
    public void registerAttributeSubscription(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, final AttributeSubscribeInvocation request) {
        this.registerSubscription(fromParticipantId, toDiscoveryEntries, request, new RegisterDataAndCreateSubscriptionRequest(){

            @Override
            public SubscriptionRequest execute() {
                HeartbeatSubscriptionInformation heartbeat;
                SubscriptionQos qos = request.getQos();
                logger.trace("Attribute subscription registered with Id: " + request.getSubscriptionId());
                SubscriptionManagerImpl.this.subscriptionTypes.put(request.getSubscriptionId(), request.getAttributeTypeReference());
                SubscriptionManagerImpl.this.subscriptionListenerDirectory.put(request.getSubscriptionId(), request.getAttributeSubscriptionListener());
                SubscriptionManagerImpl.this.subscriptionFutureMap.put(request.getSubscriptionId(), request.getFuture());
                if (qos instanceof HeartbeatSubscriptionInformation && (heartbeat = (HeartbeatSubscriptionInformation)qos).getAlertAfterIntervalMs() > 0L) {
                    logger.trace("Will notify if updates are missed.");
                    SubscriptionManagerImpl.this.missedPublicationTimers.put(request.getSubscriptionId(), new MissedPublicationTimer(qos.getExpiryDateMs(), heartbeat.getPeriodMs(), heartbeat.getAlertAfterIntervalMs(), request.getAttributeSubscriptionListener(), (PubSubState)SubscriptionManagerImpl.this.subscriptionStates.get(request.getSubscriptionId()), request.getSubscriptionId()));
                }
                return new SubscriptionRequest(request.getSubscriptionId(), request.getAttributeName(), request.getQos());
            }
        });
    }

    @Override
    public void registerBroadcastSubscription(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, final BroadcastSubscribeInvocation request) {
        this.registerSubscription(fromParticipantId, toDiscoveryEntries, request, new RegisterDataAndCreateSubscriptionRequest(){

            @Override
            public SubscriptionRequest execute() {
                String subscriptionId = request.getSubscriptionId();
                logger.trace("Broadcast subscription registered with Id: " + subscriptionId);
                SubscriptionManagerImpl.this.unicastBroadcastTypes.put(subscriptionId, request.getOutParameterTypes());
                SubscriptionManagerImpl.this.broadcastSubscriptionListenerDirectory.put(subscriptionId, request.getBroadcastSubscriptionListener());
                return new BroadcastSubscriptionRequest(request.getSubscriptionId(), request.getBroadcastName(), request.getFilterParameters(), request.getQos());
            }
        });
    }

    @Override
    public void registerMulticastSubscription(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, final MulticastSubscribeInvocation multicastSubscribeInvocation) {
        for (DiscoveryEntryWithMetaInfo toDiscoveryEntry : toDiscoveryEntries) {
            final String multicastId = MulticastIdUtil.createMulticastId(toDiscoveryEntry.getParticipantId(), multicastSubscribeInvocation.getSubscriptionName(), multicastSubscribeInvocation.getPartitions());
            logger.debug("SUBSCRIPTION call proxy: subscriptionId: {}, multicastId: {}, broadcast: {}, qos: {}, proxy participantId: {}, provider participantId: {}", new Object[]{multicastSubscribeInvocation.getSubscriptionId(), multicastId, multicastSubscribeInvocation.getSubscriptionName(), multicastSubscribeInvocation.getQos(), fromParticipantId, toDiscoveryEntry.getParticipantId()});
            this.registerSubscription(fromParticipantId, toDiscoveryEntries, multicastSubscribeInvocation, new RegisterDataAndCreateSubscriptionRequest(){

                @Override
                public SubscriptionRequest execute() {
                    String subscriptionId = multicastSubscribeInvocation.getSubscriptionId();
                    logger.trace("Multicast subscription registered with Id: " + subscriptionId);
                    Pattern multicastIdPattern = SubscriptionManagerImpl.this.multicastWildcardRegexFactory.createIdPattern(multicastId);
                    if (!SubscriptionManagerImpl.this.multicastSubscribersDirectory.containsKey(multicastIdPattern)) {
                        SubscriptionManagerImpl.this.multicastSubscribersDirectory.putIfAbsent(multicastIdPattern, Sets.newHashSet());
                    }
                    ((Set)SubscriptionManagerImpl.this.multicastSubscribersDirectory.get(multicastIdPattern)).add(subscriptionId);
                    SubscriptionManagerImpl.this.multicastBroadcastTypes.putIfAbsent(multicastIdPattern, multicastSubscribeInvocation.getOutParameterTypes());
                    SubscriptionManagerImpl.this.broadcastSubscriptionListenerDirectory.put(subscriptionId, multicastSubscribeInvocation.getListener());
                    return new MulticastSubscriptionRequest(multicastId, multicastSubscribeInvocation.getSubscriptionId(), multicastSubscribeInvocation.getSubscriptionName(), (SubscriptionQos)multicastSubscribeInvocation.getQos());
                }
            });
        }
    }

    private void registerSubscription(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, SubscriptionInvocation subscriptionInvocation, RegisterDataAndCreateSubscriptionRequest registerDataAndCreateSubscriptionRequest) {
        if (!subscriptionInvocation.hasSubscriptionId()) {
            subscriptionInvocation.setSubscriptionId(UUID.randomUUID().toString());
        }
        String subscriptionId = subscriptionInvocation.getSubscriptionId();
        this.subscriptionFutureMap.put(subscriptionId, subscriptionInvocation.getFuture());
        this.registerSubscription(subscriptionInvocation.getQos(), subscriptionId);
        SubscriptionRequest subscriptionRequest = registerDataAndCreateSubscriptionRequest.execute();
        MessagingQos messagingQos = new MessagingQos();
        SubscriptionQos qos = subscriptionRequest.getQos();
        if (qos.getExpiryDateMs() == 0L) {
            messagingQos.setTtl_ms(Long.MAX_VALUE);
        } else {
            messagingQos.setTtl_ms(qos.getExpiryDateMs() - System.currentTimeMillis());
        }
        this.dispatcher.sendSubscriptionRequest(fromParticipantId, toDiscoveryEntries, subscriptionRequest, messagingQos);
    }

    @Override
    public void unregisterSubscription(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, String subscriptionId, MessagingQos qosSettings) {
        PubSubState subscriptionState = (PubSubState)this.subscriptionStates.get(subscriptionId);
        if (subscriptionState != null) {
            logger.trace("Called unregister / unsubscribe on subscription id= " + subscriptionId);
            this.removeSubscription(subscriptionId);
        } else {
            logger.trace("Called unregister on a non/no longer existent subscription, used id= " + subscriptionId);
        }
        SubscriptionStop subscriptionStop = new SubscriptionStop(subscriptionId);
        this.dispatcher.sendSubscriptionStop(fromParticipantId, toDiscoveryEntries, subscriptionStop, new MessagingQos(qosSettings));
    }

    @Override
    public void handleBroadcastPublication(String subscriptionId, Object[] broadcastValues) {
        BroadcastSubscriptionListener broadcastSubscriptionListener = this.getBroadcastSubscriptionListener(subscriptionId);
        try {
            Class<?>[] broadcastTypes = this.getParameterTypesForBroadcastPublication(broadcastValues);
            Method receive = broadcastSubscriptionListener.getClass().getDeclaredMethod("onReceive", broadcastTypes);
            if (!receive.isAccessible()) {
                receive.setAccessible(true);
            }
            logger.debug("SUBSCRIPTION notify listener: subscriptionId: {}, broadcastValue: {}", (Object)subscriptionId, (Object)broadcastValues);
            receive.invoke((Object)broadcastSubscriptionListener, broadcastValues);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Broadcast publication could not be processed", (Throwable)e);
        }
    }

    @Override
    public void handleMulticastPublication(String multicastId, Object[] publicizedValues) {
        for (Map.Entry entry : this.multicastSubscribersDirectory.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(multicastId).matches()) continue;
            for (String subscriptionId : (Set)entry.getValue()) {
                logger.trace("SUBSCRIPTION notify listener: subscriptionId: {}, multicastId: {}, broadcastValue: {}", new Object[]{subscriptionId, multicastId, publicizedValues});
                this.handleBroadcastPublication(subscriptionId, publicizedValues);
            }
        }
    }

    @Override
    public <T> void handleAttributePublication(String subscriptionId, T attributeValue) {
        this.touchSubscriptionState(subscriptionId);
        AttributeSubscriptionListener<T> listener = this.getSubscriptionListener(subscriptionId);
        if (listener == null) {
            logger.error("No subscription listener found for incoming publication!");
        } else {
            logger.debug("SUBSCRIPTION notify listener: subscriptionId: {}, attributeValue: {}", (Object)subscriptionId, attributeValue);
            listener.onReceive(attributeValue);
        }
    }

    @Override
    public <T> void handleAttributePublicationError(String subscriptionId, JoynrRuntimeException error) {
        this.touchSubscriptionState(subscriptionId);
        AttributeSubscriptionListener<T> listener = this.getSubscriptionListener(subscriptionId);
        if (listener == null) {
            logger.error("No subscription listener found for incoming publication!");
        } else {
            logger.debug("SUBSCRIPTION notify listener: subscriptionId: {}, error: {}", (Object)subscriptionId, (Object)error);
            listener.onError(error);
        }
    }

    @Override
    public void handleSubscriptionReply(SubscriptionReply subscriptionReply) {
        String subscriptionId = subscriptionReply.getSubscriptionId();
        if (subscriptionReply.getError() == null) {
            if (this.subscriptionFutureMap.containsKey(subscriptionId)) {
                ((Future)this.subscriptionFutureMap.remove(subscriptionId)).onSuccess((Object)subscriptionId);
            }
            if (this.subscriptionListenerDirectory.containsKey(subscriptionId)) {
                ((AttributeSubscriptionListener)this.subscriptionListenerDirectory.get(subscriptionId)).onSubscribed(subscriptionId);
            } else if (this.broadcastSubscriptionListenerDirectory.containsKey(subscriptionId)) {
                ((BroadcastSubscriptionListener)this.broadcastSubscriptionListenerDirectory.get(subscriptionId)).onSubscribed(subscriptionId);
            } else {
                logger.warn("No subscription listener found for incoming subscription reply for subscription ID {}!", (Object)subscriptionId);
            }
        } else {
            logger.trace("Handling subscription reply with error: {}", (Throwable)subscriptionReply.getError());
            if (this.subscriptionFutureMap.containsKey(subscriptionId)) {
                ((Future)this.subscriptionFutureMap.remove(subscriptionId)).onFailure((JoynrException)subscriptionReply.getError());
            }
            if (this.subscriptionListenerDirectory.containsKey(subscriptionId)) {
                ((AttributeSubscriptionListener)this.subscriptionListenerDirectory.remove(subscriptionId)).onError((JoynrRuntimeException)((Object)subscriptionReply.getError()));
            } else if (this.broadcastSubscriptionListenerDirectory.containsKey(subscriptionId)) {
                ((BroadcastSubscriptionListener)this.broadcastSubscriptionListenerDirectory.remove(subscriptionId)).onError(subscriptionReply.getError());
            } else {
                logger.warn("No subscription listener found for incoming subscription reply for subscription ID {}! Error message: {}", (Object)subscriptionId, (Object)subscriptionReply.getError().getMessage());
            }
            this.subscriptionTypes.remove(subscriptionId);
        }
    }

    @Override
    public void touchSubscriptionState(String subscriptionId) {
        logger.trace("Touching subscription state for id=" + subscriptionId);
        if (!this.subscriptionStates.containsKey(subscriptionId)) {
            logger.trace("No subscription state found for id: " + subscriptionId);
            return;
        }
        PubSubState subscriptionState = (PubSubState)this.subscriptionStates.get(subscriptionId);
        subscriptionState.updateTimeOfLastPublication();
    }

    @Override
    public <T> AttributeSubscriptionListener<T> getSubscriptionListener(String subscriptionId) {
        if (!this.subscriptionStates.containsKey(subscriptionId) || !this.subscriptionListenerDirectory.containsKey(subscriptionId)) {
            logger.error("Received publication for not existing subscription callback with id=" + subscriptionId);
        }
        return (AttributeSubscriptionListener)this.subscriptionListenerDirectory.get(subscriptionId);
    }

    @Override
    public BroadcastSubscriptionListener getBroadcastSubscriptionListener(String subscriptionId) {
        if (!this.subscriptionStates.containsKey(subscriptionId) || !this.broadcastSubscriptionListenerDirectory.containsKey(subscriptionId)) {
            logger.error("Received publication for not existing subscription callback with id=" + subscriptionId);
        }
        return (BroadcastSubscriptionListener)this.broadcastSubscriptionListenerDirectory.get(subscriptionId);
    }

    @Override
    public boolean isBroadcast(String subscriptionId) {
        return this.broadcastSubscriptionListenerDirectory.containsKey(subscriptionId);
    }

    @Override
    public Class<?> getAttributeType(String subscriptionId) {
        return (Class)this.subscriptionTypes.get(subscriptionId);
    }

    @Override
    public Class<?>[] getUnicastPublicationOutParameterTypes(String subscriptionId) {
        return (Class[])this.unicastBroadcastTypes.get(subscriptionId);
    }

    @Override
    public Class<?>[] getMulticastPublicationOutParameterTypes(String multicastId) {
        Class[] outParamterTypes = null;
        for (Map.Entry entry : this.multicastBroadcastTypes.entrySet()) {
            if (!((Pattern)entry.getKey()).matcher(multicastId).matches()) continue;
            outParamterTypes = (Class[])entry.getValue();
            break;
        }
        return outParamterTypes;
    }

    private void removeSubscription(String subscriptionId) {
        ScheduledFuture future;
        if (this.missedPublicationTimers.containsKey(subscriptionId)) {
            ((MissedPublicationTimer)this.missedPublicationTimers.get(subscriptionId)).cancel();
            this.missedPublicationTimers.remove(subscriptionId);
        }
        if ((future = (ScheduledFuture)this.subscriptionEndFutures.remove(subscriptionId)) != null) {
            future.cancel(true);
        }
        this.subscriptionStates.remove(subscriptionId);
        this.subscriptionListenerDirectory.remove(subscriptionId);
        this.unicastBroadcastTypes.remove(subscriptionId);
        this.broadcastSubscriptionListenerDirectory.remove(subscriptionId);
        for (Map.Entry entry : this.multicastSubscribersDirectory.entrySet()) {
            Set subscriptionIds = (Set)entry.getValue();
            subscriptionIds.remove(subscriptionId);
            if (!subscriptionIds.isEmpty()) continue;
            this.multicastBroadcastTypes.remove(entry.getKey());
        }
        this.subscriptionTypes.remove(subscriptionId);
    }

    private Class<?>[] getParameterTypesForBroadcastPublication(Object[] broadcastValues) {
        ArrayList parameterTypes = new ArrayList(broadcastValues.length);
        for (int i = 0; i < broadcastValues.length; ++i) {
            parameterTypes.add(broadcastValues[i].getClass());
        }
        return parameterTypes.toArray(new Class[parameterTypes.size()]);
    }

    public void shutdown() {
        for (ScheduledFuture future : this.subscriptionEndFutures.values()) {
            if (future == null) continue;
            future.cancel(false);
        }
        this.subscriptionEndFutures.clear();
    }

    class SubscriptionEndRunnable
    implements Runnable {
        private String subscriptionId;

        public SubscriptionEndRunnable(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public void run() {
            SubscriptionManagerImpl.this.removeSubscription(this.subscriptionId);
        }
    }

    private static interface RegisterDataAndCreateSubscriptionRequest {
        public SubscriptionRequest execute();
    }
}

