/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import io.joynr.dispatching.subscription.AttributePollInterpreter;
import io.joynr.dispatching.subscription.PubSubTimerBase;
import io.joynr.dispatching.subscription.PublicationManager;
import io.joynr.dispatching.subscription.PublicationManagerImpl;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.provider.Promise;
import io.joynr.provider.PromiseListener;
import io.joynr.provider.ProviderContainer;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.TimerTask;
import joynr.OnChangeSubscriptionQos;
import joynr.SubscriptionPublication;
import joynr.UnicastSubscriptionQos;
import joynr.exceptions.ProviderRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicationTimer
extends PubSubTimerBase {
    private static final Logger logger = LoggerFactory.getLogger(PublicationTimer.class);
    private final PublicationManagerImpl.PublicationInformation publicationInformation;
    private final ProviderContainer providerContainer;
    private final AttributePollInterpreter attributePollInterpreter;
    public Method method;
    private final long publicationTtl;
    private final long minInterval;
    private final long period;
    private boolean pendingPublication;
    private final PublicationManager publicationManager;

    public PublicationTimer(PublicationManagerImpl.PublicationInformation publicationInformation, Method method, ProviderContainer providerContainer, PublicationManager publicationManager, AttributePollInterpreter attributePollInterpreter) {
        super(publicationInformation.getQos().getExpiryDateMs(), publicationInformation.getState());
        this.publicationManager = publicationManager;
        UnicastSubscriptionQos qos = publicationInformation.getQos();
        this.publicationInformation = publicationInformation;
        this.publicationTtl = publicationInformation.getQos().getPublicationTtlMs();
        boolean hasSubscriptionHeartBeat = qos instanceof HeartbeatSubscriptionInformation;
        boolean isOnChangeSubscription = qos instanceof OnChangeSubscriptionQos;
        this.period = hasSubscriptionHeartBeat ? ((HeartbeatSubscriptionInformation)qos).getPeriodMs() : 0L;
        this.minInterval = isOnChangeSubscription ? ((OnChangeSubscriptionQos)qos).getMinIntervalMs() : 0L;
        this.providerContainer = providerContainer;
        this.attributePollInterpreter = attributePollInterpreter;
        this.method = method;
        this.pendingPublication = false;
    }

    private void sendPublicationError(JoynrRuntimeException error) {
        SubscriptionPublication publication = new SubscriptionPublication(error, this.publicationInformation.getSubscriptionId());
        this.sendPublication(publication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPublication(final SubscriptionPublication publication) {
        long timeSinceLast = System.currentTimeMillis() - this.state.getTimeOfLastPublication();
        if (timeSinceLast >= this.minInterval) {
            logger.trace("sending subscriptionreply");
            try {
                this.publicationManager.sendSubscriptionPublication(publication, this.publicationInformation);
            }
            catch (IOException e) {
                logger.error("sendPublication error.", (Throwable)e);
            }
            PublicationTimer publicationTimer = this;
            synchronized (publicationTimer) {
                if (this.pendingPublication) {
                    this.pendingPublication = false;
                    this.notify();
                }
            }
            logger.trace("sent subscriptionreply @ " + this.state.getTimeOfLastPublication());
        } else {
            PublicationTimer publicationTimer = this;
            synchronized (publicationTimer) {
                if (!this.pendingPublication) {
                    this.pendingPublication = true;
                    final long timeToWait = this.minInterval - timeSinceLast;
                    logger.trace("TimeToWait for subscription {}: {}", (Object)publication.getSubscriptionId(), (Object)timeToWait);
                    new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            PublicationTimer publicationTimer = PublicationTimer.this;
                            synchronized (publicationTimer) {
                                try {
                                    PublicationTimer.this.wait(timeToWait);
                                    if (PublicationTimer.this.pendingPublication) {
                                        PublicationTimer.this.sendPublication(publication);
                                    }
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    logger.trace("DelayedPublicationThread interrupted. No publication is sent.");
                                }
                            }
                        }
                    }).start();
                } else {
                    logger.trace("ignored attribute change. Mininterval {} not yet reached since timeSinceLast: {}", (Object)this.minInterval, (Object)timeSinceLast);
                }
            }
        }
    }

    @Override
    protected TimerTask getTimerTask() {
        return new PublicationTask();
    }

    @Override
    public void startTimer() {
        if (this.period > 0L) {
            super.startTimer(this.period);
        }
    }

    public void sendPublicationNow(SubscriptionPublication publication) {
        if (this.publicationTtl < 0L) {
            logger.info("sendPublicationNow, dropping publication because TTL is in the past");
            return;
        }
        this.sendPublication(publication);
    }

    class PublicationTask
    extends TimerTask {
        PublicationTask() {
        }

        @Override
        public void run() {
            logger.trace("Running PublicationTask");
            if (PublicationTimer.this.publicationTtl > 0L && !PublicationTimer.this.state.isStopped() && !PublicationTimer.this.state.isInterrupted()) {
                long delayUntilNextPublication;
                long timeSinceLast = System.currentTimeMillis() - PublicationTimer.this.state.getTimeOfLastPublication();
                if (timeSinceLast < PublicationTimer.this.period) {
                    logger.debug("no publication necessary. MaxInterval: " + PublicationTimer.this.period + "TimeSinceLast: " + timeSinceLast);
                    delayUntilNextPublication = PublicationTimer.this.period - timeSinceLast;
                    assert (delayUntilNextPublication >= 0L);
                } else {
                    logger.debug("run: executing attributePollInterpreter for attribute " + PublicationTimer.this.publicationInformation.getSubscribedToName());
                    try {
                        Promise<?> attributeGetterPromise = PublicationTimer.this.attributePollInterpreter.execute(PublicationTimer.this.providerContainer, PublicationTimer.this.method);
                        attributeGetterPromise.then(new PromiseListener(){

                            public void onRejection(JoynrException error) {
                                if (error instanceof JoynrRuntimeException) {
                                    PublicationTimer.this.sendPublicationError((JoynrRuntimeException)error);
                                } else {
                                    PublicationTimer.this.sendPublicationError((JoynrRuntimeException)new ProviderRuntimeException("Unexpected exception while calling getter for attribute " + PublicationTimer.this.publicationInformation.getSubscribedToName()));
                                }
                            }

                            public void onFulfillment(Object ... values) {
                                SubscriptionPublication publication = new SubscriptionPublication(Arrays.asList(values[0]), PublicationTimer.this.publicationInformation.getSubscriptionId());
                                PublicationTimer.this.sendPublication(publication);
                            }
                        });
                    }
                    catch (JoynrRuntimeException error) {
                        PublicationTimer.this.sendPublicationError(error);
                    }
                    delayUntilNextPublication = PublicationTimer.this.period;
                }
                if (delayUntilNextPublication >= 0L) {
                    logger.debug("Rescheduling PublicationTimer with delay: " + delayUntilNextPublication);
                    PublicationTimer.this.rescheduleTimer(delayUntilNextPublication);
                } else {
                    logger.info("Negative maxInterval: PublicationTimer is not scheduled. Publications will be sent on change only.");
                }
            }
        }
    }
}

