/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.dispatcher.rpc.ReflectionUtils;
import io.joynr.dispatching.DirectoryListener;
import io.joynr.dispatching.Dispatcher;
import io.joynr.dispatching.ProviderDirectory;
import io.joynr.dispatching.subscription.AttributeListenerImpl;
import io.joynr.dispatching.subscription.AttributePollInterpreter;
import io.joynr.dispatching.subscription.BroadcastListenerImpl;
import io.joynr.dispatching.subscription.MulticastIdUtil;
import io.joynr.dispatching.subscription.PersistedSubscriptionRequest;
import io.joynr.dispatching.subscription.PubSubState;
import io.joynr.dispatching.subscription.PublicationManager;
import io.joynr.dispatching.subscription.PublicationTimer;
import io.joynr.dispatching.subscription.SubscriptionRequestStorage;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrMessageNotSentException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrSendBufferFullException;
import io.joynr.exceptions.SubscriptionException;
import io.joynr.messaging.MessagingQos;
import io.joynr.provider.Promise;
import io.joynr.provider.PromiseListener;
import io.joynr.provider.ProviderContainer;
import io.joynr.provider.SubscriptionPublisherObservable;
import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import io.joynr.pubsub.SubscriptionQos;
import io.joynr.pubsub.publication.AttributeListener;
import io.joynr.pubsub.publication.BroadcastFilter;
import io.joynr.pubsub.publication.BroadcastListener;
import io.joynr.pubsub.publication.MulticastListener;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import joynr.BroadcastFilterParameters;
import joynr.BroadcastSubscriptionRequest;
import joynr.MulticastPublication;
import joynr.MulticastSubscriptionRequest;
import joynr.OnChangeSubscriptionQos;
import joynr.SubscriptionPublication;
import joynr.SubscriptionReply;
import joynr.SubscriptionRequest;
import joynr.UnicastSubscriptionQos;
import joynr.exceptions.ProviderRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PublicationManagerImpl
implements PublicationManager,
DirectoryListener<ProviderContainer>,
ShutdownListener {
    private static final Logger logger = LoggerFactory.getLogger(PublicationManagerImpl.class);
    private final SetMultimap<String, PublicationInformation> queuedSubscriptionRequests;
    private final ConcurrentMap<String, PublicationInformation> subscriptionId2PublicationInformation;
    private final ConcurrentMap<String, PublicationTimer> publicationTimers;
    private final ConcurrentMap<String, ScheduledFuture<?>> subscriptionEndFutures;
    private final ConcurrentMap<String, UnregisterAttributeListener> unregisterAttributeListeners;
    private final ConcurrentMap<String, UnregisterBroadcastListener> unregisterBroadcastListeners;
    private final ConcurrentMap<String, MulticastListener> multicastListeners;
    private AttributePollInterpreter attributePollInterpreter;
    private ScheduledExecutorService cleanupScheduler;
    private Dispatcher dispatcher;
    private ProviderDirectory providerDirectory;
    @Inject(optional=true)
    @Named(value="joynr.messaging.ttlupliftms")
    private long ttlUpliftMs = 0L;
    private SubscriptionRequestStorage subscriptionRequestStorage;

    @Inject
    public PublicationManagerImpl(AttributePollInterpreter attributePollInterpreter, Dispatcher dispatcher, ProviderDirectory providerDirectory, @Named(value="joynr.scheduler.cleanup") ScheduledExecutorService cleanupScheduler, SubscriptionRequestStorage subscriptionRequestStorage, ShutdownNotifier shutdownNotifier) {
        this.dispatcher = dispatcher;
        this.providerDirectory = providerDirectory;
        this.cleanupScheduler = cleanupScheduler;
        this.subscriptionRequestStorage = subscriptionRequestStorage;
        this.queuedSubscriptionRequests = HashMultimap.create();
        this.subscriptionId2PublicationInformation = Maps.newConcurrentMap();
        this.publicationTimers = Maps.newConcurrentMap();
        this.subscriptionEndFutures = Maps.newConcurrentMap();
        this.unregisterAttributeListeners = Maps.newConcurrentMap();
        this.unregisterBroadcastListeners = Maps.newConcurrentMap();
        this.multicastListeners = Maps.newConcurrentMap();
        this.attributePollInterpreter = attributePollInterpreter;
        providerDirectory.addListener(this);
        this.queueSavedSubscriptionRequests();
        shutdownNotifier.registerForShutdown((ShutdownListener)this);
    }

    private void queueSavedSubscriptionRequests() {
        SetMultimap<String, PersistedSubscriptionRequest> persistedSubscriptionRequests = this.subscriptionRequestStorage.getSavedSubscriptionRequests();
        if (persistedSubscriptionRequests == null || persistedSubscriptionRequests.isEmpty()) {
            return;
        }
        try {
            for (String providerId : persistedSubscriptionRequests.keySet()) {
                for (PersistedSubscriptionRequest persistedSubscriptionRequest : persistedSubscriptionRequests.get((Object)providerId)) {
                    this.addSubscriptionRequest(persistedSubscriptionRequest.getProxyParticipantId(), providerId, persistedSubscriptionRequest.getSubscriptonRequest());
                    this.subscriptionRequestStorage.removeSubscriptionRequest(providerId, persistedSubscriptionRequest);
                }
            }
        }
        catch (Exception e) {
            logger.error("unable to queue saved subscription requests: " + e.getMessage());
        }
    }

    private void handleSubscriptionRequest(PublicationInformation publicationInformation, SubscriptionRequest subscriptionRequest, ProviderContainer providerContainer) {
        String subscriptionId = subscriptionRequest.getSubscriptionId();
        SubscriptionQos subscriptionQos = subscriptionRequest.getQos();
        MessagingQos messagingQos = this.createMessagingQos(subscriptionQos);
        try {
            Method method = this.findGetterForAttributeName(providerContainer.getProviderProxy().getClass(), subscriptionRequest.getSubscribedToName());
            this.triggerPublication(publicationInformation, providerContainer, method);
            boolean hasSubscriptionHeartBeat = subscriptionQos instanceof HeartbeatSubscriptionInformation;
            boolean isOnChangeSubscription = subscriptionQos instanceof OnChangeSubscriptionQos;
            if (hasSubscriptionHeartBeat || isOnChangeSubscription) {
                PublicationTimer timer = new PublicationTimer(publicationInformation, method, providerContainer, this, this.attributePollInterpreter);
                timer.startTimer();
                this.publicationTimers.put(subscriptionId, timer);
            }
            if (subscriptionQos instanceof OnChangeSubscriptionQos) {
                this.handleOnChangeSubscription(subscriptionRequest, providerContainer, subscriptionId);
            }
            this.dispatcher.sendSubscriptionReply(publicationInformation.providerParticipantId, publicationInformation.proxyParticipantId, new SubscriptionReply(subscriptionId), messagingQos);
        }
        catch (NoSuchMethodException e) {
            this.cancelPublicationCreation(subscriptionId);
            logger.error("Error subscribing: {}. The provider does not have the requested attribute", (Object)subscriptionRequest);
            this.sendSubscriptionReplyWithError(publicationInformation, subscriptionId, e, messagingQos);
        }
    }

    private MessagingQos createMessagingQos(SubscriptionQos subscriptionQos) {
        MessagingQos messagingQos = new MessagingQos();
        if (subscriptionQos.getExpiryDateMs() == 0L) {
            messagingQos.setTtl_ms(Long.MAX_VALUE);
        } else {
            messagingQos.setTtl_ms(subscriptionQos.getExpiryDateMs() - System.currentTimeMillis());
        }
        return messagingQos;
    }

    private void handleOnChangeSubscription(SubscriptionRequest subscriptionRequest, ProviderContainer providerContainer, String subscriptionId) {
        AttributeListenerImpl attributeListener = new AttributeListenerImpl(subscriptionId, this);
        String attributeName = subscriptionRequest.getSubscribedToName();
        SubscriptionPublisherObservable subscriptionPublisher = providerContainer.getSubscriptionPublisher();
        subscriptionPublisher.registerAttributeListener(attributeName, (AttributeListener)attributeListener);
        this.unregisterAttributeListeners.put(subscriptionId, new UnregisterAttributeListener(subscriptionPublisher, attributeName, attributeListener));
    }

    private void sendSubscriptionReplyWithError(PublicationInformation publicationInformation, String subscriptionId, Exception exception, MessagingQos messagingQos) {
        SubscriptionException subscriptionException = new SubscriptionException(subscriptionId, exception.getMessage());
        SubscriptionReply subscriptionReply = new SubscriptionReply(subscriptionId, subscriptionException);
        this.dispatcher.sendSubscriptionReply(publicationInformation.providerParticipantId, publicationInformation.proxyParticipantId, subscriptionReply, messagingQos);
    }

    private void handleBroadcastSubscriptionRequest(String proxyParticipantId, String providerParticipantId, BroadcastSubscriptionRequest subscriptionRequest, ProviderContainer providerContainer) {
        logger.trace("adding broadcast publication: {}", (Object)subscriptionRequest);
        BroadcastListenerImpl broadcastListener = new BroadcastListenerImpl(subscriptionRequest.getSubscriptionId(), this);
        String broadcastName = subscriptionRequest.getSubscribedToName();
        providerContainer.getSubscriptionPublisher().registerBroadcastListener(broadcastName, (BroadcastListener)broadcastListener);
        this.unregisterBroadcastListeners.put(subscriptionRequest.getSubscriptionId(), new UnregisterBroadcastListener(providerContainer.getSubscriptionPublisher(), broadcastName, broadcastListener));
        String subscriptionId = subscriptionRequest.getSubscriptionId();
        SubscriptionQos subscriptionQos = subscriptionRequest.getQos();
        MessagingQos messagingQos = this.createMessagingQos(subscriptionQos);
        SubscriptionReply subscriptionReply = new SubscriptionReply(subscriptionId);
        this.dispatcher.sendSubscriptionReply(providerParticipantId, proxyParticipantId, subscriptionReply, messagingQos);
    }

    private void handleMulticastSubscriptionRequest(String proxyParticipantId, String providerParticipantId, MulticastSubscriptionRequest subscriptionRequest, ProviderContainer providerContainer) {
        logger.trace("Received multicast subscription request {} for provider with participant ID {}", (Object)subscriptionRequest, (Object)providerParticipantId);
        this.dispatcher.sendSubscriptionReply(providerParticipantId, proxyParticipantId, new SubscriptionReply(subscriptionRequest.getSubscriptionId()), this.createMessagingQos(subscriptionRequest.getQos()));
    }

    private void addSubscriptionRequest(String proxyParticipantId, String providerParticipantId, SubscriptionRequest subscriptionRequest, ProviderContainer providerContainer) {
        PublicationInformation publicationInformation = new PublicationInformation(providerParticipantId, proxyParticipantId, subscriptionRequest);
        try {
            long subscriptionEndDelay = this.validateAndGetSubscriptionEndDelay(subscriptionRequest);
            this.removePublicationIfItExists(subscriptionRequest);
            String subscriptionId = subscriptionRequest.getSubscriptionId();
            this.subscriptionId2PublicationInformation.put(subscriptionId, publicationInformation);
            if (subscriptionRequest instanceof BroadcastSubscriptionRequest) {
                this.handleBroadcastSubscriptionRequest(proxyParticipantId, providerParticipantId, (BroadcastSubscriptionRequest)subscriptionRequest, providerContainer);
            } else if (subscriptionRequest instanceof MulticastSubscriptionRequest) {
                this.handleMulticastSubscriptionRequest(proxyParticipantId, providerParticipantId, (MulticastSubscriptionRequest)subscriptionRequest, providerContainer);
            } else {
                this.handleSubscriptionRequest(publicationInformation, subscriptionRequest, providerContainer);
            }
            this.addSubscriptionCleanupIfNecessary(subscriptionRequest, subscriptionEndDelay);
            logger.trace("publication added: " + subscriptionRequest.toString());
        }
        catch (SubscriptionException e) {
            this.sendSubscriptionReplyWithError(e, publicationInformation, subscriptionRequest);
        }
    }

    private void sendSubscriptionReplyWithError(SubscriptionException e, PublicationInformation publicationInformation, SubscriptionRequest subscriptionRequest) {
        SubscriptionQos subscriptionQos = subscriptionRequest.getQos();
        MessagingQos messagingQos = new MessagingQos();
        if (subscriptionQos.getExpiryDateMs() == 0L) {
            messagingQos.setTtl_ms(Long.MAX_VALUE);
        } else {
            messagingQos.setTtl_ms(subscriptionQos.getExpiryDateMs() - System.currentTimeMillis());
        }
        SubscriptionReply subscriptionReply = new SubscriptionReply(publicationInformation.getSubscriptionId(), e);
        this.dispatcher.sendSubscriptionReply(publicationInformation.providerParticipantId, publicationInformation.proxyParticipantId, subscriptionReply, messagingQos);
    }

    private void addSubscriptionCleanupIfNecessary(SubscriptionRequest subscriptionRequest, long subscriptionEndDelay) {
        if (subscriptionRequest.getQos().getExpiryDateMs() != 0L) {
            final String subscriptionId = subscriptionRequest.getSubscriptionId();
            ScheduledFuture<?> subscriptionEndFuture = this.cleanupScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    logger.trace("Publication with Id {} expired...", (Object)subscriptionId);
                    PublicationManagerImpl.this.removePublication(subscriptionId);
                }
            }, subscriptionEndDelay, TimeUnit.MILLISECONDS);
            this.subscriptionEndFutures.put(subscriptionId, subscriptionEndFuture);
        }
    }

    private void removePublicationIfItExists(SubscriptionRequest subscriptionRequest) {
        String subscriptionId = subscriptionRequest.getSubscriptionId();
        if (this.publicationExists(subscriptionId)) {
            logger.trace("updating publication: {}", (Object)subscriptionRequest);
            this.removePublication(subscriptionId);
        } else {
            logger.trace("adding publication: {}", (Object)subscriptionRequest);
        }
    }

    private long validateAndGetSubscriptionEndDelay(SubscriptionRequest subscriptionRequest) {
        SubscriptionQos subscriptionQos = subscriptionRequest.getQos();
        long subscriptionEndDelay = this.getSubscriptionEndDelay(subscriptionQos);
        if (subscriptionEndDelay < 0L) {
            throw new SubscriptionException(subscriptionRequest.getSubscriptionId(), "Subscription expired.");
        }
        return subscriptionEndDelay;
    }

    private long getSubscriptionEndDelay(SubscriptionQos subscriptionQos) {
        long subscriptionEndDelay = subscriptionQos.getExpiryDateMs() == 0L ? 0L : (subscriptionQos.getExpiryDateMs() > Long.MAX_VALUE - this.ttlUpliftMs ? Long.MAX_VALUE - System.currentTimeMillis() : subscriptionQos.getExpiryDateMs() + this.ttlUpliftMs - System.currentTimeMillis());
        return subscriptionEndDelay;
    }

    private void cancelPublicationCreation(String subscriptionId) {
        this.subscriptionId2PublicationInformation.remove(subscriptionId);
        logger.error("Subscription request rejected. Removing publication.");
    }

    private boolean publicationExists(String subscriptionId) {
        return this.subscriptionId2PublicationInformation.containsKey(subscriptionId);
    }

    @Override
    public void addSubscriptionRequest(String proxyParticipantId, String providerParticipantId, SubscriptionRequest subscriptionRequest) {
        this.subscriptionRequestStorage.persistSubscriptionRequest(proxyParticipantId, providerParticipantId, subscriptionRequest);
        if (this.providerDirectory.contains(providerParticipantId)) {
            this.addSubscriptionRequest(proxyParticipantId, providerParticipantId, subscriptionRequest, (ProviderContainer)this.providerDirectory.get(providerParticipantId));
        } else {
            logger.trace("Adding subscription request for non existing provider to queue.");
            PublicationInformation publicationInformation = new PublicationInformation(providerParticipantId, proxyParticipantId, subscriptionRequest);
            this.queuedSubscriptionRequests.put((Object)providerParticipantId, (Object)publicationInformation);
            this.subscriptionId2PublicationInformation.put(subscriptionRequest.getSubscriptionId(), publicationInformation);
        }
    }

    protected void removePublication(String subscriptionId) {
        UnregisterBroadcastListener unregisterBroadcastListener;
        UnregisterAttributeListener unregisterAttributeListener;
        ScheduledFuture future;
        PublicationTimer publicationTimer;
        PublicationInformation publicationInformation = (PublicationInformation)this.subscriptionId2PublicationInformation.remove(subscriptionId);
        if (publicationInformation == null) {
            return;
        }
        Set queuedSubscriptionRequestsForParticipant = this.queuedSubscriptionRequests.get((Object)publicationInformation.getProviderParticipantId());
        if (queuedSubscriptionRequestsForParticipant != null) {
            queuedSubscriptionRequestsForParticipant.remove(publicationInformation);
        }
        if ((publicationTimer = (PublicationTimer)this.publicationTimers.remove(subscriptionId)) != null) {
            publicationTimer.cancel();
        }
        if ((future = (ScheduledFuture)this.subscriptionEndFutures.remove(subscriptionId)) != null) {
            future.cancel(true);
        }
        if ((unregisterAttributeListener = (UnregisterAttributeListener)this.unregisterAttributeListeners.remove(subscriptionId)) != null) {
            unregisterAttributeListener.unregister();
        }
        if ((unregisterBroadcastListener = (UnregisterBroadcastListener)this.unregisterBroadcastListeners.remove(subscriptionId)) != null) {
            unregisterBroadcastListener.unregister();
        }
    }

    @Override
    public void stopPublication(String subscriptionId) {
        PublicationInformation publicationInformation = (PublicationInformation)this.subscriptionId2PublicationInformation.get(subscriptionId);
        if (publicationInformation == null) {
            return;
        }
        try {
            this.removePublication(subscriptionId);
        }
        catch (Exception e) {
            JoynrRuntimeException error = new JoynrRuntimeException("Error stopping subscription " + subscriptionId + ": " + e);
            this.sendPublicationError(error, publicationInformation);
        }
    }

    private void stopPublicationByProviderId(String providerParticipantId) {
        for (PublicationInformation publicationInformation : this.subscriptionId2PublicationInformation.values()) {
            if (!publicationInformation.getProviderParticipantId().equals(providerParticipantId)) continue;
            this.removePublication(publicationInformation.getSubscriptionId());
        }
        if (providerParticipantId != null && this.queuedSubscriptionRequests.containsKey((Object)providerParticipantId)) {
            this.queuedSubscriptionRequests.removeAll((Object)providerParticipantId);
        }
    }

    private boolean isExpired(PublicationInformation publicationInformation) {
        SubscriptionQos subscriptionQos = publicationInformation.subscriptionRequest.getQos();
        long subscriptionEndDelay = this.getSubscriptionEndDelay(subscriptionQos);
        logger.trace("ExpiryDate - System.currentTimeMillis: " + subscriptionEndDelay);
        return subscriptionEndDelay != 0L && subscriptionEndDelay <= 0L;
    }

    private void restoreQueuedSubscription(String providerId, ProviderContainer providerContainer) {
        Set queuedRequests = this.queuedSubscriptionRequests.get((Object)providerId);
        Iterator queuedRequestsIterator = queuedRequests.iterator();
        while (queuedRequestsIterator.hasNext()) {
            PublicationInformation publicationInformation = (PublicationInformation)queuedRequestsIterator.next();
            queuedRequestsIterator.remove();
            if (this.isExpired(publicationInformation)) continue;
            this.addSubscriptionRequest(publicationInformation.getProxyParticipantId(), publicationInformation.getProviderParticipantId(), publicationInformation.subscriptionRequest, providerContainer);
        }
    }

    @Override
    public void attributeValueChanged(String subscriptionId, Object value) {
        if (this.subscriptionId2PublicationInformation.containsKey(subscriptionId)) {
            PublicationInformation publicationInformation = (PublicationInformation)this.subscriptionId2PublicationInformation.get(subscriptionId);
            if (this.isExpired(publicationInformation)) {
                this.removePublication(subscriptionId);
            } else {
                PublicationTimer publicationTimer = (PublicationTimer)this.publicationTimers.get(subscriptionId);
                SubscriptionPublication publication = this.prepareAttributePublication(value, subscriptionId);
                if (publicationTimer != null) {
                    publicationTimer.sendPublicationNow(publication);
                } else {
                    this.sendPublication(publication, publicationInformation);
                }
                logger.trace("attribute changed for subscription id: {} sending publication if delay > minInterval.", (Object)subscriptionId);
            }
        } else {
            logger.trace("subscription {} has expired but attributeValueChanged has been called", (Object)subscriptionId);
        }
    }

    @Override
    public void broadcastOccurred(String subscriptionId, List<BroadcastFilter> filters, Object ... values) {
        if (this.subscriptionId2PublicationInformation.containsKey(subscriptionId)) {
            PublicationInformation publicationInformation = (PublicationInformation)this.subscriptionId2PublicationInformation.get(subscriptionId);
            if (this.processFilterChain(publicationInformation, filters, values)) {
                long minInterval = ((OnChangeSubscriptionQos)publicationInformation.getQos()).getMinIntervalMs();
                if (minInterval <= System.currentTimeMillis() - publicationInformation.getState().getTimeOfLastPublication()) {
                    this.sendPublication(this.prepareBroadcastPublication(Arrays.asList(values), subscriptionId), publicationInformation);
                    logger.trace("event occured changed for subscription id: {} sending publication: ", (Object)subscriptionId);
                } else {
                    logger.trace("Two subsequent broadcasts of event " + publicationInformation.getSubscribedToName() + " occured within minInterval of subscription with id " + publicationInformation.getSubscriptionId() + ". Event will not be sent to the subscribing client.");
                }
            }
        } else {
            logger.trace("subscription {} has expired but eventOccurred has been called", (Object)subscriptionId);
        }
    }

    private boolean processFilterChain(PublicationInformation publicationInformation, List<BroadcastFilter> filters, Object[] values) {
        if (filters != null && filters.size() > 0) {
            BroadcastSubscriptionRequest subscriptionRequest = (BroadcastSubscriptionRequest)publicationInformation.subscriptionRequest;
            BroadcastFilterParameters filterParameters = subscriptionRequest.getFilterParameters();
            for (BroadcastFilter filter : filters) {
                AccessibleObject filterMethod = null;
                try {
                    Method[] methodsOfFilterClass;
                    for (Method method : methodsOfFilterClass = filter.getClass().getMethods()) {
                        if (!method.getName().equals("filter")) continue;
                        filterMethod = method;
                        break;
                    }
                    if (filterMethod == null) {
                        return true;
                    }
                    if (!filterMethod.isAccessible()) {
                        ((Method)filterMethod).setAccessible(true);
                    }
                    Class<?> filterParametersType = ((Method)filterMethod).getParameterTypes()[values.length];
                    BroadcastFilterParameters filterParametersDerived = (BroadcastFilterParameters)filterParametersType.newInstance();
                    filterParametersDerived.setFilterParameters(filterParameters.getFilterParameters());
                    Object[] args = Arrays.copyOf(values, values.length + 1);
                    args[args.length - 1] = filterParametersDerived;
                    if (((Boolean)((Method)filterMethod).invoke(filter, args)).booleanValue()) continue;
                    return false;
                }
                catch (Exception e) {
                    logger.error("processFilterChain error: {}", (Object)e.getMessage());
                    throw new IllegalStateException("processFilterChain: Error in reflection calling filters.", e);
                }
            }
        }
        return true;
    }

    private SubscriptionPublication prepareAttributePublication(Object value, String subscriptionId) {
        return new SubscriptionPublication(Arrays.asList(value), subscriptionId);
    }

    private SubscriptionPublication prepareBroadcastPublication(List<Object> values, String subscriptionId) {
        return new SubscriptionPublication(values, subscriptionId);
    }

    private void sendPublication(SubscriptionPublication publication, PublicationInformation publicationInformation) {
        try {
            this.sendSubscriptionPublication(publication, publicationInformation);
        }
        catch (JoynrRuntimeException | IOException e) {
            logger.error("sendPublication error.", e);
        }
    }

    private void sendPublicationError(JoynrRuntimeException error, PublicationInformation publicationInformation) {
        SubscriptionPublication publication = new SubscriptionPublication(error, publicationInformation.getSubscriptionId());
        this.sendPublication(publication, publicationInformation);
    }

    private void triggerPublication(final PublicationInformation publicationInformation, ProviderContainer providerContainer, Method method) {
        try {
            Promise<?> attributeGetterPromise = this.attributePollInterpreter.execute(providerContainer, method);
            attributeGetterPromise.then(new PromiseListener(){

                public void onRejection(JoynrException error) {
                    if (error instanceof JoynrRuntimeException) {
                        PublicationManagerImpl.this.sendPublicationError((JoynrRuntimeException)error, publicationInformation);
                    } else {
                        PublicationManagerImpl.this.sendPublicationError((JoynrRuntimeException)new ProviderRuntimeException("Unexpected exception while calling getter for attribute " + publicationInformation.getSubscribedToName()), publicationInformation);
                    }
                }

                public void onFulfillment(Object ... values) {
                    PublicationManagerImpl.this.sendPublication(PublicationManagerImpl.this.prepareAttributePublication(values[0], publicationInformation.getSubscriptionId()), publicationInformation);
                }
            });
        }
        catch (JoynrRuntimeException error) {
            this.sendPublicationError(error, publicationInformation);
        }
    }

    private Method findGetterForAttributeName(Class<?> clazz, String attributeName) throws NoSuchMethodException {
        String attributeGetterName = "get" + attributeName.toUpperCase().charAt(0) + attributeName.subSequence(1, attributeName.length());
        return ReflectionUtils.findMethodByParamTypes(clazz, (String)attributeGetterName, (Class[])new Class[0]);
    }

    @Override
    public void sendSubscriptionPublication(SubscriptionPublication publication, PublicationInformation publicationInformation) throws JoynrSendBufferFullException, JoynrMessageNotSentException, JsonGenerationException, JsonMappingException, IOException {
        MessagingQos messagingQos = new MessagingQos();
        messagingQos.setTtl_ms(publicationInformation.getQos().getPublicationTtlMs());
        HashSet<String> toParticipantIds = new HashSet<String>();
        toParticipantIds.add(publicationInformation.proxyParticipantId);
        this.dispatcher.sendSubscriptionPublication(publicationInformation.providerParticipantId, toParticipantIds, publication, messagingQos);
        publicationInformation.getState().updateTimeOfLastPublication();
    }

    @Override
    public void multicastOccurred(String providerParticipantId, String multicastName, String[] partitions, Object ... values) {
        logger.trace("Multicast occurred for {} / {} / {} / {}", new Object[]{providerParticipantId, multicastName, Arrays.toString(partitions), Arrays.toString(values)});
        String multicastId = MulticastIdUtil.createMulticastId(providerParticipantId, multicastName, partitions);
        MulticastPublication multicastPublication = new MulticastPublication(Arrays.asList(values), multicastId);
        MessagingQos messagingQos = new MessagingQos();
        this.dispatcher.sendMulticast(providerParticipantId, multicastPublication, messagingQos);
    }

    @Override
    public void entryAdded(final String providerParticipantId, ProviderContainer providerContainer) {
        this.restoreQueuedSubscription(providerParticipantId, providerContainer);
        MulticastListener multicastListener = new MulticastListener(){

            public void multicastOccurred(String multicastName, String[] partitions, Object[] values) {
                PublicationManagerImpl.this.multicastOccurred(providerParticipantId, multicastName, partitions, values);
            }
        };
        this.multicastListeners.putIfAbsent(providerParticipantId, multicastListener);
        providerContainer.getSubscriptionPublisher().registerMulticastListener((MulticastListener)this.multicastListeners.get(providerParticipantId));
    }

    @Override
    public void entryRemoved(String providerParticipantId) {
        this.stopPublicationByProviderId(providerParticipantId);
        ProviderContainer providerContainer = (ProviderContainer)this.providerDirectory.get(providerParticipantId);
        if (providerContainer != null) {
            providerContainer.getSubscriptionPublisher().unregisterMulticastListener((MulticastListener)this.multicastListeners.remove(providerParticipantId));
        }
    }

    @Override
    public void shutdown() {
        for (ScheduledFuture future : this.subscriptionEndFutures.values()) {
            if (future == null) continue;
            future.cancel(false);
        }
        this.providerDirectory.removeListener(this);
    }

    static class UnregisterBroadcastListener {
        private final String broadcastName;
        private final BroadcastListener broadcastListener;
        private final SubscriptionPublisherObservable subscriptionPublisher;

        public UnregisterBroadcastListener(SubscriptionPublisherObservable subscriptionPublisher, String broadcastName, BroadcastListener broadcastListener) {
            this.subscriptionPublisher = subscriptionPublisher;
            this.broadcastName = broadcastName;
            this.broadcastListener = broadcastListener;
        }

        public void unregister() {
            this.subscriptionPublisher.unregisterBroadcastListener(this.broadcastName, this.broadcastListener);
        }
    }

    static class UnregisterAttributeListener {
        private final String attributeName;
        private final AttributeListener attributeListener;
        private final SubscriptionPublisherObservable subscriptionPublisher;

        public UnregisterAttributeListener(SubscriptionPublisherObservable subscriptionPublisher, String attributeName, AttributeListener attributeListener) {
            this.subscriptionPublisher = subscriptionPublisher;
            this.attributeName = attributeName;
            this.attributeListener = attributeListener;
        }

        public void unregister() {
            this.subscriptionPublisher.unregisterAttributeListener(this.attributeName, this.attributeListener);
        }
    }

    static class PublicationInformation {
        private String providerParticipantId;
        private String proxyParticipantId;
        private SubscriptionRequest subscriptionRequest;
        private PubSubState pubState = new PubSubState();

        PublicationInformation(String providerParticipantId, String proxyParticipantId, SubscriptionRequest subscriptionRequest) {
            this.setProviderParticipantId(providerParticipantId);
            this.subscriptionRequest = subscriptionRequest;
            this.setProxyParticipantId(proxyParticipantId);
        }

        public String getProviderParticipantId() {
            return this.providerParticipantId;
        }

        public void setProviderParticipantId(String providerParticipantId) {
            this.providerParticipantId = providerParticipantId;
        }

        public String getProxyParticipantId() {
            return this.proxyParticipantId;
        }

        public void setProxyParticipantId(String proxyParticipantId) {
            this.proxyParticipantId = proxyParticipantId;
        }

        public String getSubscriptionId() {
            return this.subscriptionRequest.getSubscriptionId();
        }

        public PubSubState getState() {
            return this.pubState;
        }

        public UnicastSubscriptionQos getQos() {
            if (this.subscriptionRequest.getQos() instanceof UnicastSubscriptionQos) {
                return (UnicastSubscriptionQos)this.subscriptionRequest.getQos();
            }
            throw new IllegalArgumentException("Publication information should only be stored for unicast subscription requests");
        }

        public boolean equals(Object arg0) {
            if (!(arg0 instanceof PublicationInformation)) {
                return false;
            }
            PublicationInformation pi = (PublicationInformation)arg0;
            return this.proxyParticipantId.equals(pi.proxyParticipantId) && this.providerParticipantId.equals(pi.providerParticipantId) && this.subscriptionRequest.equals(pi.subscriptionRequest);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.proxyParticipantId == null ? 0 : this.proxyParticipantId.hashCode());
            result = 31 * result + (this.providerParticipantId == null ? 0 : this.providerParticipantId.hashCode());
            result = 31 * result + (this.subscriptionRequest == null ? 0 : this.subscriptionRequest.hashCode());
            return result;
        }

        public String getSubscribedToName() {
            return this.subscriptionRequest.getSubscribedToName();
        }
    }
}

