/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import io.joynr.dispatching.subscription.PubSubState;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PubSubTimerBase {
    protected long expiryDate;
    protected PubSubState state;
    protected Timer timer = new Timer();
    private static final Logger logger = LoggerFactory.getLogger(PubSubTimerBase.class);

    public PubSubTimerBase(long expiryDate, PubSubState state) {
        this.state = state;
        this.expiryDate = expiryDate;
    }

    public void startTimer() {
        this.startTimer(0L);
    }

    public void startTimer(long delay) {
        this.rescheduleTimer(delay);
    }

    protected boolean isExpiredInMs(long delay_ms) {
        return this.expiryDate != 0L && System.currentTimeMillis() + delay_ms > this.expiryDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Timer timer = this.timer;
        synchronized (timer) {
            this.state.stop();
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleTimer(long delay) {
        Timer timer = this.timer;
        synchronized (timer) {
            boolean isExpiredNow = this.isExpiredInMs(0L);
            boolean isExpiredBeforeNextPublication = this.isExpiredInMs(delay);
            if (!(isExpiredNow || isExpiredBeforeNextPublication || this.state.isStopped())) {
                logger.trace("Rescheduling PubSubTimer with delay {}.", (Object)delay);
                this.timer.schedule(this.getTimerTask(), delay);
            } else {
                logger.trace("Will not reschedule PubSubTimer: " + (isExpiredNow ? "endDate is reached" : (isExpiredBeforeNextPublication ? "endDate will be reached before next publication" : "publication stopped")) + ".");
                logger.trace("SubscriptionEndDate: " + (this.expiryDate == 0L ? "never" : Long.valueOf(this.expiryDate)));
                logger.trace("CurrentSystemTime: " + System.currentTimeMillis());
                logger.trace("Delay: ", (Object)delay);
            }
        }
    }

    protected abstract TimerTask getTimerTask();
}

