/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import io.joynr.exceptions.JoynrIllegalStateException;
import java.util.regex.Pattern;

public final class MulticastIdUtil {
    private static final Pattern VALID_PARTITION_REGEX = Pattern.compile("^[a-zA-Z0-9]+$");
    private static final String SINGLE_POSITION_WILDCARD = "+";
    private static final String MULTI_LEVEL_WILDCARD = "*";

    private MulticastIdUtil() {
    }

    public static String createMulticastId(String providerParticipantId, String multicastName, String ... partitions) {
        StringBuilder builder = new StringBuilder(providerParticipantId);
        builder.append("/").append(multicastName);
        if (partitions != null && partitions.length > 0) {
            for (int index = 0; index < partitions.length; ++index) {
                builder.append("/").append(MulticastIdUtil.validatePartition(partitions, index));
            }
        }
        return builder.toString();
    }

    private static String validatePartition(String[] partitions, int index) {
        String partition = partitions[index];
        if (!(VALID_PARTITION_REGEX.matcher(partition).matches() || SINGLE_POSITION_WILDCARD.equals(partition) || partitions.length == index + 1 && MULTI_LEVEL_WILDCARD.equals(partition))) {
            throw new JoynrIllegalStateException(String.format("Partition %s contains invalid characters.%nMust only contain a-z A-Z 0-9, or by a single position wildcard (+),%nor the last partition may be a multi-level wildcard (*).", partition));
        }
        return partition;
    }

    public static String sanitizeForPartition(String value) {
        return value.replaceAll("[^a-zA-Z0-9]", "");
    }
}

