/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import io.joynr.dispatching.subscription.PubSubState;
import io.joynr.dispatching.subscription.PubSubTimerBase;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.pubsub.subscription.AttributeSubscriptionListener;
import java.util.TimerTask;
import joynr.exceptions.PublicationMissedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissedPublicationTimer
extends PubSubTimerBase {
    private final AttributeSubscriptionListener<?> callback;
    private final long alertAfterInterval_ms;
    private long expectedInterval_ms;
    private final String subscriptionId;
    private static final Logger logger = LoggerFactory.getLogger(MissedPublicationTimer.class);

    public MissedPublicationTimer(long expiryDate, long expectedInterval_ms, long alertAfterInterval_ms, AttributeSubscriptionListener<?> callback, PubSubState state, String subscrptionId) {
        super(expiryDate, state);
        this.expectedInterval_ms = expectedInterval_ms;
        this.alertAfterInterval_ms = alertAfterInterval_ms;
        this.callback = callback;
        this.subscriptionId = subscrptionId;
        this.startTimer();
    }

    @Override
    protected TimerTask getTimerTask() {
        return new MissedPublicationTask();
    }

    class MissedPublicationTask
    extends TimerTask {
        MissedPublicationTask() {
        }

        @Override
        public void run() {
            if (!MissedPublicationTimer.this.isExpiredInMs(0L) && !MissedPublicationTimer.this.state.isStopped()) {
                boolean publicationInTime;
                long delay = 0L;
                long timeSinceLastPublication = System.currentTimeMillis() - MissedPublicationTimer.this.state.getTimeOfLastPublication();
                boolean bl = publicationInTime = timeSinceLastPublication < MissedPublicationTimer.this.alertAfterInterval_ms;
                if (publicationInTime) {
                    logger.trace("Publication in time.");
                    delay = MissedPublicationTimer.this.alertAfterInterval_ms - timeSinceLastPublication;
                } else {
                    logger.trace("Missed publication of subscriptionId \"" + MissedPublicationTimer.this.subscriptionId + "\"!");
                    delay = MissedPublicationTimer.this.alertAfterInterval_ms - this.timeSinceLastExpectedPublication(timeSinceLastPublication);
                    MissedPublicationTimer.this.callback.onError((JoynrRuntimeException)new PublicationMissedException(MissedPublicationTimer.this.subscriptionId));
                }
                logger.trace("Rescheduling MissedPublicationTimer with delay: " + delay);
                MissedPublicationTimer.this.rescheduleTimer(delay);
            } else {
                logger.trace("Subscription expired. MissedPublicationTimer is not rescheduled.");
            }
        }

        private long timeSinceLastExpectedPublication(long timeSinceLastPublication) {
            return timeSinceLastPublication % MissedPublicationTimer.this.expectedInterval_ms;
        }
    }
}

