/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.dispatching.subscription.PersistedSubscriptionRequest;
import io.joynr.dispatching.subscription.SubscriptionRequestStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import joynr.SubscriptionRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FileSubscriptionRequestStorage
implements SubscriptionRequestStorage {
    private static final Logger logger = LoggerFactory.getLogger(FileSubscriptionRequestStorage.class);
    SetMultimap<String, PersistedSubscriptionRequest> persistedSubscriptionRequests = HashMultimap.create();
    private String persistenceFileName;

    @Inject
    public FileSubscriptionRequestStorage(@Named(value="joynr.dispatching.subscription.subscriptionrequests_persistence_file") String persistenceFileName) {
        this.persistenceFileName = persistenceFileName;
        this.deserializeFromFile();
    }

    @Override
    public synchronized SetMultimap<String, PersistedSubscriptionRequest> getSavedSubscriptionRequests() {
        return this.persistedSubscriptionRequests;
    }

    @Override
    public synchronized void persistSubscriptionRequest(String proxyId, String providerId, SubscriptionRequest subscriptionRequest) {
        this.persistedSubscriptionRequests.put((Object)providerId, (Object)new PersistedSubscriptionRequest(proxyId, providerId, subscriptionRequest));
        this.persistSubscriptionRequestsToFile();
    }

    @Override
    public synchronized void removeSubscriptionRequest(String providerId, PersistedSubscriptionRequest subscriptionRequest) {
        this.persistedSubscriptionRequests.remove((Object)providerId, (Object)subscriptionRequest);
        this.persistSubscriptionRequestsToFile();
    }

    private synchronized void deserializeFromFile() {
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(this.persistenceFileName));
            this.persistedSubscriptionRequests = (SetMultimap)inputStream.readObject();
        }
        catch (Exception e) {
            logger.warn("unable to read saved subscription requests: " + e.getMessage());
            this.deleteCorruptedPersistenceFile();
            this.persistedSubscriptionRequests = HashMultimap.create();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("unable to close subscription requests persistence file", (Throwable)e);
                }
            }
        }
    }

    private void deleteCorruptedPersistenceFile() {
        try {
            new File(this.persistenceFileName).delete();
        }
        catch (Exception e) {
            logger.error("unable to delete unparsable persistence file: " + this.persistenceFileName, (Throwable)e);
        }
    }

    private void persistSubscriptionRequestsToFile() {
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(this.persistenceFileName, false));
            outputStream.writeObject(this.persistedSubscriptionRequests);
        }
        catch (Exception e) {
            logger.error("unable to write to saved subscripton requests", (Throwable)e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    logger.error("unable to close saved subscripton requests", (Throwable)e);
                }
            }
        }
    }
}

