/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.subscription;

import io.joynr.JoynrVersion;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.provider.Promise;
import io.joynr.provider.ProviderContainer;
import io.joynr.util.AnnotationUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import joynr.exceptions.MethodInvocationException;
import joynr.exceptions.ProviderRuntimeException;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributePollInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(AttributePollInterpreter.class);

    @Nonnull
    public Promise<?> execute(ProviderContainer providerContainer, Method method) {
        String interfaceName = providerContainer.getInterfaceName();
        Object returnValueFromProvider = null;
        try {
            returnValueFromProvider = method.invoke(providerContainer.getProviderProxy(), new Object[0]);
        }
        catch (IllegalAccessException e) {
            String message = String.format("Method \"%s\" is not accessible on \"%s\" provider (exception: \"%s\").", method.getName(), interfaceName, e.toString());
            logger.error(message, (Throwable)e);
            JoynrVersion joynrVersion = (JoynrVersion)AnnotationUtil.getAnnotation(providerContainer.getProviderProxy().getClass(), JoynrVersion.class);
            throw new MethodInvocationException(message, new Version(Integer.valueOf(joynrVersion.major()), Integer.valueOf(joynrVersion.minor())));
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Provider of interface \"%s\" does not declare method \"%s\" (exception: \"%s\")", interfaceName, method.getName(), e.toString());
            logger.error(message, (Throwable)e);
            JoynrVersion joynrVersion = (JoynrVersion)AnnotationUtil.getAnnotation(providerContainer.getProviderProxy().getClass(), JoynrVersion.class);
            throw new MethodInvocationException(message, new Version(Integer.valueOf(joynrVersion.major()), Integer.valueOf(joynrVersion.minor())));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            String message = String.format("Calling method \"%s\" on \"%s\" provider threw an exception: \"%s\"", method.getName(), interfaceName, cause == null ? e.toString() : cause.toString());
            logger.error(message, (Throwable)e);
            throw new ProviderRuntimeException(cause == null ? e.toString() : cause.toString());
        }
        catch (Exception e) {
            String message = String.format("Calling method \"%s\" on \"%s\" provider threw an unexpected exception: \"%s\"", method.getName(), interfaceName, e.toString());
            logger.error(message, (Throwable)e);
            JoynrVersion joynrVersion = (JoynrVersion)AnnotationUtil.getAnnotation(providerContainer.getProviderProxy().getClass(), JoynrVersion.class);
            throw new MethodInvocationException(message, new Version(Integer.valueOf(joynrVersion.major()), Integer.valueOf(joynrVersion.minor())));
        }
        if (returnValueFromProvider == null) {
            String message = String.format("Calling method \"%s\" on \"%s\" provider returned \"null\".", method.getName(), interfaceName);
            logger.error(message);
            throw new JoynrRuntimeException(message);
        }
        Promise returnedPromiseFromProvider = null;
        try {
            returnedPromiseFromProvider = (Promise)returnValueFromProvider;
        }
        catch (ClassCastException e) {
            String message = String.format("Calling method \"%s\" on \"%s\" provider did not return a promise.", method.getName(), interfaceName);
            logger.error(message, (Throwable)e);
            throw new JoynrRuntimeException(message, (Throwable)e);
        }
        return returnedPromiseFromProvider;
    }
}

