/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.rpc;

import io.joynr.dispatching.rpc.ReplyCaller;
import java.util.List;
import joynr.Reply;
import joynr.Request;

public class SynchronizedReplyCaller
implements ReplyCaller {
    private List<Object> responsePayloadContainer;
    private final String fromParticipantId;
    private final String requestReplyId;
    private final Request request;

    public SynchronizedReplyCaller(String fromParticipantId, String requestReplyId, Request request) {
        this.fromParticipantId = fromParticipantId;
        this.requestReplyId = requestReplyId;
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageCallBack(Reply payload) {
        if (this.responsePayloadContainer == null) {
            throw new IllegalStateException("SynchronizedReplyCaller: ResponseContainer not set!");
        }
        List<Object> list = this.responsePayloadContainer;
        synchronized (list) {
            this.responsePayloadContainer.add(payload);
            this.responsePayloadContainer.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void error(Throwable error) {
        List<Object> list = this.responsePayloadContainer;
        synchronized (list) {
            this.responsePayloadContainer.add(error);
            this.responsePayloadContainer.notify();
        }
    }

    public void setResponseContainer(List<Object> responsePayloadContainer) {
        this.responsePayloadContainer = responsePayloadContainer;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ReplyCaller: ");
        stringBuilder.append("\r\n");
        stringBuilder.append("sender: ");
        stringBuilder.append(this.fromParticipantId);
        stringBuilder.append("\r\n");
        stringBuilder.append("requestReplyId: ");
        stringBuilder.append(this.requestReplyId);
        stringBuilder.append("\r\n");
        stringBuilder.append("request: ");
        stringBuilder.append(this.request);
        stringBuilder.append("\r\n");
        return stringBuilder.toString();
    }

    @Override
    public String getRequestReplyId() {
        return this.requestReplyId;
    }
}

