/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.rpc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.CheckForNull;
import joynr.MethodMetaInformation;
import joynr.Reply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcUtils {
    private static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);
    @Inject
    private static ObjectMapper objectMapper;

    @CheckForNull
    public static Object reconstructReturnedObject(Method method, MethodMetaInformation methodMetaInformation, Object ... response) {
        Object responsePayload = null;
        if (response.length == 1) {
            responsePayload = objectMapper.convertValue(response[0], method.getReturnType());
        } else if (response.length > 1) {
            try {
                RpcUtils.convertMultioutResponseToCorrectTypes(method, response);
                Class[] constructorParameterTypes = new Class[]{Object[].class};
                responsePayload = method.getReturnType().getConstructor(constructorParameterTypes).newInstance(new Object[]{response});
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                logger.error("error calling multi-out method: {}. Unable to recreate return object. Returning NULL instead: " + method.getName(), (Throwable)e);
            }
        }
        return responsePayload;
    }

    @CheckForNull
    public static Object[] reconstructCallbackReplyObject(Method method, MethodMetaInformation methodMetaInformation, Reply response) {
        if (methodMetaInformation.getCallbackAnnotation() == null) {
            throw new IllegalStateException("Received a reply to a rpc method call without callback annotation including deserializationType");
        }
        int responseParameterCount = response.getResponse().length;
        Object[] responsePayload = null;
        if (responseParameterCount == 0) {
            responsePayload = new Object[]{};
        } else if (responseParameterCount == 1) {
            responsePayload = new Object[1];
            try {
                responsePayload[0] = objectMapper.convertValue(response.getResponse()[0], methodMetaInformation.getCallbackAnnotation().deserializationType());
            }
            catch (IllegalArgumentException e) {
                logger.error("error calling method: {}. Unable to recreate response for callback. Returning NULL instead" + method.getName(), (Throwable)e);
            }
        } else if (response.getResponse().length > 1) {
            RpcUtils.convertMultioutResponseToCorrectTypes(method, response.getResponse());
            responsePayload = response.getResponse();
        }
        return responsePayload;
    }

    private static void convertMultioutResponseToCorrectTypes(Method method, Object ... response) {
        try {
            Method getDatatypes = method.getReturnType().getMethod("getDatatypes", new Class[0]);
            Class[] responseDatatypes = (Class[])getDatatypes.invoke(null, new Object[0]);
            for (int i = 0; i < response.length; ++i) {
                response[i] = objectMapper.convertValue(response[i], responseDatatypes[i]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("error calling method. Unable to recreate response for callback: Returning NULL instead: " + method.getName(), (Throwable)e);
        }
    }
}

