/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.rpc;

import io.joynr.dispatching.rpc.ReplyCaller;
import io.joynr.dispatching.rpc.RpcUtils;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.proxy.Future;
import io.joynr.proxy.ICallback;
import io.joynr.proxy.ICallbackWithModeledError;
import java.lang.reflect.Method;
import javax.annotation.CheckForNull;
import joynr.MethodMetaInformation;
import joynr.Reply;
import joynr.exceptions.ApplicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcAsyncRequestReplyCaller<T>
implements ReplyCaller {
    @CheckForNull
    private ICallback callback;
    private Method method;
    private MethodMetaInformation methodMetaInformation;
    private Future<T> future;
    private static final Logger logger = LoggerFactory.getLogger(RpcAsyncRequestReplyCaller.class);
    private String requestReplyId;

    public RpcAsyncRequestReplyCaller(String requestReplyId, @CheckForNull ICallback callback, Future<T> future, Method method, MethodMetaInformation methodMetaInformation) {
        this.requestReplyId = requestReplyId;
        this.callback = callback;
        this.future = future;
        this.method = method;
        this.methodMetaInformation = methodMetaInformation;
    }

    @Override
    public void messageCallBack(Reply payload) {
        Object[] response = null;
        try {
            if (payload.getError() != null) {
                logger.debug("REQUEST returns error: requestReplyId: {}, method {}, response: {}", new Object[]{this.method.getName(), payload.getError(), this.requestReplyId});
                this.errorCallback(payload.getError());
                if (this.future != null) {
                    this.future.onFailure(payload.getError());
                }
            } else {
                response = RpcUtils.reconstructCallbackReplyObject(this.method, this.methodMetaInformation, payload);
                logger.debug("REQUEST returns successful: requestReplyId: {}, method {}, response: {}", new Object[]{this.requestReplyId, this.method.getName(), response});
                if (this.callback != null) {
                    this.callback.resolve(response);
                }
                if (this.future != null) {
                    this.future.resolve(response);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error calling async method: " + this.method.getName(), (Throwable)e);
        }
    }

    @Override
    public void error(Throwable error) {
        Object joynrException = error instanceof JoynrException ? (JoynrException)error : new JoynrRuntimeException(error);
        this.errorCallback((JoynrException)joynrException);
        if (this.future != null) {
            this.future.onFailure(joynrException);
        }
    }

    private void errorCallback(JoynrException error) {
        if (this.callback != null) {
            if (error instanceof JoynrRuntimeException) {
                this.callback.onFailure((JoynrRuntimeException)error);
            } else if (error instanceof ApplicationException) {
                if (this.callback instanceof ICallbackWithModeledError) {
                    ((ICallbackWithModeledError)this.callback).onFailure(((ApplicationException)error).getError());
                } else {
                    this.callback.onFailure(new JoynrRuntimeException("an ApplicationException type was receivedbut none was expected. Is the provider version incompatible with the consumer?"));
                }
            } else {
                this.callback.onFailure(new JoynrRuntimeException("unexpected exception type received: ", (Throwable)error));
            }
        }
    }

    @Override
    public String getRequestReplyId() {
        return this.requestReplyId;
    }
}

