/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.rpc;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.joynr.JoynrVersion;
import io.joynr.context.JoynrMessageScope;
import io.joynr.dispatcher.rpc.ReflectionUtils;
import io.joynr.dispatching.RequestCaller;
import io.joynr.exceptions.JoynrException;
import io.joynr.messaging.JoynrMessageCreator;
import io.joynr.messaging.JoynrMessageMetaInfo;
import io.joynr.provider.CallContext;
import io.joynr.provider.Promise;
import io.joynr.provider.PromiseListener;
import io.joynr.provider.ProviderCallback;
import io.joynr.proxy.MethodSignature;
import io.joynr.util.AnnotationUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import joynr.OneWayRequest;
import joynr.Reply;
import joynr.Request;
import joynr.exceptions.MethodInvocationException;
import joynr.exceptions.ProviderRuntimeException;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInterpreter {
    private static final Logger logger = LoggerFactory.getLogger(RequestInterpreter.class);
    private JoynrMessageScope joynrMessageScope;
    private Provider<JoynrMessageCreator> joynrMessageCreatorProvider;
    private Provider<JoynrMessageMetaInfo> joynrMessageContext;
    private final ConcurrentMap<MethodSignature, Method> methodSignatureToMethodMap = new ConcurrentHashMap<MethodSignature, Method>();

    @Inject
    public RequestInterpreter(JoynrMessageScope joynrMessageScope, Provider<JoynrMessageCreator> joynrMessageCreatorProvider, Provider<JoynrMessageMetaInfo> joynrMessageContext) {
        this.joynrMessageScope = joynrMessageScope;
        this.joynrMessageCreatorProvider = joynrMessageCreatorProvider;
        this.joynrMessageContext = joynrMessageContext;
    }

    private Reply createReply(Request request, Object ... response) {
        return new Reply(request.getRequestReplyId(), response);
    }

    public void execute(final ProviderCallback<Reply> callback, RequestCaller requestCaller, final Request request) {
        Promise promise;
        logger.debug("execute request on provider: {}", (Object)request);
        try {
            promise = (Promise)this.invokeMethod(requestCaller, request);
        }
        catch (MethodInvocationException | ProviderRuntimeException e) {
            logger.warn("execute request on provider failed with exception: {}, request: {}", (Object)e, (Object)request);
            callback.onFailure((JoynrException)e);
            return;
        }
        catch (Exception e) {
            JoynrVersion joynrVersion = (JoynrVersion)AnnotationUtil.getAnnotation(requestCaller.getProxy().getClass(), JoynrVersion.class);
            MethodInvocationException methodInvocationException = new MethodInvocationException(e, new Version(Integer.valueOf(joynrVersion.major()), Integer.valueOf(joynrVersion.minor())));
            logger.warn("execute request on provider failed with exception: {}, request: {}", (Object)methodInvocationException, (Object)request);
            callback.onFailure((JoynrException)methodInvocationException);
            return;
        }
        promise.then(new PromiseListener(){

            public void onRejection(JoynrException error) {
                logger.debug("execute request on provider onRejection: {}, request: {}", (Object)error, (Object)request);
                callback.onFailure(error);
            }

            public void onFulfillment(Object ... values) {
                logger.debug("execute request on provider onFulfillment: {}, request: {}", (Object)values, (Object)request);
                callback.onSuccess((Object)RequestInterpreter.this.createReply(request, values));
            }
        });
    }

    public Object invokeMethod(RequestCaller requestCaller, OneWayRequest request) {
        MethodSignature methodSignature = new MethodSignature(requestCaller, request.getMethodName(), request.getParamDatatypes());
        this.ensureMethodMetaInformationPresent(requestCaller, request, methodSignature);
        Method method = (Method)this.methodSignatureToMethodMap.get(methodSignature);
        Object[] params = null;
        try {
            if (method.getParameterTypes().length > 0) {
                params = request.getParams();
            }
            this.joynrMessageScope.activate();
            this.setContext(requestCaller, request);
            logger.trace("invoke provider method {}({})", (Object)method.getName(), (Object)(params == null ? "" : params));
            Object object = requestCaller.invoke(method, params);
            return object;
        }
        catch (IllegalAccessException e) {
            logger.error("RequestInterpreter: Received an RPC invocation for a non public method {}", (Object)request);
            JoynrVersion joynrVersion = (JoynrVersion)AnnotationUtil.getAnnotation(requestCaller.getProxy().getClass(), JoynrVersion.class);
            throw new MethodInvocationException((Exception)e, new Version(Integer.valueOf(joynrVersion.major()), Integer.valueOf(joynrVersion.minor())));
        }
        catch (InvocationTargetException e) {
            logger.debug("invokeMethod error", (Throwable)e);
            Throwable cause = e.getCause();
            logger.error("RequestInterpreter: Could not perform an RPC invocation: {}", (Object)(cause == null ? e.toString() : cause.getMessage()));
            throw new ProviderRuntimeException(cause == null ? e.toString() : cause.toString());
        }
        finally {
            requestCaller.removeContext();
            this.joynrMessageScope.deactivate();
        }
    }

    private void setContext(RequestCaller requestCaller, OneWayRequest request) {
        String creatorUserId = request.getCreatorUserId();
        Map<String, Serializable> context = request.getContext();
        ((JoynrMessageCreator)this.joynrMessageCreatorProvider.get()).setMessageCreatorId(creatorUserId);
        ((JoynrMessageMetaInfo)this.joynrMessageContext.get()).setMessageContext(context);
        CallContext callContext = new CallContext();
        callContext.setContext(context);
        callContext.setPrincipal(creatorUserId);
        requestCaller.setContext(callContext);
    }

    private void ensureMethodMetaInformationPresent(RequestCaller requestCaller, OneWayRequest request, MethodSignature methodSignature) {
        try {
            if (!this.methodSignatureToMethodMap.containsKey(methodSignature)) {
                Method method = ReflectionUtils.findMethodByParamTypeNames(methodSignature.getRequestCaller().getProxy().getClass(), (String)methodSignature.getMethodName(), methodSignature.getParameterTypeNames());
                this.methodSignatureToMethodMap.putIfAbsent(methodSignature, method);
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("RequestInterpreter: Received an RPC invocation for a non existing method" + request, (Throwable)e);
            JoynrVersion joynrVersion = (JoynrVersion)AnnotationUtil.getAnnotation(requestCaller.getProxy().getClass(), JoynrVersion.class);
            throw new MethodInvocationException(e.toString(), new Version(Integer.valueOf(joynrVersion.major()), Integer.valueOf(joynrVersion.minor())));
        }
    }
}

