/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching.rpc;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.common.ExpiryDate;
import io.joynr.dispatching.Directory;
import io.joynr.dispatching.rpc.ReplyCaller;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.exceptions.JoynrTimeoutException;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReplyCallerDirectory
extends Directory<ReplyCaller>
implements ShutdownListener {
    private boolean shutdown = false;
    private static final Logger logger = LoggerFactory.getLogger(ReplyCallerDirectory.class);
    private ScheduledExecutorService cleanupScheduler;
    private ConcurrentMap<String, ScheduledFuture<?>> cleanupSchedulerFuturesMap = null;

    @Inject
    public ReplyCallerDirectory(@Named(value="joynr.scheduler.cleanup") ScheduledExecutorService cleanupScheduler, ShutdownNotifier shutdownNotifier) {
        this.cleanupScheduler = cleanupScheduler;
        this.cleanupSchedulerFuturesMap = new ConcurrentHashMap();
        shutdownNotifier.registerForShutdown((ShutdownListener)this);
    }

    public void addReplyCaller(final String requestReplyId, ReplyCaller replyCaller, ExpiryDate roundTripTtlExpirationDate) {
        logger.trace("putReplyCaller: " + requestReplyId + " expiryDate: " + roundTripTtlExpirationDate);
        if (super.contains(requestReplyId)) {
            logger.error("RequestReplyId should not be replicated: {}", (Object)requestReplyId);
        } else {
            super.add(requestReplyId, replyCaller);
            try {
                ScheduledFuture<?> cleanupSchedulerFuture = this.cleanupScheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        ReplyCallerDirectory.this.removeExpiredReplyCaller(requestReplyId);
                    }
                }, roundTripTtlExpirationDate.getRelativeTtl(), TimeUnit.MILLISECONDS);
                this.cleanupSchedulerFuturesMap.put(requestReplyId, cleanupSchedulerFuture);
            }
            catch (RejectedExecutionException e) {
                if (this.shutdown) {
                    throw new JoynrShutdownException("shutdown in ReplyCallerDirectory");
                }
                throw new JoynrRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public ReplyCaller remove(String id) {
        ReplyCaller replyCaller = (ReplyCaller)super.remove(id);
        ScheduledFuture future = (ScheduledFuture)this.cleanupSchedulerFuturesMap.remove(id);
        if (future != null) {
            future.cancel(false);
        }
        return replyCaller;
    }

    private void removeExpiredReplyCaller(String requestReplyId) {
        ReplyCaller outstandingReplyCaller = this.remove(requestReplyId);
        if (outstandingReplyCaller == null) {
            return;
        }
        logger.debug("Replycaller with requestReplyId {} was removed because TTL expired", (Object)requestReplyId);
        outstandingReplyCaller.error((Throwable)new JoynrTimeoutException(System.currentTimeMillis()));
    }

    public void shutdown() {
        for (ScheduledFuture cleanupSchedulerFuture : this.cleanupSchedulerFuturesMap.values()) {
            cleanupSchedulerFuture.cancel(false);
        }
        this.shutdown = true;
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

