/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching;

import io.joynr.common.ExpiryDate;
import io.joynr.dispatching.ContentWithExpiryDate;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OneWayCallable
extends ContentWithExpiryDate<Callable<Void>> {
    private static final Logger logger = LoggerFactory.getLogger(OneWayCallable.class);
    private String requestDescriptor;

    public OneWayCallable(Callable<Void> requestHandler, ExpiryDate expiryDate, String requestDescriptor) {
        super(requestHandler, expiryDate);
        this.requestDescriptor = requestDescriptor;
    }

    public void call() {
        if (this.isExpired()) {
            logger.warn("One-way request {} is expired. Not executing.", (Object)this.requestDescriptor);
        } else {
            try {
                ((Callable)this.getContent()).call();
            }
            catch (Exception e) {
                logger.error("Error while executing one-way request {}.", (Object)this.requestDescriptor, (Object)e);
            }
        }
    }
}

