/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.common.ExpiryDate;
import io.joynr.dispatching.DispatcherUtils;
import io.joynr.messaging.JoynrMessageProcessor;
import io.joynr.messaging.MessagingQos;
import io.joynr.messaging.MessagingQosEffort;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import joynr.BroadcastSubscriptionRequest;
import joynr.MulticastPublication;
import joynr.MulticastSubscriptionRequest;
import joynr.MutableMessage;
import joynr.OneWayRequest;
import joynr.Reply;
import joynr.Request;
import joynr.SubscriptionPublication;
import joynr.SubscriptionReply;
import joynr.SubscriptionRequest;
import joynr.SubscriptionStop;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableMessageFactory {
    private static final String REQUEST_REPLY_ID_CUSTOM_HEADER = "z4";
    private final Set<JoynrMessageProcessor> messageProcessors;
    private ObjectMapper objectMapper;
    @Inject(optional=true)
    @Named(value="joynr.messaging.ttlupliftms")
    private long ttlUpliftMs = 0L;
    private static final Logger logger = LoggerFactory.getLogger(MutableMessageFactory.class);

    @Inject
    public MutableMessageFactory(ObjectMapper objectMapper, Set<JoynrMessageProcessor> messageProcessors) {
        this.objectMapper = objectMapper;
        this.messageProcessors = messageProcessors;
    }

    private MutableMessage createMessage(String joynrMessageType, String fromParticipantId, String toParticipantId, Object payload, MessagingQos messagingQos) {
        return this.createMessage(joynrMessageType, fromParticipantId, toParticipantId, payload, messagingQos, true);
    }

    private MutableMessage createMessage(String joynrMessageType, String fromParticipantId, String toParticipantId, Object payload, MessagingQos messagingQos, boolean upliftTtl) {
        ExpiryDate expiryDate = !upliftTtl ? DispatcherUtils.convertTtlToExpirationDate(messagingQos.getRoundTripTtl_ms()) : (messagingQos.getRoundTripTtl_ms() > Long.MAX_VALUE - this.ttlUpliftMs ? DispatcherUtils.convertTtlToExpirationDate(Long.MAX_VALUE) : DispatcherUtils.convertTtlToExpirationDate(messagingQos.getRoundTripTtl_ms() + this.ttlUpliftMs));
        MutableMessage message = new MutableMessage();
        message.setType(joynrMessageType);
        if (messagingQos.getEffort() != null && !MessagingQosEffort.NORMAL.equals((Object)messagingQos.getEffort())) {
            message.setEffort(String.valueOf(messagingQos.getEffort()));
        }
        message.setSender(fromParticipantId);
        message.setRecipient(toParticipantId);
        message.setTtlAbsolute(true);
        message.setTtlMs(expiryDate.getValue());
        message.setPayload(this.serializePayload(payload));
        message.setCustomHeaders(messagingQos.getCustomMessageHeaders());
        message.setCompressed(messagingQos.getCompress());
        for (JoynrMessageProcessor processor : this.messageProcessors) {
            message = processor.processOutgoing(message);
        }
        logger.debug("Message {} has expiry date: {}", (Object)message.getId(), (Object)expiryDate);
        return message;
    }

    public MutableMessage createOneWayRequest(String fromParticipantId, String toParticipantId, OneWayRequest request, MessagingQos messagingQos) {
        return this.createMessage("o", fromParticipantId, toParticipantId, request, messagingQos);
    }

    public MutableMessage createRequest(String fromParticipantId, String toParticipantId, Request request, MessagingQos messagingQos) {
        MutableMessage msg = this.createMessage("rq", fromParticipantId, toParticipantId, request, messagingQos);
        this.addRequestReplyIdCustomHeader(msg, request.getRequestReplyId());
        return msg;
    }

    private MutableMessage addRequestReplyIdCustomHeader(MutableMessage msg, String requestReplyId) {
        HashMap customHeaders = Maps.newHashMap();
        customHeaders.put(REQUEST_REPLY_ID_CUSTOM_HEADER, requestReplyId);
        msg.setCustomHeaders((Map)customHeaders);
        return msg;
    }

    public MutableMessage createReply(String fromParticipantId, String toParticipantId, Reply reply, MessagingQos messagingQos) {
        MutableMessage msg = this.createMessage("rp", fromParticipantId, toParticipantId, reply, messagingQos, false);
        this.addRequestReplyIdCustomHeader(msg, reply.getRequestReplyId());
        return msg;
    }

    public MutableMessage createSubscriptionReply(String fromParticipantId, String toParticipantId, SubscriptionReply subscriptionReply, MessagingQos messagingQos) {
        MutableMessage msg = this.createMessage("srp", fromParticipantId, toParticipantId, subscriptionReply, messagingQos);
        this.addRequestReplyIdCustomHeader(msg, subscriptionReply.getSubscriptionId());
        return msg;
    }

    public MutableMessage createSubscriptionRequest(String fromParticipantId, String toParticipantId, SubscriptionRequest subscriptionRequest, MessagingQos messagingQos) {
        String messageType = subscriptionRequest instanceof BroadcastSubscriptionRequest ? "brq" : (subscriptionRequest instanceof MulticastSubscriptionRequest ? "mrq" : "arq");
        MutableMessage msg = this.createMessage(messageType, fromParticipantId, toParticipantId, subscriptionRequest, messagingQos);
        this.addRequestReplyIdCustomHeader(msg, subscriptionRequest.getSubscriptionId());
        return msg;
    }

    public MutableMessage createPublication(String fromParticipantId, String toParticipantId, SubscriptionPublication publication, MessagingQos messagingQos) {
        MutableMessage msg = this.createMessage("p", fromParticipantId, toParticipantId, publication, messagingQos);
        this.addRequestReplyIdCustomHeader(msg, publication.getSubscriptionId());
        return msg;
    }

    public MutableMessage createSubscriptionStop(String fromParticipantId, String toParticipantId, SubscriptionStop subscriptionStop, MessagingQos messagingQos) {
        MutableMessage msg = this.createMessage("sst", fromParticipantId, toParticipantId, subscriptionStop, messagingQos);
        this.addRequestReplyIdCustomHeader(msg, subscriptionStop.getSubscriptionId());
        return msg;
    }

    public MutableMessage createMulticast(String fromParticipantId, MulticastPublication multicastPublication, MessagingQos messagingQos) {
        return this.createMessage("m", fromParticipantId, multicastPublication.getMulticastId(), multicastPublication, messagingQos);
    }

    private byte[] serializePayload(Object payload) {
        String serializedPayload;
        assert (payload != null);
        try {
            if (payload.getClass() == String.class) {
                serializedPayload = (String)payload;
            } else {
                serializedPayload = this.objectMapper.writeValueAsString(payload);
                logger.trace("serializePayload as: {}", (Object)serializedPayload);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return serializedPayload.getBytes(Charsets.UTF_8);
    }
}

