/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.dispatching.Dispatcher;
import io.joynr.dispatching.DispatcherUtils;
import io.joynr.dispatching.MutableMessageFactory;
import io.joynr.dispatching.RequestReplyManager;
import io.joynr.dispatching.subscription.PublicationManager;
import io.joynr.dispatching.subscription.SubscriptionManager;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.messaging.MessagingQosEffort;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.messaging.sender.MessageSender;
import io.joynr.provider.ProviderCallback;
import io.joynr.smrf.EncodingException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import joynr.ImmutableMessage;
import joynr.MulticastPublication;
import joynr.MulticastSubscriptionRequest;
import joynr.MutableMessage;
import joynr.OneWayRequest;
import joynr.Reply;
import joynr.Request;
import joynr.SubscriptionPublication;
import joynr.SubscriptionReply;
import joynr.SubscriptionRequest;
import joynr.SubscriptionStop;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherImpl
implements Dispatcher {
    private static final Logger logger = LoggerFactory.getLogger(DispatcherImpl.class);
    private final MutableMessageFactory messageFactory;
    private RequestReplyManager requestReplyManager;
    private SubscriptionManager subscriptionManager;
    private PublicationManager publicationManager;
    private final MessageRouter messageRouter;
    private final MessageSender messageSender;
    private ObjectMapper objectMapper;
    private boolean overrideCompress;

    @Inject
    @Singleton
    public DispatcherImpl(RequestReplyManager requestReplyManager, SubscriptionManager subscriptionManager, PublicationManager publicationManager, MessageRouter messageRouter, MessageSender messageSender, MutableMessageFactory messageFactory, ObjectMapper objectMapper, @Named(value="joynr.messaging.compressreplies") boolean overrideCompress) {
        this.requestReplyManager = requestReplyManager;
        this.subscriptionManager = subscriptionManager;
        this.publicationManager = publicationManager;
        this.messageRouter = messageRouter;
        this.messageSender = messageSender;
        this.messageFactory = messageFactory;
        this.objectMapper = objectMapper;
        this.overrideCompress = overrideCompress;
    }

    @Override
    public void sendSubscriptionRequest(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, SubscriptionRequest subscriptionRequest, MessagingQos messagingQos) {
        for (DiscoveryEntryWithMetaInfo toDiscoveryEntry : toDiscoveryEntries) {
            MutableMessage message = this.messageFactory.createSubscriptionRequest(fromParticipantId, toDiscoveryEntry.getParticipantId(), subscriptionRequest, messagingQos);
            message.setLocalMessage(toDiscoveryEntry.getIsLocal().booleanValue());
            if (subscriptionRequest instanceof MulticastSubscriptionRequest) {
                String multicastId = ((MulticastSubscriptionRequest)subscriptionRequest).getMulticastId();
                this.messageRouter.addMulticastReceiver(multicastId, fromParticipantId, toDiscoveryEntry.getParticipantId());
            }
            logger.debug("Send SubscriptionRequest: subscriptionId: {}, messageId: {}, proxy participantId: {}, provider participantId: {}", new Object[]{subscriptionRequest.getSubscriptionId(), message.getId(), fromParticipantId, toDiscoveryEntry.getParticipantId()});
            this.messageSender.sendMessage(message);
        }
    }

    @Override
    public void sendSubscriptionStop(String fromParticipantId, Set<DiscoveryEntryWithMetaInfo> toDiscoveryEntries, SubscriptionStop subscriptionStop, MessagingQos messagingQos) {
        for (DiscoveryEntryWithMetaInfo toDiscoveryEntry : toDiscoveryEntries) {
            MutableMessage message = this.messageFactory.createSubscriptionStop(fromParticipantId, toDiscoveryEntry.getParticipantId(), subscriptionStop, messagingQos);
            message.setLocalMessage(toDiscoveryEntry.getIsLocal().booleanValue());
            logger.debug("UNREGISTER SUBSCRIPTION call proxy: subscriptionId: {}, messageId: {}, proxy participantId: {}, provider participantId: {}", new Object[]{subscriptionStop.getSubscriptionId(), message.getId(), fromParticipantId, toDiscoveryEntry.getParticipantId()});
            this.messageSender.sendMessage(message);
        }
    }

    @Override
    public void sendSubscriptionPublication(String fromParticipantId, Set<String> toParticipantIds, SubscriptionPublication publication, MessagingQos messagingQos) {
        for (String toParticipantId : toParticipantIds) {
            MutableMessage message = this.messageFactory.createPublication(fromParticipantId, toParticipantId, publication, messagingQos);
            this.messageSender.sendMessage(message);
        }
    }

    public void sendReply(String fromParticipantId, String toParticipantId, Reply reply, long expiryDateMs, Map<String, String> customHeaders, MessagingQosEffort effort, boolean compress) throws IOException {
        MessagingQos messagingQos = new MessagingQos(expiryDateMs, effort);
        messagingQos.getCustomMessageHeaders().putAll(customHeaders);
        if (this.overrideCompress) {
            compress = true;
        }
        messagingQos.setCompress(compress);
        MutableMessage message = this.messageFactory.createReply(fromParticipantId, toParticipantId, reply, messagingQos);
        this.messageSender.sendMessage(message);
    }

    @Override
    public void sendSubscriptionReply(String fromParticipantId, String toParticipantId, SubscriptionReply subscriptionReply, MessagingQos messagingQos) {
        MutableMessage message = this.messageFactory.createSubscriptionReply(fromParticipantId, toParticipantId, subscriptionReply, messagingQos);
        this.messageSender.sendMessage(message);
    }

    private MessagingQosEffort getEffort(ImmutableMessage message) {
        String effortString = message.getEffort();
        if (effortString == null) {
            return null;
        }
        try {
            return MessagingQosEffort.valueOf((String)effortString);
        }
        catch (IllegalArgumentException e) {
            logger.error("received message (id: {}) with invalid effort: {}. Using default effort for reply message.", (Object)message.getId(), (Object)effortString);
            return null;
        }
    }

    public void messageArrived(ImmutableMessage message) {
        String payload;
        if (message == null) {
            logger.error("received message was null");
            return;
        }
        if (!message.isTtlAbsolute()) {
            logger.error("received message with relative ttl (not supported)");
            return;
        }
        long expiryDate = message.getTtlMs();
        Map customHeaders = message.getCustomHeaders();
        if (DispatcherUtils.isExpired(expiryDate)) {
            logger.debug("TTL expired, discarding message : {}", (Object)message);
            return;
        }
        try {
            payload = new String(message.getUnencryptedBody(), Charsets.UTF_8);
        }
        catch (EncodingException e) {
            logger.error("Error reading SMRF message. msgId: {}. from: {} to: {}. Reason: {}. Discarding joynr message.", new Object[]{message.getSender(), message.getRecipient(), message.getId(), e.getMessage()});
            return;
        }
        String type = message.getType();
        try {
            if ("rp".equals(type)) {
                Reply reply = (Reply)this.objectMapper.readValue(payload, Reply.class);
                logger.trace("Parsed reply from message payload :" + payload);
                this.handle(reply);
            } else if ("srp".equals(type)) {
                SubscriptionReply subscriptionReply = (SubscriptionReply)this.objectMapper.readValue(payload, SubscriptionReply.class);
                logger.trace("Parsed subscription reply from message payload :" + payload);
                this.handle(subscriptionReply);
            } else if ("rq".equals(type)) {
                MessagingQosEffort effort = this.getEffort(message);
                Request request = (Request)this.objectMapper.readValue(payload, Request.class);
                request.setCreatorUserId(message.getCreatorUserId());
                request.setContext(message.getContext());
                logger.trace("Parsed request from message payload :" + payload);
                this.handle(request, message.getSender(), message.getRecipient(), expiryDate, customHeaders, effort, message.isCompressed());
            } else if ("o".equals(type)) {
                OneWayRequest oneWayRequest = (OneWayRequest)this.objectMapper.readValue(payload, OneWayRequest.class);
                oneWayRequest.setCreatorUserId(message.getCreatorUserId());
                oneWayRequest.setContext(message.getContext());
                logger.trace("Parsed one way request from message payload :" + payload);
                this.handle(oneWayRequest, message.getRecipient(), expiryDate);
            } else if ("arq".equals(type) || "brq".equals(type) || "mrq".equals(type)) {
                SubscriptionRequest subscriptionRequest = (SubscriptionRequest)this.objectMapper.readValue(payload, SubscriptionRequest.class);
                logger.trace("Parsed subscription request from message payload :" + payload);
                this.handle(subscriptionRequest, message.getSender(), message.getRecipient());
            } else if ("sst".equals(type)) {
                SubscriptionStop subscriptionStop = (SubscriptionStop)this.objectMapper.readValue(payload, SubscriptionStop.class);
                logger.trace("Parsed subscription stop from message payload :" + payload);
                this.handle(subscriptionStop);
            } else if ("p".equals(type)) {
                SubscriptionPublication publication = (SubscriptionPublication)this.objectMapper.readValue(payload, SubscriptionPublication.class);
                logger.trace("Parsed publication from message payload :" + payload);
                this.handle(publication);
            } else if ("m".equals(type)) {
                MulticastPublication multicastPublication = (MulticastPublication)this.objectMapper.readValue(payload, MulticastPublication.class);
                logger.trace("Parsed multicast publication from message payload: {}", (Object)payload);
                this.handle(multicastPublication);
            }
        }
        catch (IOException e) {
            logger.error("Error parsing payload. msgId: {}. from: {} to: {}. Reason: {}. Discarding joynr message.", new Object[]{message.getId(), message.getSender(), message.getRecipient(), e.getMessage()});
            return;
        }
    }

    private void handle(final Request request, final String fromParticipantId, final String toParticipantId, final long expiryDate, final Map<String, String> customHeaders, final MessagingQosEffort effort, final boolean compress) {
        this.requestReplyManager.handleRequest(new ProviderCallback<Reply>(){

            public void onSuccess(Reply reply) {
                try {
                    if (!DispatcherUtils.isExpired(expiryDate)) {
                        DispatcherImpl.this.sendReply(toParticipantId, fromParticipantId, reply, expiryDate, customHeaders, effort, compress);
                    } else {
                        logger.error("Error: reply {} is not send to caller, as the expiryDate of the reply message {} has been reached.", (Object)reply, (Object)new Date(expiryDate));
                    }
                }
                catch (Exception error) {
                    logger.error("Error processing reply: \r\n {} : error : {}", (Object)reply, (Object)error);
                }
            }

            public void onFailure(JoynrException error) {
                if (error instanceof JoynrRuntimeException) {
                    logger.error("Error processing request: {}", (Object)request, (Object)error);
                }
                Reply reply = new Reply(request.getRequestReplyId(), error);
                try {
                    DispatcherImpl.this.sendReply(toParticipantId, fromParticipantId, reply, expiryDate, customHeaders, effort, compress);
                }
                catch (Exception e) {
                    logger.error("Error sending error reply: \r\n {}", (Object)reply, (Object)e);
                }
            }
        }, toParticipantId, request, expiryDate);
    }

    private void handle(Reply reply) {
        this.requestReplyManager.handleReply(reply);
    }

    private void handle(SubscriptionReply subscriptionReply) {
        this.subscriptionManager.handleSubscriptionReply(subscriptionReply);
    }

    private void handle(OneWayRequest oneWayRequest, String toParticipantId, long expiryDate) {
        this.requestReplyManager.handleOneWayRequest(toParticipantId, oneWayRequest, expiryDate);
    }

    private void handle(SubscriptionRequest subscriptionRequest, String fromParticipantId, String toParticipantId) {
        this.publicationManager.addSubscriptionRequest(fromParticipantId, toParticipantId, subscriptionRequest);
    }

    public void error(ImmutableMessage message, Throwable error) {
        String payload;
        if (message == null) {
            logger.error("error: ", error);
            return;
        }
        String type = message.getType();
        try {
            payload = new String(message.getUnencryptedBody(), Charsets.UTF_8);
        }
        catch (EncodingException e) {
            logger.error("Error extracting payload for message {}. Reason: {}", new Object[]{message.getId(), e.getMessage()});
            return;
        }
        try {
            if (type.equals("rq")) {
                Request request = (Request)this.objectMapper.readValue(payload, Request.class);
                this.requestReplyManager.handleError(request, error);
            }
        }
        catch (IOException e) {
            logger.error("Error extracting payload for message " + message.getId() + ", raw payload: " + payload, (Object)e.getMessage());
        }
    }

    private Object[] getPublicationValues(Class<?>[] parameterTypes, List<?> publicizedValues) {
        if (parameterTypes.length != publicizedValues.size()) {
            throw new JoynrRuntimeException("number of received out parameter values do not match with the number of out parameter types.");
        }
        Object[] values = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            values[i] = this.objectMapper.convertValue(publicizedValues.get(i), parameterTypes[i]);
        }
        return values;
    }

    private void handle(SubscriptionPublication publication) {
        try {
            String subscriptionId = publication.getSubscriptionId();
            if (this.subscriptionManager.isBroadcast(subscriptionId)) {
                Class<?>[] broadcastOutParameterTypes = this.subscriptionManager.getUnicastPublicationOutParameterTypes(subscriptionId);
                List broadcastOutParamterValues = (List)publication.getResponse();
                Object[] broadcastValues = this.getPublicationValues(broadcastOutParameterTypes, broadcastOutParamterValues);
                this.subscriptionManager.handleBroadcastPublication(subscriptionId, broadcastValues);
            } else {
                JoynrRuntimeException error = publication.getError();
                if (error != null) {
                    this.subscriptionManager.handleAttributePublicationError(subscriptionId, error);
                } else {
                    Object attributeValue;
                    Class<?> receivedType = this.subscriptionManager.getAttributeType(subscriptionId);
                    if (TypeReference.class.isAssignableFrom(receivedType)) {
                        TypeReference typeRef = (TypeReference)receivedType.newInstance();
                        attributeValue = this.objectMapper.convertValue(((List)publication.getResponse()).get(0), typeRef);
                    } else {
                        attributeValue = this.objectMapper.convertValue(((List)publication.getResponse()).get(0), receivedType);
                    }
                    this.subscriptionManager.handleAttributePublication(subscriptionId, attributeValue);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error delivering publication: {} : {}", e.getClass(), (Object)e.getMessage());
        }
    }

    private void handle(MulticastPublication multicastPublication) {
        try {
            Object[] values = this.getPublicationValues(this.subscriptionManager.getMulticastPublicationOutParameterTypes(multicastPublication.getMulticastId()), (List)multicastPublication.getResponse());
            this.subscriptionManager.handleMulticastPublication(multicastPublication.getMulticastId(), values);
        }
        catch (Exception e) {
            logger.error("Error delivering multicast publication: {} : {}", e.getClass(), (Object)e.getMessage());
            logger.trace("Full exception.", (Throwable)e);
        }
    }

    private void handle(SubscriptionStop subscriptionStop) {
        logger.info("Subscription stop received");
        this.publicationManager.stopPublication(subscriptionStop.getSubscriptionId());
    }

    @Override
    public void sendMulticast(String fromParticipantId, MulticastPublication multicastPublication, MessagingQos messagingQos) {
        MutableMessage message = this.messageFactory.createMulticast(fromParticipantId, multicastPublication, messagingQos);
        this.messageSender.sendMessage(message);
    }
}

