/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching;

import com.google.common.collect.Sets;
import io.joynr.dispatching.DirectoryListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public abstract class Directory<T> {
    protected Set<DirectoryListener<T>> listeners = Sets.newHashSet();
    protected Map<String, T> entryMap = new HashMap<String, T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DirectoryListener<T> listener) {
        Map<String, T> map = this.entryMap;
        synchronized (map) {
            this.listeners.add(listener);
            for (Map.Entry<String, T> entry : this.entryMap.entrySet()) {
                listener.entryAdded(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DirectoryListener<T> listener) {
        Map<String, T> map = this.entryMap;
        synchronized (map) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String id, T entry) {
        Map<String, T> map = this.entryMap;
        synchronized (map) {
            this.entryMap.put(id, entry);
            for (DirectoryListener<T> listener : this.listeners) {
                listener.entryAdded(id, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(String id) {
        Map<String, T> map = this.entryMap;
        synchronized (map) {
            this.getLogger().trace("remove: {}", (Object)id);
            T result = this.entryMap.remove(id);
            if (result == null) {
                this.getLogger().trace("remove: {} not found", (Object)id);
            } else {
                for (DirectoryListener<T> listener : this.listeners) {
                    listener.entryRemoved(id);
                }
            }
            return result;
        }
    }

    public boolean contains(String id) {
        return this.entryMap.containsKey(id);
    }

    public T get(String id) {
        return this.entryMap.get(id);
    }

    public boolean isEmpty() {
        return this.entryMap.isEmpty();
    }

    protected abstract Logger getLogger();
}

