/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.dispatching;

import io.joynr.common.ExpiryDate;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentWithExpiryDate<T> {
    private static final Logger logger = LoggerFactory.getLogger(ContentWithExpiryDate.class);
    private T content;
    private ExpiryDate expiryDate;

    public ContentWithExpiryDate(T content, ExpiryDate roundTripExpirationDate) {
        this.content = content;
        this.expiryDate = roundTripExpirationDate;
    }

    public T getContent() {
        return this.content;
    }

    boolean isExpired() {
        boolean expired;
        long currentTimeMillis = System.currentTimeMillis();
        boolean bl = expired = currentTimeMillis > this.expiryDate.getValue();
        if (expired && logger.isDebugEnabled()) {
            String msg = MessageFormat.format("\r\ncurrentTime: {0,time,hh:mm:ss.mmm}\r\nttl:{1,time,hh:mm:ss.mmm}", currentTimeMillis, this.expiryDate.getValue());
            logger.debug(msg);
        }
        return expired;
    }
}

