/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.discovery;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.proxy.Callback;
import io.joynr.proxy.Future;
import io.joynr.proxy.ProxyBuilderFactory;
import io.joynr.util.VersionUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import joynr.system.DiscoveryAsync;
import joynr.system.DiscoveryProvider;
import joynr.system.DiscoveryProxy;
import joynr.system.RoutingProvider;
import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.DiscoveryQos;
import joynr.types.ProviderQos;
import joynr.types.ProviderScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiscoveryAggregator
implements DiscoveryAsync {
    private static final Logger logger = LoggerFactory.getLogger(LocalDiscoveryAggregator.class);
    private static final long NO_EXPIRY = Long.MAX_VALUE;
    private HashMap<String, DiscoveryEntryWithMetaInfo> provisionedDiscoveryEntries = new HashMap();
    private DiscoveryProxy defaultDiscoveryProxy;
    private ProxyBuilderFactory proxyBuilderFactory;
    private String systemServiceDomain;

    @Inject
    public LocalDiscoveryAggregator(@Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain, @Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, @Named(value="joynr.messaging.routingproviderparticipantid") String routingProviderParticipantId, ProxyBuilderFactory proxyBuilderFactory) {
        ProviderQos providerQos = new ProviderQos();
        providerQos.setScope(ProviderScope.LOCAL);
        String defaultPublicKeyId = "";
        this.provisionedDiscoveryEntries.put(systemServicesDomain + ProviderAnnotations.getInterfaceName(DiscoveryProvider.class), new DiscoveryEntryWithMetaInfo(VersionUtil.getVersionFromAnnotation(DiscoveryProvider.class), systemServicesDomain, ProviderAnnotations.getInterfaceName(DiscoveryProvider.class), discoveryProviderParticipantId, providerQos, Long.valueOf(System.currentTimeMillis()), Long.valueOf(Long.MAX_VALUE), defaultPublicKeyId, Boolean.valueOf(false)));
        this.provisionedDiscoveryEntries.put(systemServicesDomain + "system/Routing", new DiscoveryEntryWithMetaInfo(VersionUtil.getVersionFromAnnotation(RoutingProvider.class), systemServicesDomain, "system/Routing", routingProviderParticipantId, providerQos, Long.valueOf(System.currentTimeMillis()), Long.valueOf(Long.MAX_VALUE), defaultPublicKeyId, Boolean.valueOf(true)));
        this.proxyBuilderFactory = proxyBuilderFactory;
        this.systemServiceDomain = systemServicesDomain;
    }

    public Future<Void> add(Callback<Void> callback, DiscoveryEntry discoveryEntry) {
        return this.getDefaultDiscoveryProxy().add(callback, discoveryEntry, Boolean.valueOf(false));
    }

    public Future<Void> add(Callback<Void> callback, DiscoveryEntry discoveryEntry, Boolean awaitGlobalRegistration) {
        return this.getDefaultDiscoveryProxy().add(callback, discoveryEntry, awaitGlobalRegistration);
    }

    public Future<DiscoveryEntryWithMetaInfo[]> lookup(final Callback<DiscoveryEntryWithMetaInfo[]> callback, String[] domains, String interfaceName, DiscoveryQos discoveryQos) {
        final HashSet<DiscoveryEntryWithMetaInfo> discoveryEntries = new HashSet<DiscoveryEntryWithMetaInfo>();
        HashSet<String> missingDomains = new HashSet<String>();
        for (String domain : domains) {
            if (this.provisionedDiscoveryEntries.containsKey(domain + interfaceName)) {
                DiscoveryEntryWithMetaInfo discoveryEntry = this.provisionedDiscoveryEntries.get(domain + interfaceName);
                discoveryEntries.add(discoveryEntry);
                continue;
            }
            missingDomains.add(domain);
        }
        logger.trace("Found locally provisioned discovery entries: {}", discoveryEntries);
        final Future discoveryEntryFuture = new Future();
        if (!missingDomains.isEmpty()) {
            logger.trace("Did not find entries for the following domains: {}", missingDomains);
            Callback<DiscoveryEntryWithMetaInfo[]> newCallback = new Callback<DiscoveryEntryWithMetaInfo[]>(){

                public void onFailure(JoynrRuntimeException error) {
                    callback.onFailure(error);
                    discoveryEntryFuture.onFailure((JoynrException)error);
                }

                public void onSuccess(DiscoveryEntryWithMetaInfo[] entries) {
                    assert (entries != null) : "Entries must not be null.";
                    logger.trace("Globally found entries for missing domains: {}", (Object)Arrays.toString(entries));
                    Collections.addAll(discoveryEntries, entries);
                    LocalDiscoveryAggregator.this.resolveDiscoveryEntriesFutureWithEntries((Future<DiscoveryEntryWithMetaInfo[]>)discoveryEntryFuture, discoveryEntries, (Callback<DiscoveryEntryWithMetaInfo[]>)callback);
                }
            };
            String[] missingDomainsArray = new String[missingDomains.size()];
            missingDomains.toArray(missingDomainsArray);
            this.getDiscoveryProxy(discoveryQos.getDiscoveryTimeout()).lookup((Callback)newCallback, missingDomainsArray, interfaceName, discoveryQos);
        } else {
            this.resolveDiscoveryEntriesFutureWithEntries((Future<DiscoveryEntryWithMetaInfo[]>)discoveryEntryFuture, discoveryEntries, callback);
        }
        return discoveryEntryFuture;
    }

    private void resolveDiscoveryEntriesFutureWithEntries(Future<DiscoveryEntryWithMetaInfo[]> future, Set<DiscoveryEntryWithMetaInfo> discoveryEntries, Callback<DiscoveryEntryWithMetaInfo[]> callback) {
        DiscoveryEntryWithMetaInfo[] discoveryEntriesArray = new DiscoveryEntryWithMetaInfo[discoveryEntries.size()];
        discoveryEntries.toArray(discoveryEntriesArray);
        future.resolve(new Object[]{discoveryEntriesArray});
        callback.resolve(new Object[]{discoveryEntriesArray});
    }

    public Future<DiscoveryEntryWithMetaInfo> lookup(Callback<DiscoveryEntryWithMetaInfo> callback, String participantId) {
        return this.getDefaultDiscoveryProxy().lookup(callback, participantId);
    }

    public Future<Void> remove(Callback<Void> callback, String participantId) {
        return this.getDefaultDiscoveryProxy().remove(callback, participantId);
    }

    public void forceQueryOfDiscoveryProxy() {
        this.getDefaultDiscoveryProxy();
    }

    private DiscoveryProxy getDefaultDiscoveryProxy() {
        if (this.defaultDiscoveryProxy == null) {
            MessagingQos internalMessagingQos = new MessagingQos();
            internalMessagingQos.setTtl_ms(internalMessagingQos.getRoundTripTtl_ms() + 10000L);
            this.defaultDiscoveryProxy = this.proxyBuilderFactory.get(this.systemServiceDomain, DiscoveryProxy.class).setMessagingQos(internalMessagingQos).build();
        }
        return this.defaultDiscoveryProxy;
    }

    private DiscoveryProxy getDiscoveryProxy(long ttl) {
        MessagingQos messagingQos = new MessagingQos(ttl);
        return this.proxyBuilderFactory.get(this.systemServiceDomain, DiscoveryProxy.class).setMessagingQos(messagingQos).build();
    }
}

