/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.joynr.capabilities.ParticipantIdKeyUtil;
import io.joynr.capabilities.ParticipantIdStorage;
import io.joynr.guice.LowerCaseProperties;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.runtime.PropertyLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import joynr.infrastructure.GlobalCapabilitiesDirectoryProvider;
import joynr.infrastructure.GlobalDomainAccessControllerProvider;
import joynr.system.DiscoveryProvider;
import joynr.system.RoutingProvider;
import joynr.types.GlobalDiscoveryEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PropertiesFileParticipantIdStorage
implements ParticipantIdStorage {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesFileParticipantIdStorage.class);
    private final GlobalDiscoveryEntry capabilitiesDirectoryEntry;
    private final GlobalDiscoveryEntry domainAccessControllerEntry;
    Properties persistedParticipantIds;
    private String persistenceFileName;
    private Properties joynrProperties;
    private String discoveryProviderParticipantId;
    private String routingProviderParticipantId;

    @Inject
    public PropertiesFileParticipantIdStorage(@Named(value="joynr.properties") Properties joynrProperties, @Named(value="joynr.discovery.participantids_persistence_file") String persistenceFileName, @Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, @Named(value="joynr.messaging.routingproviderparticipantid") String routingProviderParticipantId, @Named(value="joynr.messaging.capabilitiesdirectory.discoveryentry") GlobalDiscoveryEntry capabilitiesDirectoryEntry, @Named(value="joynr.messaging.domainaccesscontroller.discoveryentry") GlobalDiscoveryEntry domainAccessControllerEntry) {
        this.joynrProperties = joynrProperties;
        this.persistenceFileName = persistenceFileName;
        this.capabilitiesDirectoryEntry = capabilitiesDirectoryEntry;
        this.domainAccessControllerEntry = domainAccessControllerEntry;
        this.discoveryProviderParticipantId = discoveryProviderParticipantId;
        this.routingProviderParticipantId = routingProviderParticipantId;
        File persistenceFile = new File(persistenceFileName);
        this.persistedParticipantIds = new LowerCaseProperties((Properties)PropertyLoader.loadProperties((File)persistenceFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProviderParticipantId(String domain, String interfaceName, String defaultValue) {
        String participantId;
        String token = ParticipantIdKeyUtil.getProviderParticipantIdKey(domain, interfaceName);
        if (this.persistedParticipantIds.containsKey(token.toLowerCase())) {
            participantId = this.persistedParticipantIds.getProperty(token.toLowerCase());
        } else if (defaultValue != null) {
            participantId = defaultValue;
        } else if (ProviderAnnotations.getInterfaceName(GlobalCapabilitiesDirectoryProvider.class).equals(interfaceName)) {
            participantId = this.capabilitiesDirectoryEntry.getParticipantId();
        } else if (ProviderAnnotations.getInterfaceName(GlobalDomainAccessControllerProvider.class).equals(interfaceName)) {
            participantId = this.domainAccessControllerEntry.getParticipantId();
        } else if (ProviderAnnotations.getInterfaceName(DiscoveryProvider.class).equals(interfaceName)) {
            participantId = this.discoveryProviderParticipantId;
        } else if (ProviderAnnotations.getInterfaceName(RoutingProvider.class).equals(interfaceName)) {
            participantId = this.routingProviderParticipantId;
        } else {
            participantId = UUID.randomUUID().toString();
            this.persistedParticipantIds.put(token, participantId);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.persistenceFileName);
                this.persistedParticipantIds.store(fileOutputStream, null);
            }
            catch (IOException e1) {
                logger.error("Error saving properties file for channelId", (Throwable)e1);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        logger.debug("error closing output stream", (Throwable)e);
                    }
                }
            }
        }
        return participantId;
    }

    @Override
    public String getProviderParticipantId(String domain, String interfaceName) {
        String defaultParticipantId = null;
        String providerParticipantIdKey = ParticipantIdKeyUtil.getProviderParticipantIdKey(domain, interfaceName);
        if (this.joynrProperties.containsKey(providerParticipantIdKey)) {
            defaultParticipantId = this.joynrProperties.getProperty(providerParticipantIdKey);
        }
        return this.getProviderParticipantId(domain, interfaceName, defaultParticipantId);
    }
}

