/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import io.joynr.ProvidedBy;
import io.joynr.exceptions.JoynrIllegalStateException;
import io.joynr.provider.JoynrInterface;

public final class ParticipantIdKeyUtil {
    public static final String JOYNR_PARTICIPANT_PREFIX = "joynr.participant.";

    private ParticipantIdKeyUtil() {
    }

    public static String getProviderParticipantIdKey(String domain, String interfaceName) {
        String token = JOYNR_PARTICIPANT_PREFIX + domain + "." + interfaceName;
        return token.toLowerCase().replace('/', '.');
    }

    public static String getProviderParticipantIdKey(String domain, Class interfaceClass) {
        Class annotatedInterface = interfaceClass.getAnnotation(ProvidedBy.class) != null ? interfaceClass.getAnnotation(ProvidedBy.class).value() : interfaceClass;
        JoynrInterface joynrInterface = annotatedInterface.getAnnotation(JoynrInterface.class);
        if (joynrInterface == null) {
            throw new JoynrIllegalStateException("Class " + annotatedInterface + " not annotated with @JoynrInterface. Can't get interface name.");
        }
        String interfaceName = joynrInterface.name();
        return ParticipantIdKeyUtil.getProviderParticipantIdKey(domain, interfaceName);
    }
}

