/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.DefaultCapabilitiesProvisioning;
import io.joynr.util.VersionUtil;
import java.util.ArrayList;
import java.util.Collection;
import joynr.system.DiscoveryProvider;
import joynr.system.RoutingTypes.Address;
import joynr.types.DiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.ProviderScope;
import joynr.types.Version;

public class InProcessCapabilitiesProvisioning
extends DefaultCapabilitiesProvisioning {
    private static final long NO_EXPIRY = Long.MAX_VALUE;
    private String discoveryProviderParticipantId;
    private String systemServicesDomain;
    private Address discoveryProviderAddress;

    @Inject
    public InProcessCapabilitiesProvisioning(@Named(value="joynr.messaging.discoveryproviderparticipantid") String discoveryProviderParticipantId, @Named(value="joynr.messaging.systemservicesdomain") String systemServicesDomain, @Named(value="joynr.messaging.ccmessagingaddress") Address discoveryProviderAddress) {
        this.discoveryProviderParticipantId = discoveryProviderParticipantId;
        this.systemServicesDomain = systemServicesDomain;
        this.discoveryProviderAddress = discoveryProviderAddress;
    }

    public Collection<DiscoveryEntry> getDiscoveryEntries() {
        ArrayList provisionedList = Lists.newArrayList();
        String defaultPulicKeyId = "";
        ProviderQos providerQos = new ProviderQos();
        providerQos.setScope(ProviderScope.LOCAL);
        provisionedList.add(CapabilityUtils.newGlobalDiscoveryEntry((Version)VersionUtil.getVersionFromAnnotation(DiscoveryProvider.class), (String)this.systemServicesDomain, (String)"system/Discovery", (String)this.discoveryProviderParticipantId, (ProviderQos)providerQos, (Long)System.currentTimeMillis(), (Long)Long.MAX_VALUE, (String)defaultPulicKeyId, (Address)this.discoveryProviderAddress));
        return provisionedList;
    }
}

