/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.arbitration.ArbitrationStrategy;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.arbitration.DiscoveryScope;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.Callback;
import io.joynr.proxy.ProxyBuilder;
import io.joynr.proxy.ProxyBuilderFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import joynr.infrastructure.GlobalCapabilitiesDirectoryProxy;
import joynr.types.GlobalDiscoveryEntry;

public class GlobalCapabilitiesDirectoryClient {
    private static final long DEFAULT_TTL_ADD_AND_REMOVE = 60000L;
    private final String domain;
    private final DiscoveryQos discoveryQos;
    private final ProxyBuilderFactory proxyBuilderFactory;
    private GlobalCapabilitiesDirectoryProxy touchProxy;
    private GlobalCapabilitiesDirectoryProxy addAndRemoveProxy;
    @Inject
    @Named(value="joynr.messaging.channelid")
    private String localChannelId;
    @Inject
    @Named(value="joynr.capabilities.freshnessupdateintervalms")
    private long freshnessUpdateIntervalMs;
    @Inject(optional=true)
    @Named(value="joynr.discovery.globaladdandremovettlms")
    private long ttlAddAndRemoveMs = 60000L;

    @Inject
    public GlobalCapabilitiesDirectoryClient(ProxyBuilderFactory proxyBuilderFactory, @Named(value="joynr.messaging.capabilitiesdirectory.discoveryentry") GlobalDiscoveryEntry capabilitiesDirectoryEntry) {
        this.proxyBuilderFactory = proxyBuilderFactory;
        this.domain = capabilitiesDirectoryEntry.getDomain();
        this.discoveryQos = new DiscoveryQos(30000L, ArbitrationStrategy.HighestPriority, Long.MAX_VALUE, DiscoveryScope.GLOBAL_ONLY);
    }

    private GlobalCapabilitiesDirectoryProxy getProxy(long ttl) {
        ProxyBuilder<GlobalCapabilitiesDirectoryProxy> capabilitiesProxyBuilder = this.proxyBuilderFactory.get(this.domain, GlobalCapabilitiesDirectoryProxy.class);
        MessagingQos messagingQos = new MessagingQos(ttl);
        return capabilitiesProxyBuilder.setDiscoveryQos(this.discoveryQos).setMessagingQos(messagingQos).build();
    }

    private GlobalCapabilitiesDirectoryProxy getAddAndRemoveProxy() {
        if (this.addAndRemoveProxy == null) {
            this.addAndRemoveProxy = this.getProxy(this.ttlAddAndRemoveMs);
        }
        return this.addAndRemoveProxy;
    }

    public void add(Callback<Void> callback, GlobalDiscoveryEntry globalDiscoveryEntry) {
        this.getAddAndRemoveProxy().add(callback, globalDiscoveryEntry);
    }

    public void remove(Callback<Void> callback, String participantId) {
        this.getAddAndRemoveProxy().remove(callback, participantId);
    }

    public void remove(Callback<Void> callback, List<String> participantIds) {
        this.getAddAndRemoveProxy().remove(callback, participantIds.toArray(new String[participantIds.size()]));
    }

    public void lookup(Callback<GlobalDiscoveryEntry> callback, String participantId, long ttl) {
        this.getProxy(ttl).lookup(callback, participantId);
    }

    public void lookup(final Callback<List<GlobalDiscoveryEntry>> callback, String[] domains, String interfaceName, long ttl) {
        this.getProxy(ttl).lookup((Callback)new Callback<GlobalDiscoveryEntry[]>(){

            public void onFailure(JoynrRuntimeException error) {
                callback.onFailure(error);
            }

            public void onSuccess(GlobalDiscoveryEntry[] result) {
                List<GlobalDiscoveryEntry> globalDiscoveryEntryList = result == null ? new ArrayList<GlobalDiscoveryEntry>() : Arrays.asList(result);
                callback.onSuccess(globalDiscoveryEntryList);
            }
        }, domains, interfaceName);
    }

    public void touch() {
        if (this.touchProxy == null) {
            this.touchProxy = this.getProxy(this.freshnessUpdateIntervalMs);
        }
        this.touchProxy.touch(this.localChannelId);
    }
}

