/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.joynr.capabilities.CapabilitiesRegistrar;
import io.joynr.capabilities.ParticipantIdStorage;
import io.joynr.dispatching.ProviderDirectory;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.routing.MessageRouter;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.provider.ProviderContainer;
import io.joynr.provider.ProviderContainerFactory;
import io.joynr.proxy.Callback;
import io.joynr.proxy.Future;
import io.joynr.util.VersionUtil;
import javax.annotation.CheckForNull;
import javax.inject.Named;
import joynr.system.DiscoveryAsync;
import joynr.system.RoutingTypes.Address;
import joynr.types.DiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.ProviderScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CapabilitiesRegistrarImpl
implements CapabilitiesRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(CapabilitiesRegistrarImpl.class);
    private DiscoveryAsync localDiscoveryAggregator;
    private final MessageRouter messageRouter;
    private ParticipantIdStorage participantIdStorage;
    private Address libjoynrMessagingAddress;
    private ProviderDirectory providerDirectory;
    private ProviderContainerFactory providerContainerFactory;
    private long defaultExpiryTimeMs;

    @Inject
    public CapabilitiesRegistrarImpl(DiscoveryAsync localDiscoveryAggregator, ProviderContainerFactory providerContainerFactory, MessageRouter messageRouter, ProviderDirectory providerDirectory, ParticipantIdStorage participantIdStorage, @Named(value="joynr.discovery.provider.defaultexpirytimems") long defaultExpiryTimeMs, @Named(value="joynr.messaging.dispatcheraddress") Address dispatcherAddress) {
        this.localDiscoveryAggregator = localDiscoveryAggregator;
        this.providerContainerFactory = providerContainerFactory;
        this.messageRouter = messageRouter;
        this.providerDirectory = providerDirectory;
        this.participantIdStorage = participantIdStorage;
        this.defaultExpiryTimeMs = defaultExpiryTimeMs;
        this.libjoynrMessagingAddress = dispatcherAddress;
    }

    @Override
    public Future<Void> registerProvider(String domain, Object provider, ProviderQos providerQos, boolean awaitGlobalRegistration) {
        if (providerQos == null) {
            throw new JoynrRuntimeException("providerQos == null. It must not be null");
        }
        ProviderContainer providerContainer = this.providerContainerFactory.create(provider);
        String participantId = this.participantIdStorage.getProviderParticipantId(domain, providerContainer.getInterfaceName());
        String defaultPublicKeyId = "";
        DiscoveryEntry discoveryEntry = new DiscoveryEntry(VersionUtil.getVersionFromAnnotation(provider.getClass()), domain, providerContainer.getInterfaceName(), participantId, providerQos, Long.valueOf(System.currentTimeMillis()), Long.valueOf(System.currentTimeMillis() + this.defaultExpiryTimeMs), defaultPublicKeyId);
        boolean isGloballyVisible = discoveryEntry.getQos().getScope() == ProviderScope.GLOBAL;
        this.messageRouter.addNextHop(participantId, this.libjoynrMessagingAddress, isGloballyVisible);
        this.providerDirectory.add(participantId, providerContainer);
        Callback<Void> callback = new Callback<Void>(){

            public void onSuccess(@CheckForNull Void result) {
            }

            public void onFailure(JoynrRuntimeException runtimeException) {
                logger.error("Unexpected Error while registering Provider:", (Throwable)runtimeException);
            }
        };
        return this.localDiscoveryAggregator.add((Callback)callback, discoveryEntry, Boolean.valueOf(awaitGlobalRegistration));
    }

    @Override
    public Future<Void> unregisterProvider(String domain, Object provider) {
        String participantId = this.participantIdStorage.getProviderParticipantId(domain, ProviderAnnotations.getInterfaceName((Object)provider));
        Callback<Void> callback = new Callback<Void>(){

            public void onSuccess(@CheckForNull Void result) {
            }

            public void onFailure(JoynrRuntimeException error) {
                logger.error("Error while unregistering provider: ", (Throwable)error);
            }
        };
        this.providerDirectory.remove(participantId);
        return this.localDiscoveryAggregator.remove((Callback)callback, participantId);
    }
}

