/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.caching;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import io.joynr.caching.CachedValue;
import io.joynr.caching.ClientCache;
import io.joynr.qos.QualityOfService;
import io.joynr.qos.compatibility.QoSCacheEntryTimeToLiveCompatibility;
import io.joynr.qos.compatibility.QoSDataFreshnessCompatibility;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;

public class ClientHashMapCache
implements ClientCache {
    private Map<String, CachedValue> cache = new ConcurrentHashMap<String, CachedValue>();
    private QualityOfService qos = new QualityOfService();
    private QoSDataFreshnessCompatibility dataFreshnessCompatibility = new QoSDataFreshnessCompatibility(this.qos);

    @Inject
    public ClientHashMapCache() {
    }

    @Override
    public void setQoS(QualityOfService qos) {
        this.qos = qos;
        this.dataFreshnessCompatibility = new QoSDataFreshnessCompatibility(qos);
    }

    @Override
    public boolean isCacheValueValid(String attributeId) {
        if (!this.cache.containsKey(attributeId)) {
            return false;
        }
        return this.dataFreshnessCompatibility.apply(this.cache.get(attributeId));
    }

    @Override
    public Object lookUp(String attributeId) throws NoSuchElementException {
        if (!this.cache.containsKey(attributeId)) {
            throw new NoSuchElementException("The attribute id " + attributeId + " could not be found.");
        }
        CachedValue value = this.cache.get(attributeId);
        return value.getValue();
    }

    @Override
    public void insert(String attributeId, Object value) {
        Long timestamp = System.currentTimeMillis();
        CachedValue cachedValue = new CachedValue(value, timestamp);
        this.cache.put(attributeId, cachedValue);
    }

    @Override
    public void cleanUp() {
        Map result = Maps.filterValues(this.cache, (Predicate)new QoSCacheEntryTimeToLiveCompatibility(this.qos));
        for (String attributeId : result.keySet()) {
            this.cache.remove(attributeId);
        }
    }
}

