/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import joynr.types.Version;

public class VersionCompatibilityChecker {
    public boolean check(Version caller, Version provider) {
        if (caller == null || provider == null) {
            throw new IllegalArgumentException(String.format("Both caller (%s) and provider (%s) must be non-null.", caller, provider));
        }
        if (caller.getMajorVersion() == null || caller.getMinorVersion() == null || provider.getMajorVersion() == null || provider.getMinorVersion() == null) {
            throw new IllegalArgumentException(String.format("Neither major nor minor version values can be null in either caller %s or provider %s.", caller, provider));
        }
        int callerMajor = caller.getMajorVersion();
        int callerMinor = caller.getMinorVersion();
        int providerMajor = provider.getMajorVersion();
        int providerMinor = provider.getMinorVersion();
        return callerMajor == providerMajor && callerMinor <= providerMinor;
    }
}

