/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.common.collect.Sets;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastSeenArbitrationStrategyFunction
extends ArbitrationStrategyFunction {
    private static final Logger logger = LoggerFactory.getLogger(LastSeenArbitrationStrategyFunction.class);

    public final Set<DiscoveryEntryWithMetaInfo> select(Map<String, String> parameters, Collection<DiscoveryEntryWithMetaInfo> capabilities) {
        logger.trace("starting select Provider by lastSeenDateMs");
        DiscoveryEntryWithMetaInfo latestSeenCapability = null;
        long latestSeenDateMs = -1L;
        for (DiscoveryEntryWithMetaInfo discoveryEntry : capabilities) {
            Long lastSeenDateMs = discoveryEntry.getLastSeenDateMs();
            logger.trace("Looking at capability with lastSeenDateMs " + lastSeenDateMs);
            if (latestSeenDateMs >= lastSeenDateMs) continue;
            latestSeenDateMs = lastSeenDateMs;
            latestSeenCapability = discoveryEntry;
        }
        logger.trace("capability with lastSeenMs: " + latestSeenDateMs + "\r\n" + latestSeenCapability);
        return latestSeenCapability == null ? null : Sets.newHashSet((Object[])new DiscoveryEntryWithMetaInfo[]{latestSeenCapability});
    }
}

