/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.common.collect.Sets;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighestPriorityArbitrationStrategyFunction
extends ArbitrationStrategyFunction {
    private static final Logger logger = LoggerFactory.getLogger(HighestPriorityArbitrationStrategyFunction.class);

    public final Set<DiscoveryEntryWithMetaInfo> select(Map<String, String> parameters, Collection<DiscoveryEntryWithMetaInfo> capabilities) {
        logger.trace("starting select Provider by priority");
        DiscoveryEntryWithMetaInfo highestPriorityCapability = null;
        long highestPriority = -1L;
        for (DiscoveryEntryWithMetaInfo discoveryEntry : capabilities) {
            Long priority = discoveryEntry.getQos().getPriority();
            logger.trace("Looking at capability with priority " + priority.toString());
            if (highestPriority >= priority) continue;
            highestPriority = priority;
            highestPriorityCapability = discoveryEntry;
        }
        logger.trace("capability with highest priority: " + highestPriority + "\r\n" + highestPriorityCapability);
        return highestPriorityCapability == null ? null : Sets.newHashSet((Object[])new DiscoveryEntryWithMetaInfo[]{highestPriorityCapability});
    }
}

