/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.common.collect.Sets;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import joynr.types.DiscoveryEntryWithMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedParticipantArbitrationStrategyFunction
extends ArbitrationStrategyFunction {
    private static final Logger logger = LoggerFactory.getLogger(FixedParticipantArbitrationStrategyFunction.class);

    public Set<DiscoveryEntryWithMetaInfo> select(Map<String, String> parameters, Collection<DiscoveryEntryWithMetaInfo> capabilities) {
        String participantId = parameters.get("fixedParticipantId");
        logger.trace("starting select Provider by participant Id: {}", (Object)participantId);
        DiscoveryEntryWithMetaInfo capabilityWithParticipantId = null;
        for (DiscoveryEntryWithMetaInfo discoveryEntry : capabilities) {
            if (!discoveryEntry.getParticipantId().equals(participantId)) continue;
            capabilityWithParticipantId = discoveryEntry;
            break;
        }
        logger.trace("capability with participantId: {}: {}" + participantId, (Object)capabilityWithParticipantId);
        return capabilityWithParticipantId == null ? null : Sets.newHashSet((Object[])new DiscoveryEntryWithMetaInfo[]{capabilityWithParticipantId});
    }
}

