/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.inject.Inject;
import io.joynr.arbitration.VersionCompatibilityChecker;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.Version;

public class DiscoveryEntryVersionFilter {
    private VersionCompatibilityChecker versionCompatibilityChecker;

    @Inject
    public DiscoveryEntryVersionFilter(VersionCompatibilityChecker versionCompatibilityChecker) {
        this.versionCompatibilityChecker = versionCompatibilityChecker;
    }

    public Set<DiscoveryEntryWithMetaInfo> filter(Version callerVersion, Set<DiscoveryEntryWithMetaInfo> discoveryEntries, Map<String, Set<Version>> discoveredVersions) {
        if (callerVersion == null || discoveryEntries == null) {
            throw new IllegalArgumentException(String.format("Neither callerVersion (%s) nor discoveryEntries (%s) can be null.", callerVersion, discoveryEntries));
        }
        Iterator<DiscoveryEntryWithMetaInfo> iterator = discoveryEntries.iterator();
        while (iterator.hasNext()) {
            DiscoveryEntry discoveryEntry = (DiscoveryEntry)iterator.next();
            if (discoveredVersions != null) {
                Set<Version> versionsByDomain = discoveredVersions.get(discoveryEntry.getDomain());
                if (versionsByDomain == null) {
                    versionsByDomain = new HashSet<Version>();
                    discoveredVersions.put(discoveryEntry.getDomain(), versionsByDomain);
                }
                versionsByDomain.add(discoveryEntry.getProviderVersion());
            }
            if (this.versionCompatibilityChecker.check(callerVersion, discoveryEntry.getProviderVersion())) continue;
            iterator.remove();
        }
        return discoveryEntries;
    }
}

