/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import io.joynr.arbitration.Arbitrator;
import io.joynr.arbitration.DelayableArbitration;
import io.joynr.arbitration.DiscoveryEntryVersionFilter;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.arbitration.FixedParticipantArbitrationStrategyFunction;
import io.joynr.arbitration.HighestPriorityArbitrationStrategyFunction;
import io.joynr.arbitration.KeywordArbitrationStrategyFunction;
import io.joynr.arbitration.LastSeenArbitrationStrategyFunction;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.runtime.ShutdownListener;
import io.joynr.runtime.ShutdownNotifier;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import joynr.system.DiscoveryAsync;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArbitratorFactory {
    @Inject
    @Named(value="joynr.arbitration.minimumretrydelay")
    private static long minimumArbitrationRetryDelay;
    @Inject
    private static DiscoveryEntryVersionFilter discoveryEntryVersionFilter;
    @Inject
    private static ShutdownNotifier shutdownNotifier;
    @Inject
    @Named(value="io.joynr.messaging.scheduledthreadpool")
    private static ScheduledExecutorService scheduler;
    private static ArbitratorRunnable arbitratorRunnable;

    private ArbitratorFactory() {
    }

    public static Arbitrator create(Set<String> domains, String interfaceName, Version interfaceVersion, DiscoveryQos discoveryQos, DiscoveryAsync localDiscoveryAggregator) throws DiscoveryException {
        ArbitrationStrategyFunction arbitrationStrategyFunction;
        switch (discoveryQos.getArbitrationStrategy()) {
            case FixedChannel: {
                arbitrationStrategyFunction = new FixedParticipantArbitrationStrategyFunction();
                break;
            }
            case Keyword: {
                arbitrationStrategyFunction = new KeywordArbitrationStrategyFunction();
                break;
            }
            case HighestPriority: {
                arbitrationStrategyFunction = new HighestPriorityArbitrationStrategyFunction();
                break;
            }
            case LastSeen: {
                arbitrationStrategyFunction = new LastSeenArbitrationStrategyFunction();
                break;
            }
            case Custom: {
                arbitrationStrategyFunction = discoveryQos.getArbitrationStrategyFunction();
                break;
            }
            default: {
                throw new DiscoveryException("Arbitration failed: domain: " + domains + " interface: " + interfaceName + " qos: " + discoveryQos + ": unknown arbitration strategy or strategy not set!");
            }
        }
        return new Arbitrator(domains, interfaceName, interfaceVersion, discoveryQos, localDiscoveryAggregator, minimumArbitrationRetryDelay, arbitrationStrategyFunction, discoveryEntryVersionFilter);
    }

    public static synchronized void start() {
        if (arbitratorRunnable == null) {
            arbitratorRunnable = new ArbitratorRunnable();
            scheduler.execute(arbitratorRunnable);
            shutdownNotifier.registerForShutdown(new ShutdownListener(){

                public void shutdown() {
                    ArbitratorFactory.shutdown();
                }
            });
        }
    }

    public static synchronized void shutdown() {
        if (arbitratorRunnable != null) {
            arbitratorRunnable.stop();
            arbitratorRunnable = null;
        }
    }

    static class ArbitratorRunnable
    implements Runnable {
        private Logger logger = LoggerFactory.getLogger(ArbitratorRunnable.class);
        private volatile boolean stopped = false;

        ArbitratorRunnable() {
        }

        void stop() {
            this.stopped = true;
        }

        @Override
        public void run() {
            DelayableArbitration delayableArbitration = null;
            Thread.currentThread().setName("ArbitratorRunnable");
            this.logger.debug("Start ArbitratorRunnable");
            while (!this.stopped) {
                try {
                    delayableArbitration = (DelayableArbitration)((Object)Arbitrator.arbitrationQueue.poll(1000L, TimeUnit.MILLISECONDS));
                    if (delayableArbitration == null) continue;
                    delayableArbitration.getArbitration().attemptArbitration();
                }
                catch (InterruptedException e) {
                    this.logger.trace("ArbitratorRunnable interrupted. Stopping.");
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    this.logger.error("Unexpected exception in ArbitratorRunnable: " + e);
                    if (delayableArbitration == null) continue;
                    delayableArbitration.getArbitration().arbitrationFailed(e);
                }
            }
            this.logger.debug("Stop ArbitratorRunnable");
        }
    }
}

