/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.arbitration;

import com.google.common.collect.Sets;
import io.joynr.arbitration.ArbitrationCallback;
import io.joynr.arbitration.ArbitrationResult;
import io.joynr.arbitration.ArbitrationStatus;
import io.joynr.arbitration.ArbitrationStrategyFunction;
import io.joynr.arbitration.DelayableArbitration;
import io.joynr.arbitration.DiscoveryEntryVersionFilter;
import io.joynr.arbitration.DiscoveryQos;
import io.joynr.exceptions.DiscoveryException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrShutdownException;
import io.joynr.exceptions.MultiDomainNoCompatibleProviderFoundException;
import io.joynr.exceptions.NoCompatibleProviderFoundException;
import io.joynr.proxy.Callback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Semaphore;
import joynr.exceptions.ApplicationException;
import joynr.system.DiscoveryAsync;
import joynr.types.DiscoveryEntry;
import joynr.types.DiscoveryEntryWithMetaInfo;
import joynr.types.DiscoveryScope;
import joynr.types.ProviderQos;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Arbitrator {
    private static final Logger logger = LoggerFactory.getLogger(Arbitrator.class);
    static final DelayQueue<DelayableArbitration> arbitrationQueue = new DelayQueue();
    private final long MINIMUM_ARBITRATION_RETRY_DELAY;
    protected DiscoveryQos discoveryQos;
    protected DiscoveryAsync localDiscoveryAggregator;
    protected ArbitrationResult arbitrationResult = new ArbitrationResult();
    protected ArbitrationStatus arbitrationStatus = ArbitrationStatus.ArbitrationNotStarted;
    protected ArbitrationCallback arbitrationListener;
    private Semaphore arbitrationListenerSemaphore = new Semaphore(0);
    private long retryDelay = 0L;
    private long arbitrationDeadline;
    private Set<String> domains;
    private String interfaceName;
    private Version interfaceVersion;
    private ArbitrationStrategyFunction arbitrationStrategyFunction;
    private DiscoveryEntryVersionFilter discoveryEntryVersionFilter;
    private final Map<String, Set<Version>> discoveredVersions = new HashMap<String, Set<Version>>();

    public Arbitrator(Set<String> domains, String interfaceName, Version interfaceVersion, DiscoveryQos discoveryQos, DiscoveryAsync localDiscoveryAggregator, long minimumArbitrationRetryDelay, ArbitrationStrategyFunction arbitrationStrategyFunction, DiscoveryEntryVersionFilter discoveryEntryVersionFilter) {
        this.domains = domains;
        this.interfaceName = interfaceName;
        this.interfaceVersion = interfaceVersion;
        this.MINIMUM_ARBITRATION_RETRY_DELAY = minimumArbitrationRetryDelay;
        this.discoveryQos = discoveryQos;
        this.localDiscoveryAggregator = localDiscoveryAggregator;
        this.arbitrationStrategyFunction = arbitrationStrategyFunction;
        this.arbitrationDeadline = System.currentTimeMillis() + discoveryQos.getDiscoveryTimeoutMs();
        this.discoveryEntryVersionFilter = discoveryEntryVersionFilter;
    }

    protected void onError(Throwable exception) {
        if (exception instanceof JoynrShutdownException) {
            this.arbitrationFailed(exception);
        } else if (exception instanceof JoynrRuntimeException) {
            if (this.isArbitrationInTime()) {
                this.restartArbitration();
            } else {
                this.arbitrationFailed(exception);
            }
        } else if (exception instanceof ApplicationException) {
            this.arbitrationFailed(exception);
        } else {
            this.arbitrationFailed(new JoynrRuntimeException(exception));
        }
    }

    public void scheduleArbitration() {
        DelayableArbitration arbitration = new DelayableArbitration(this, this.retryDelay);
        arbitrationQueue.put(arbitration);
    }

    void attemptArbitration() {
        logger.debug("DISCOVERY lookup for domain: {}, interface: {}", this.domains, (Object)this.interfaceName);
        this.localDiscoveryAggregator.lookup((Callback)new DiscoveryCallback(), this.domains.toArray(new String[this.domains.size()]), this.interfaceName, new joynr.types.DiscoveryQos(Long.valueOf(this.discoveryQos.getCacheMaxAgeMs()), Long.valueOf(this.discoveryQos.getDiscoveryTimeoutMs()), DiscoveryScope.valueOf((String)this.discoveryQos.getDiscoveryScope().name()), Boolean.valueOf(this.discoveryQos.getProviderMustSupportOnChange())));
    }

    public void setArbitrationListener(ArbitrationCallback arbitrationListener) {
        this.arbitrationListener = arbitrationListener;
        this.arbitrationListenerSemaphore.release();
        if (this.arbitrationStatus == ArbitrationStatus.ArbitrationSuccesful) {
            this.arbitrationFinished(this.arbitrationStatus, this.arbitrationResult);
        }
    }

    protected void arbitrationFinished(ArbitrationStatus arbitrationStatus, ArbitrationResult arbitrationResult) {
        this.arbitrationStatus = arbitrationStatus;
        this.arbitrationResult = arbitrationResult;
        if (this.arbitrationListenerSemaphore.tryAcquire()) {
            this.arbitrationListener.onSuccess(arbitrationResult);
            this.arbitrationListenerSemaphore.release();
        }
    }

    public ArbitrationStatus getArbitrationStatus() {
        return this.arbitrationStatus;
    }

    protected boolean isArbitrationInTime() {
        return System.currentTimeMillis() < this.arbitrationDeadline;
    }

    protected void restartArbitration() {
        this.retryDelay = Math.max(this.discoveryQos.getRetryIntervalMs(), this.MINIMUM_ARBITRATION_RETRY_DELAY);
        logger.trace("Rescheduling arbitration with delay {}ms", (Object)this.retryDelay);
        this.scheduleArbitration();
    }

    protected void arbitrationFailed() {
        this.arbitrationFailed(null);
    }

    protected void arbitrationFailed(Throwable exception) {
        this.arbitrationStatus = ArbitrationStatus.ArbitrationCanceledForever;
        if (this.arbitrationListenerSemaphore.tryAcquire()) {
            Object reason = exception != null ? exception : (this.discoveredVersions == null || this.discoveredVersions.isEmpty() ? new DiscoveryException("Unable to find provider in time: interface: " + this.interfaceName + " domains: " + this.domains) : this.noCompatibleProviderFound(this.discoveredVersions));
            this.arbitrationListener.onError((Throwable)reason);
        }
    }

    private Throwable noCompatibleProviderFound(Map<String, Set<Version>> discoveredVersions) {
        IllegalStateException reason = null;
        if (this.domains.size() == 1) {
            reason = discoveredVersions.size() != 1 ? new IllegalStateException("Only looking for one domain, but got multi-domain result with discovered but incompatible versions.") : new NoCompatibleProviderFoundException(this.interfaceName, this.interfaceVersion, discoveredVersions.keySet().iterator().next(), discoveredVersions.values().iterator().next());
        } else if (this.domains.size() > 1) {
            HashMap<String, NoCompatibleProviderFoundException> exceptionsByDomain = new HashMap<String, NoCompatibleProviderFoundException>();
            for (Map.Entry<String, Set<Version>> versionsByDomainEntry : discoveredVersions.entrySet()) {
                exceptionsByDomain.put(versionsByDomainEntry.getKey(), new NoCompatibleProviderFoundException(this.interfaceName, this.interfaceVersion, versionsByDomainEntry.getKey(), versionsByDomainEntry.getValue()));
            }
            reason = new MultiDomainNoCompatibleProviderFoundException(exceptionsByDomain);
        }
        return reason;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.MINIMUM_ARBITRATION_RETRY_DELAY ^ this.MINIMUM_ARBITRATION_RETRY_DELAY >>> 32);
        result = 31 * result + (int)(this.arbitrationDeadline ^ this.arbitrationDeadline >>> 32);
        result = 31 * result + (this.arbitrationResult == null ? 0 : this.arbitrationResult.hashCode());
        result = 31 * result + (this.arbitrationStatus == null ? 0 : this.arbitrationStatus.hashCode());
        result = 31 * result + (this.discoveredVersions == null ? 0 : this.discoveredVersions.hashCode());
        result = 31 * result + (this.domains == null ? 0 : this.domains.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.interfaceVersion == null ? 0 : this.interfaceVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Arbitrator other = (Arbitrator)obj;
        if (this.MINIMUM_ARBITRATION_RETRY_DELAY != other.MINIMUM_ARBITRATION_RETRY_DELAY) {
            return false;
        }
        if (this.arbitrationDeadline != other.arbitrationDeadline) {
            return false;
        }
        if (this.arbitrationResult == null ? other.arbitrationResult != null : !this.arbitrationResult.equals(other.arbitrationResult)) {
            return false;
        }
        if (this.arbitrationStatus != other.arbitrationStatus) {
            return false;
        }
        if (this.discoveredVersions == null ? other.discoveredVersions != null : !this.discoveredVersions.equals(other.discoveredVersions)) {
            return false;
        }
        if (this.domains == null ? other.domains != null : !this.domains.equals(other.domains)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        return !(this.interfaceVersion == null ? other.interfaceVersion != null : !this.interfaceVersion.equals((Object)other.interfaceVersion));
    }

    private class DiscoveryCallback
    extends Callback<DiscoveryEntryWithMetaInfo[]> {
        private DiscoveryCallback() {
        }

        public void onFailure(JoynrRuntimeException error) {
            Arbitrator.this.onError(error);
        }

        public void onSuccess(DiscoveryEntryWithMetaInfo[] discoveryEntries) {
            assert (discoveryEntries != null) : "Discovery entries may not be null.";
            if (this.allDomainsDiscovered((DiscoveryEntry[])discoveryEntries)) {
                logger.trace("Lookup succeeded. Got {}", (Object)Arrays.toString(discoveryEntries));
                Set<DiscoveryEntryWithMetaInfo> discoveryEntriesSet = this.filterDiscoveryEntries(discoveryEntries);
                Set selectedCapabilities = Arbitrator.this.arbitrationStrategyFunction.select(Arbitrator.this.discoveryQos.getCustomParameters(), discoveryEntriesSet);
                logger.trace("Selected capabilities: {}", (Object)selectedCapabilities);
                if (selectedCapabilities != null && !selectedCapabilities.isEmpty()) {
                    Arbitrator.this.arbitrationResult.setDiscoveryEntries(selectedCapabilities);
                    Arbitrator.this.arbitrationFinished(ArbitrationStatus.ArbitrationSuccesful, Arbitrator.this.arbitrationResult);
                } else {
                    Arbitrator.this.arbitrationFailed();
                }
            } else if (Arbitrator.this.isArbitrationInTime()) {
                Arbitrator.this.restartArbitration();
            } else {
                Arbitrator.this.arbitrationFailed();
            }
        }

        private boolean allDomainsDiscovered(DiscoveryEntry[] discoveryEntries) {
            HashSet<String> discoveredDomains = new HashSet<String>();
            for (DiscoveryEntry foundDiscoveryEntry : discoveryEntries) {
                discoveredDomains.add(foundDiscoveryEntry.getDomain());
            }
            boolean allDomainsDiscovered = discoveredDomains.equals(Arbitrator.this.domains);
            if (!allDomainsDiscovered) {
                HashSet missingDomains = new HashSet(Arbitrator.this.domains);
                missingDomains.removeAll(discoveredDomains);
                logger.trace("All domains must be found. Domains not found: {}", missingDomains);
            }
            return allDomainsDiscovered;
        }

        private Set<DiscoveryEntryWithMetaInfo> filterDiscoveryEntries(DiscoveryEntryWithMetaInfo[] discoveryEntries) {
            Set<DiscoveryEntryWithMetaInfo> discoveryEntriesSet;
            if (Arbitrator.this.discoveryQos.getProviderMustSupportOnChange()) {
                discoveryEntriesSet = new HashSet<DiscoveryEntryWithMetaInfo>(discoveryEntries.length);
                for (DiscoveryEntryWithMetaInfo discoveryEntry : discoveryEntries) {
                    ProviderQos providerQos = discoveryEntry.getQos();
                    if (!providerQos.getSupportsOnChangeSubscriptions().booleanValue()) continue;
                    discoveryEntriesSet.add(discoveryEntry);
                }
            } else {
                discoveryEntriesSet = Sets.newHashSet((Object[])discoveryEntries);
            }
            if ((discoveryEntriesSet = Arbitrator.this.discoveryEntryVersionFilter.filter(Arbitrator.this.interfaceVersion, discoveryEntriesSet, Arbitrator.this.discoveredVersions)).isEmpty()) {
                logger.debug(String.format("No discovery entries left after filtering while looking for %s in version %s.%nEntries found: %s", Arbitrator.this.interfaceName, Arbitrator.this.interfaceVersion, Arrays.toString(discoveryEntries)));
            }
            return discoveryEntriesSet;
        }
    }
}

