/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.common.io.Files;
import io.joynr.capabilities.StaticCapabilitiesProvisioning;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceContentProvider {
    private static final Logger logger = LoggerFactory.getLogger(ResourceContentProvider.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public String readFromFileOrResourceOrUrl(String provisionedCapabilitiesJsonFilename) {
        logger.trace("Attempting to read statically provisioned capabilities from JSON in file/resource/URL: {}", (Object)provisionedCapabilitiesJsonFilename);
        IOException ioException = null;
        String result = null;
        try {
            URI uri = new URI(provisionedCapabilitiesJsonFilename);
            if (!uri.isAbsolute()) {
                throw new URISyntaxException(provisionedCapabilitiesJsonFilename, "URI is not absolute");
            }
            result = this.readFromUri(uri);
        }
        catch (URISyntaxException e) {
            logger.trace("{} is not  URL. Trying to read from filesystem / classpath.", (Object)provisionedCapabilitiesJsonFilename, (Object)e);
        }
        catch (IOException e) {
            ioException = e;
        }
        if (result == null && ioException == null) {
            try {
                result = this.readFromFileOrClasspath(provisionedCapabilitiesJsonFilename);
            }
            catch (IOException e) {
                ioException = e;
            }
        }
        if (ioException != null) {
            throw new IllegalArgumentException("Unable to read provisioned capabilities from " + provisionedCapabilitiesJsonFilename, ioException);
        }
        if (result == null) {
            throw new IllegalStateException(provisionedCapabilitiesJsonFilename + " not found as URL or on filesystem or classpath.");
        }
        return result;
    }

    private String readFromFileOrClasspath(String provisionedCapabilitiesJsonFilename) throws IOException {
        logger.trace("Attempting to read {} from file / classpath", (Object)provisionedCapabilitiesJsonFilename);
        File file = new File(provisionedCapabilitiesJsonFilename);
        if (file.exists()) {
            return Files.toString((File)file, (Charset)UTF8);
        }
        logger.trace("File {} doesn't exist on filesystem, attempting to read from classpath.", (Object)provisionedCapabilitiesJsonFilename);
        try (InputStream resourceAsStream = StaticCapabilitiesProvisioning.class.getClassLoader().getResourceAsStream(provisionedCapabilitiesJsonFilename);){
            if (resourceAsStream != null) {
                String string = this.readFromStream(resourceAsStream);
                return string;
            }
        }
        return null;
    }

    private String readFromUri(URI uri) throws IOException {
        URL url = new URL(uri.toString());
        logger.trace("Attempting to read from URL {}", (Object)url);
        InputStream inputStream = url.openStream();
        return this.readFromStream(inputStream);
    }

    /*
     * Exception decompiling
     */
    private String readFromStream(InputStream inputStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

