/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import io.jmix.gradle.BaseEnhancingStep;
import io.jmix.gradle.MetaModelUtil;
import java.io.IOException;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import org.apache.commons.lang3.StringUtils;

public class SettersEnhancingStep
extends BaseEnhancingStep {
    @Override
    protected boolean isAlreadyEnhanced(CtClass ctClass) throws NotFoundException {
        return MetaModelUtil.isSettersEnhanced(ctClass);
    }

    @Override
    protected String getEnhancingType() {
        return "Setters Enhancer";
    }

    @Override
    protected void executeInternal(CtClass ctClass) throws IOException, CannotCompileException, NotFoundException {
        this.enhanceSetters(ctClass);
        this.enhanceProtectedForPersistentMethods(ctClass);
        ctClass.addInterface(this.classPool.get("io.jmix.core.entity.JmixSettersEnhanced"));
    }

    protected void enhanceSetters(CtClass ctClass) throws NotFoundException, CannotCompileException {
        boolean jmixPropertiesAnnotatedOnly = MetaModelUtil.isJmixPropertiesAnnotatedOnly(ctClass);
        boolean isPersistentEntity = MetaModelUtil.isJpaEntity(ctClass) || MetaModelUtil.isJpaEmbeddable(ctClass) || MetaModelUtil.isJpaMappedSuperclass(ctClass);
        for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
            if (!MetaModelUtil.isSetterMethod(ctMethod)) continue;
            CtField field = MetaModelUtil.findDeclaredFieldByAccessor(ctClass, ctMethod.getName());
            if (field == null) {
                field = MetaModelUtil.findDeclaredKotlinBooleanFieldByAccessor(ctClass, ctMethod.getName());
            }
            if (field == null || isPersistentEntity && MetaModelUtil.isTransientField(ctClass, field.getName()) && !MetaModelUtil.isJmixProperty(ctClass, field.getName()) || !MetaModelUtil.isPersistentField(ctClass, field.getName()) && !MetaModelUtil.isJmixProperty(ctClass, field.getName()) && jmixPropertiesAnnotatedOnly) continue;
            CtClass paramType = ctMethod.getParameterTypes()[0];
            if (paramType.isPrimitive()) {
                throw new IllegalStateException(String.format("Unable to enhance field %s.%s with primitive type %s. Use type %s.", ctClass.getName(), field.getName(), paramType.getSimpleName(), StringUtils.capitalize((String)paramType.getSimpleName())));
            }
            ctMethod.addLocalVariable("__prev", paramType);
            ctMethod.addLocalVariable("__new", paramType);
            String getterName = "get" + ctMethod.getName().substring(3);
            CtMethod getter = MetaModelUtil.findDeclaredMethod(ctClass, getterName);
            if (getter == null) {
                getterName = "is" + ctMethod.getName().substring(3);
            }
            ctMethod.insertBefore("__prev = this." + getterName + "();");
            ctMethod.insertAfter("__new = this." + getterName + "();io.jmix.core.impl.EntityInternals.fireListeners(this, \"" + field.getName() + "\", __prev, __new);");
        }
    }

    protected void enhanceProtectedForPersistentMethods(CtClass ctClass) {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!MetaModelUtil.isPersistentMethod(method)) continue;
            method.setModifiers(Modifier.setProtected((int)method.getModifiers()));
        }
    }
}

