/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;

public class AnnotationsInfo {
    public static final String LEGACY_INTERFACE_CREATABLE = "com.haulmont.cuba.core.entity.Creatable";
    public static final String LEGACY_INTERFACE_UPDATABLE = "com.haulmont.cuba.core.entity.Updatable";
    public static final String LEGACY_INTERFACE_SOFT_DELETE = "com.haulmont.cuba.core.entity.SoftDelete";
    public static final String LEGACY_INTERFACE_HAS_UUID = "com.haulmont.cuba.core.entity.HasUuid";
    private Multimap<FieldAnnotation, CtField> declaredFields = HashMultimap.create();
    private Multimap<FieldAnnotation, CtField> inheritedFields = HashMultimap.create();
    private Set<ClassAnnotation> declaredClassAnnotations = new HashSet<ClassAnnotation>();
    private Map<ClassAnnotation, CtClass> inheritedClassAnnotations = new HashMap<ClassAnnotation, CtClass>();
    private CtClass entityClass;

    private AnnotationsInfo(CtClass entityClass) {
        this.entityClass = entityClass;
    }

    public static AnnotationsInfo forClass(CtClass entityClass) throws NotFoundException {
        AnnotationsInfo info = new AnnotationsInfo(entityClass);
        HashSet interfaceNames = new HashSet();
        CtClass current = entityClass;
        while (current.getSuperclass() != null) {
            AnnotationsAttribute attribute;
            List currentInterfaces = Arrays.stream(current.getInterfaces()).map(CtClass::getName).collect(Collectors.toList());
            interfaceNames.addAll(currentInterfaces);
            if (currentInterfaces.contains(LEGACY_INTERFACE_HAS_UUID)) {
                info.putClassAnnotation(ClassAnnotation.LEGACY_HAS_UUID, current);
            }
            if ((attribute = (AnnotationsAttribute)current.getClassFile2().getAttribute("RuntimeVisibleAnnotations")) != null) {
                for (Annotation annotation : attribute.getAnnotations()) {
                    ClassAnnotation known = ClassAnnotation.find(annotation.getTypeName());
                    if (known == null) continue;
                    info.putClassAnnotation(known, current);
                }
            }
            for (Annotation annotation : current.getDeclaredFields()) {
                AnnotationsAttribute annotationsInfo = (AnnotationsAttribute)annotation.getFieldInfo2().getAttribute("RuntimeVisibleAnnotations");
                if (annotationsInfo == null) continue;
                for (Annotation annotation2 : annotationsInfo.getAnnotations()) {
                    FieldAnnotation known = FieldAnnotation.find(annotation2.getTypeName());
                    if (known == null) continue;
                    info.putField(known, (CtField)annotation);
                }
            }
            current = current.getSuperclass();
        }
        if (interfaceNames.contains(LEGACY_INTERFACE_CREATABLE)) {
            info.putField(FieldAnnotation.CREATED_BY, entityClass.getField("createdBy"));
            info.putField(FieldAnnotation.CREATED_DATE, entityClass.getField("createTs"));
        }
        if (interfaceNames.contains(LEGACY_INTERFACE_UPDATABLE)) {
            info.putField(FieldAnnotation.LAST_MODIFIED_BY, entityClass.getField("updatedBy"));
            info.putField(FieldAnnotation.LAST_MODIFIED_DATE, entityClass.getField("updateTs"));
        }
        if (interfaceNames.contains(LEGACY_INTERFACE_SOFT_DELETE)) {
            info.putField(FieldAnnotation.DELETED_DATE, entityClass.getField("deleteTs"));
            info.putField(FieldAnnotation.DELETED_BY, entityClass.getField("deletedBy"));
        }
        return info;
    }

    protected void putField(FieldAnnotation annotation, CtField field) {
        CtField alreadyAnnotated = this.getAnnotatedField(annotation);
        if (alreadyAnnotated != null && annotation.unique && !this.isSameField(alreadyAnnotated, field)) {
            throw new RuntimeException(String.format("More than one @%s field in %s: %s#%s, %s#%s", annotation.getSimpleName(), this.entityClass.getName(), alreadyAnnotated.getDeclaringClass().getSimpleName(), alreadyAnnotated.getName(), field.getDeclaringClass().getSimpleName(), field.getName()));
        }
        if (this.entityClass.getName().equals(field.getDeclaringClass().getName())) {
            this.declaredFields.put((Object)annotation, (Object)field);
        } else {
            this.inheritedFields.put((Object)annotation, (Object)field);
        }
    }

    private boolean isSameField(CtField first, CtField second) {
        return Objects.equals(first.getName(), second.getName()) && Objects.equals(first.getDeclaringClass().getName(), second.getDeclaringClass().getName());
    }

    protected void putClassAnnotation(ClassAnnotation annotation, CtClass ctClass) {
        if (this.entityClass.getName().equals(ctClass.getName())) {
            this.declaredClassAnnotations.add(annotation);
        } else {
            this.inheritedClassAnnotations.put(annotation, ctClass);
        }
    }

    @Nullable
    public CtField getAnnotatedField(FieldAnnotation annotation) {
        if (this.declaredFields.containsKey((Object)annotation)) {
            Collection ctFields = this.declaredFields.get((Object)annotation);
            return ctFields.isEmpty() ? null : (CtField)ctFields.iterator().next();
        }
        Collection ctFields = this.inheritedFields.get((Object)annotation);
        return ctFields.isEmpty() ? null : (CtField)ctFields.iterator().next();
    }

    public List<CtField> getAnnotatedFields(FieldAnnotation annotation) {
        ArrayList<CtField> list = new ArrayList<CtField>();
        list.addAll(this.inheritedFields.get((Object)annotation));
        list.addAll(this.declaredFields.get((Object)annotation));
        return list;
    }

    public boolean hasClassAnnotation(ClassAnnotation annotation) {
        return this.declaredClassAnnotations.contains((Object)annotation) || this.inheritedClassAnnotations.containsKey((Object)annotation);
    }

    public boolean hasMetadataChanges() {
        return !this.declaredFields.isEmpty() || !this.declaredClassAnnotations.isEmpty();
    }

    @Nullable
    public CtField getPrimaryKey() {
        CtField result = this.getAnnotatedField(FieldAnnotation.ID);
        if (result == null && (result = this.getAnnotatedField(FieldAnnotation.EMBEDDED_ID)) == null) {
            result = this.getAnnotatedField(FieldAnnotation.JMIX_ID);
        }
        return result;
    }

    public static enum ClassAnnotation {
        JMIX_ENTITY("io.jmix.core.metamodel.annotation.JmixEntity"),
        EMBEDDABLE("jakarta.persistence.Embeddable"),
        LEGACY_HAS_UUID("LEGACY_HAS_UUID");

        private final String className;

        private ClassAnnotation(String className) {
            this.className = className;
        }

        public static ClassAnnotation find(String className) {
            for (ClassAnnotation annotation : ClassAnnotation.values()) {
                if (!annotation.className.equals(className)) continue;
                return annotation;
            }
            return null;
        }
    }

    public static enum FieldAnnotation {
        CREATED_BY("org.springframework.data.annotation.CreatedBy"),
        CREATED_DATE("org.springframework.data.annotation.CreatedDate"),
        LAST_MODIFIED_BY("org.springframework.data.annotation.LastModifiedBy"),
        LAST_MODIFIED_DATE("org.springframework.data.annotation.LastModifiedDate"),
        DELETED_BY("io.jmix.core.annotation.DeletedBy"),
        DELETED_DATE("io.jmix.core.annotation.DeletedDate"),
        VERSION("jakarta.persistence.Version"),
        ID("jakarta.persistence.Id"),
        EMBEDDED_ID("jakarta.persistence.EmbeddedId"),
        JMIX_ID("io.jmix.core.entity.annotation.JmixId"),
        JMIX_GENERATED_VALUE("io.jmix.core.entity.annotation.JmixGeneratedValue", false);

        private final String className;
        private final boolean unique;

        private FieldAnnotation(String className) {
            this(className, true);
        }

        private FieldAnnotation(String className, boolean unique) {
            this.className = className;
            this.unique = unique;
        }

        public static FieldAnnotation find(String className) {
            for (FieldAnnotation annotation : FieldAnnotation.values()) {
                if (!annotation.className.equals(className)) continue;
                return annotation;
            }
            return null;
        }

        public String getSimpleName() {
            return this.className.substring(this.className.lastIndexOf(46) + 1);
        }
    }
}

