/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;

public abstract class WidgetsTask
extends DefaultTask {
    protected static final String MAIN_SOURCE_SET = "main";
    @Internal
    protected List<String> excludes = new ArrayList<String>();
    @Internal
    protected List<String> excludePaths = new ArrayList<String>();
    @Internal
    protected List<String> includePaths = new ArrayList<String>();
    @Internal
    protected Set<String> compilerJvmArgs = new LinkedHashSet<String>(Collections.singleton("-Djava.awt.headless=true"));

    public void excludeJars(String ... artifacts) {
        this.excludes.addAll(Arrays.asList(artifacts));
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getExcludePaths() {
        return this.excludePaths;
    }

    public void excludePaths(String ... excludes) {
        this.excludePaths.addAll(Arrays.asList(excludes));
    }

    public List<String> getIncludePaths() {
        return this.includePaths;
    }

    public void includePaths(String ... includes) {
        this.includePaths.addAll(Arrays.asList(includes));
    }

    public void jvmArgs(String ... jvmArgs) {
        this.compilerJvmArgs.addAll(Arrays.asList(jvmArgs));
    }

    public Set<String> getCompilerJvmArgs() {
        return this.compilerJvmArgs;
    }

    protected Collection<File> getClassesDirs(SourceSet sourceSet) {
        return sourceSet.getOutput().getClassesDirs().getFiles();
    }

    protected void collectProjectsWithDependency(Project project, String dependencyName, Set<Project> explored) {
        Configuration compileConfiguration = (Configuration)project.getConfigurations().findByName("compileClasspath");
        if (compileConfiguration != null) {
            for (Dependency dependencyItem : compileConfiguration.getAllDependencies()) {
                Set artifacts;
                ResolvedArtifact vaadinArtifact;
                Configuration dependencyCompile;
                Project dependencyProject;
                if (!(dependencyItem instanceof ProjectDependency) || explored.contains(dependencyProject = ((ProjectDependency)dependencyItem).getDependencyProject()) || (dependencyCompile = (Configuration)dependencyProject.getConfigurations().findByName("compileClasspath")) == null || (vaadinArtifact = (ResolvedArtifact)(artifacts = dependencyCompile.getResolvedConfiguration().getResolvedArtifacts()).stream().filter(a -> a.getName().equals(dependencyName)).findFirst().orElse(null)) == null) continue;
                explored.add(dependencyProject);
                this.collectProjectsWithDependency(dependencyProject, dependencyName, explored);
            }
        }
    }

    protected Set<Project> collectProjectsWithDependency(String dependencyName) {
        LinkedHashSet<Project> result = new LinkedHashSet<Project>();
        this.collectProjectsWithDependency(this.getProject(), dependencyName, result);
        return result;
    }

    protected SourceSet getSourceSet(Project project, String sourceSetName) {
        return (SourceSet)((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets().getByName(sourceSetName);
    }

    protected boolean includedArtifact(String name) {
        return !this.excludes.contains(name);
    }

    @Internal
    public FileCollection getSourceFiles() {
        this.getProject().getLogger().info("Analyze source projects for widgetset building in {}", (Object)this.getProject().getName());
        ArrayList<File> sources = new ArrayList<File>();
        ArrayList files = new ArrayList();
        SourceSet mainSourceSet = this.getSourceSet(this.getProject(), MAIN_SOURCE_SET);
        sources.addAll(mainSourceSet.getJava().getSrcDirs());
        sources.addAll(this.getClassesDirs(mainSourceSet));
        sources.add(mainSourceSet.getOutput().getResourcesDir());
        for (Project dependencyProject : this.collectProjectsWithDependency("vaadin-client")) {
            this.getProject().getLogger().info("\tFound source project {} for widgetset building", (Object)dependencyProject.getName());
            SourceSet depMainSourceSet = this.getSourceSet(dependencyProject, MAIN_SOURCE_SET);
            sources.addAll(depMainSourceSet.getJava().getSrcDirs());
            sources.addAll(this.getClassesDirs(depMainSourceSet));
            sources.add(depMainSourceSet.getOutput().getResourcesDir());
        }
        sources.forEach(sourceDir -> {
            if (sourceDir.exists()) {
                this.getProject().fileTree(sourceDir, f -> {
                    ArrayList<String> excludes = new ArrayList<String>();
                    excludes.addAll(Arrays.asList("**/.*", "**/META-INF/build-info.properties"));
                    excludes.addAll(this.excludePaths);
                    f.setExcludes(excludes);
                    if (!this.includePaths.isEmpty()) {
                        f.setIncludes(this.includePaths);
                    }
                }).forEach(files::add);
            }
        });
        return this.getProject().files(new Object[]{files});
    }
}

