/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class MetaModelUtil {
    public static final String ENTITY_TYPE = "io.jmix.core.Entity";
    public static final String ENTITY_ENTRY_TYPE = "io.jmix.core.EntityEntry";
    public static final String BASE_ENTITY_ENTRY_TYPE = "io.jmix.core.entity.BaseEntityEntry";
    public static final String EMBEDDABLE_ENTITY_ENTRY_TYPE = "io.jmix.core.entity.EmbeddableEntityEntry";
    public static final String NULLABLE_ID_ENTITY_ENTRY_TYPE = "io.jmix.core.entity.NullableIdEntityEntry";
    public static final String NO_ID_ENTITY_ENTRY_TYPE = "io.jmix.core.entity.NoIdEntityEntry";
    public static final String SETTERS_ENHANCED_TYPE = "io.jmix.core.entity.JmixSettersEnhanced";
    public static final String ENTITY_ENTRY_ENHANCED_TYPE = "io.jmix.core.entity.JmixEntityEntryEnhanced";
    public static final String TRANSIENT_ANNOTATION_TYPE = "javax.persistence.Transient";
    public static final String JMIX_PROPERTY_ANNOTATION_TYPE = "io.jmix.core.metamodel.annotation.JmixProperty";
    public static final String DISABLE_ENHANCING_ANNOTATION_TYPE = "io.jmix.core.entity.annotation.DisableEnhancing";
    public static final String JMIX_ENTITY_ANNOTATION_TYPE = "io.jmix.core.metamodel.annotation.JmixEntity";
    public static final String ENTITY_ANNOTATION_TYPE = "javax.persistence.Entity";
    public static final String EMBEDDABLE_ANNOTATION_TYPE = "javax.persistence.Embeddable";
    public static final String CONVERTER_ANNOTATION_TYPE = "javax.persistence.Converter";
    public static final String STORE_ANNOTATION_TYPE = "io.jmix.core.metamodel.annotation.Store";
    public static final String REPLACE_ENTITY_ANNOTATION_TYPE = "io.jmix.core.entity.annotation.ReplaceEntity";
    public static final String GET_ENTITY_ENTRY_METHOD_NAME = "__getEntityEntry";
    public static final String COPY_ENTITY_ENTRY_METHOD_NAME = "__copyEntityEntry";
    public static final String WRITE_OBJECT_METHOD_NAME = "writeObject";
    public static final String READ_OBJECT_METHOD_NAME = "readObject";
    public static final String GEN_ENTITY_ENTRY_VAR_NAME = "_jmixEntityEntry";
    public static final String GEN_ENTITY_ENTRY_CLASS_NAME = "JmixEntityEntry";

    public static boolean isSettersEnhanced(CtClass ctClass) throws NotFoundException {
        for (CtClass ctInterface : ctClass.getInterfaces()) {
            if (!Objects.equals(ctInterface.getName(), SETTERS_ENHANCED_TYPE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityEntryEnhanced(CtClass ctClass) throws NotFoundException {
        for (CtClass ctInterface : ctClass.getInterfaces()) {
            if (!Objects.equals(ctInterface.getName(), ENTITY_ENTRY_ENHANCED_TYPE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEnhancingDisabled(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && attribute.getAnnotation(DISABLE_ENHANCING_ANNOTATION_TYPE) != null;
    }

    public static boolean subtypeOfEntityInterface(CtClass ctClass, ClassPool pool) throws NotFoundException {
        return ctClass.subtypeOf(pool.get(ENTITY_TYPE));
    }

    public static boolean isJpaEntity(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && attribute.getAnnotation(ENTITY_ANNOTATION_TYPE) != null;
    }

    public static boolean isJpaEmbeddable(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && attribute.getAnnotation(EMBEDDABLE_ANNOTATION_TYPE) != null;
    }

    public static boolean isJpaConverter(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && attribute.getAnnotation(CONVERTER_ANNOTATION_TYPE) != null;
    }

    public static boolean isJpaMappedSuperclass(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && attribute.getAnnotation("javax.persistence.MappedSuperclass") != null;
    }

    public static boolean isModuleConfig(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && (attribute.getAnnotation("io.jmix.core.annotation.JmixModule") != null || attribute.getAnnotation("org.springframework.boot.autoconfigure.SpringBootApplication") != null || attribute.getAnnotation("org.springframework.boot.autoconfigure.EnableAutoConfiguration") != null);
    }

    public static boolean isJmixEntity(CtClass ctClass) {
        AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        return attribute != null && attribute.getAnnotation(JMIX_ENTITY_ANNOTATION_TYPE) != null;
    }

    public static boolean isJmixPropertiesAnnotatedOnly(CtClass ctClass) {
        if (MetaModelUtil.isJmixEntity(ctClass)) {
            AnnotationsAttribute attribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
            BooleanMemberValue annotatedPropertiesOnly = (BooleanMemberValue)attribute.getAnnotation(JMIX_ENTITY_ANNOTATION_TYPE).getMemberValue("annotatedPropertiesOnly");
            return annotatedPropertiesOnly != null && annotatedPropertiesOnly.getValue();
        }
        return true;
    }

    public static boolean isPkGeneratedValue(CtField field) {
        AnnotationsAttribute annotationsInfo = (AnnotationsAttribute)field.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        return annotationsInfo != null && annotationsInfo.getAnnotation("javax.persistence.GeneratedValue") != null;
    }

    public static boolean isPersistentMethod(CtMethod ctMethod) {
        return ctMethod.getName().startsWith("_persistence_get_") || ctMethod.getName().startsWith("_persistence_set_");
    }

    public static boolean isPersistentField(CtClass ctClass, String fieldName) {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!Objects.equals(method.getName(), "_persistence_set_" + fieldName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJmixProperty(CtClass ctClass, String fieldName) {
        CtField ctField = MetaModelUtil.findDeclaredField(ctClass, fieldName);
        CtMethod ctMethod = MetaModelUtil.findDeclaredMethod(ctClass, "get" + StringUtils.capitalize((String)fieldName));
        return ctField != null && MetaModelUtil.hasAnnotationOnField(ctField, JMIX_PROPERTY_ANNOTATION_TYPE) || ctMethod != null && MetaModelUtil.hasAnnotationOnMethod(ctMethod, JMIX_PROPERTY_ANNOTATION_TYPE);
    }

    public static boolean isTransientField(CtClass ctClass, String fieldName) {
        CtField ctField = MetaModelUtil.findDeclaredField(ctClass, fieldName);
        return ctField != null && MetaModelUtil.hasAnnotationOnField(ctField, TRANSIENT_ANNOTATION_TYPE);
    }

    public static boolean isSetterMethod(CtMethod ctMethod) throws NotFoundException {
        return !Modifier.isAbstract((int)ctMethod.getModifiers()) && ctMethod.getName().startsWith("set") && ctMethod.getReturnType() == CtClass.voidType && ctMethod.getParameterTypes().length == 1;
    }

    public static String generateFieldNameByMethod(String methodName) {
        return StringUtils.uncapitalize((String)methodName.substring(3));
    }

    public static CtField findDeclaredFieldByAccessor(CtClass ctClass, String accessorName) {
        String fieldName = accessorName.substring(3);
        for (CtField field : ctClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName) && !field.getName().equals(StringUtils.uncapitalize((String)fieldName))) continue;
            return field;
        }
        return null;
    }

    public static CtField findDeclaredKotlinBooleanFieldByAccessor(CtClass ctClass, String accessorName) {
        String kotlinPropertyName = "is" + StringUtils.capitalize((String)accessorName.substring(3));
        for (CtField field : ctClass.getDeclaredFields()) {
            if (!field.getName().equals(kotlinPropertyName)) continue;
            return field;
        }
        return null;
    }

    public static CtField findDeclaredField(CtClass ctClass, String fieldName) {
        for (CtField field : ctClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static CtMethod findDeclaredMethod(CtClass ctClass, String name) {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    public static CtMethod findEqualsMethod(CtClass ctClass) throws NotFoundException {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!"equals".equals(method.getName()) || !CtClass.booleanType.equals(method.getReturnType()) || method.getParameterTypes().length != 1 || !Object.class.getName().equals(method.getParameterTypes()[0].getName())) continue;
            return method;
        }
        return null;
    }

    public static CtMethod findHashCodeMethod(CtClass ctClass) throws NotFoundException {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!"hashCode".equals(method.getName()) || !CtClass.intType.equals(method.getReturnType()) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    public static CtMethod findToStringMethod(CtClass ctClass) throws NotFoundException {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!"toString".equals(method.getName()) || !String.class.getName().equals(method.getReturnType().getName()) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    public static CtMethod findWriteObjectMethod(CtClass ctClass) throws NotFoundException {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!WRITE_OBJECT_METHOD_NAME.equals(method.getName()) || !CtClass.voidType.equals(method.getReturnType()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static CtMethod findReadObjectMethod(CtClass ctClass) throws NotFoundException {
        for (CtMethod method : ctClass.getDeclaredMethods()) {
            if (!READ_OBJECT_METHOD_NAME.equals(method.getName()) || !CtClass.voidType.equals(method.getReturnType()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        return null;
    }

    public static boolean hasAnnotationOnField(CtField ctField, String annotationType) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        return annotationsAttribute != null && annotationsAttribute.getAnnotation(annotationType) != null;
    }

    public static boolean hasAnnotationOnMethod(CtMethod ctMethod, String annotationType) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctMethod.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        return annotationsAttribute != null && annotationsAttribute.getAnnotation(annotationType) != null;
    }

    @Nullable
    public static String findStoreName(CtClass ctClass) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        Annotation annotation = annotationsAttribute.getAnnotation(STORE_ANNOTATION_TYPE);
        return annotation == null ? null : ((StringMemberValue)annotation.getMemberValue("name")).getValue();
    }

    @Nullable
    public static String findReplacedEntity(CtClass ctClass) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        Annotation annotation = annotationsAttribute.getAnnotation(REPLACE_ENTITY_ANNOTATION_TYPE);
        return annotation == null ? null : ((ClassMemberValue)annotation.getMemberValue("value")).getValue();
    }

    public static boolean isCollection(CtField field) throws NotFoundException {
        HashSet<String> classNames = new HashSet<String>();
        for (CtClass current = field.getType(); current != null; current = current.getSuperclass()) {
            classNames.add(current.getName());
            classNames.addAll(Arrays.stream(current.getInterfaces()).map(CtClass::getName).collect(Collectors.toList()));
        }
        return classNames.contains(Collection.class.getCanonicalName());
    }
}

