/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle.ui;

import com.google.common.base.Splitter;
import com.vaadin.sass.internal.ScssContext;
import com.vaadin.sass.internal.ScssStylesheet;
import com.vaadin.sass.internal.handler.SCSSDocumentHandler;
import com.vaadin.sass.internal.handler.SCSSDocumentHandlerImpl;
import com.vaadin.sass.internal.handler.SCSSErrorHandler;
import com.yahoo.platform.yui.compressor.CssCompressor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;

public class ThemeCompile
extends DefaultTask {
    public static final String VAADIN_STYLESHEETS_MANIFEST_KEY = "Vaadin-Stylesheets";
    public static final String COMPILE_CLASSPATH_CONFIGURATION = "compileClasspath";
    @Input
    protected List<String> themes = new ArrayList<String>();
    @Input
    protected String scssDir = "src/main/themes";
    @Input
    protected String destDir = "";
    @Input
    protected boolean compress = true;
    @Input
    protected boolean cleanup = true;
    @Input
    protected boolean gzip = true;
    protected List<String> excludedThemes = new ArrayList<String>();
    protected List<String> excludePaths = new ArrayList<String>();
    protected List<String> doNotUnpackPaths = Arrays.asList("VAADIN/themes/valo/*.css", "VAADIN/themes/valo/*.css.gz", "VAADIN/themes/valo/favicon.ico", "VAADIN/themes/valo/util/readme.txt", "META-INF/**");

    public ThemeCompile() {
        this.setDescription("Compile SCSS styles in theme");
        this.setGroup("web");
    }

    @OutputDirectory
    public File getOutputDirectory() {
        if (this.destDir == null || this.destDir.isEmpty()) {
            return new File(this.getProject().getBuildDir(), "themes");
        }
        return new File(this.getProject().getProjectDir(), this.destDir);
    }

    @InputDirectory
    public File getSourceDirectory() {
        return this.getProject().file((Object)this.scssDir);
    }

    public List<String> getThemes() {
        return this.themes;
    }

    public void setThemes(List<String> themes) {
        this.themes = themes;
    }

    public String getScssDir() {
        return this.scssDir;
    }

    public void setScssDir(String scssDir) {
        this.scssDir = scssDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    @TaskAction
    public void compileThemes() throws IOException {
        File stylesDirectory = this.getSourceDirectory();
        if (!stylesDirectory.exists()) {
            throw new FileNotFoundException(String.format("Unable to find SCSS themes root directory: %s", stylesDirectory.getAbsolutePath()));
        }
        File themesTmp = new File(this.getProject().getBuildDir(), "tmp/themes");
        if (themesTmp.exists()) {
            FileUtils.deleteDirectory((File)themesTmp);
        } else {
            FileUtils.forceMkdirParent((File)themesTmp);
        }
        FileUtils.forceMkdir((File)themesTmp);
        File vaadinThemesRoot = new File(themesTmp, "VAADIN/themes");
        FileUtils.forceMkdir((File)vaadinThemesRoot);
        ArrayList<String> themes = new ArrayList<String>(this.themes);
        if (themes.isEmpty()) {
            this.getLogger().info("[ThemeCompile] scan directory '{}' for themes", (Object)stylesDirectory.getAbsolutePath());
            File[] themeFolders = stylesDirectory.listFiles(pathname -> pathname.isDirectory() && !pathname.getName().startsWith("."));
            if (themeFolders != null) {
                Arrays.stream(themeFolders).map(File::getName).forEach(themes::add);
            }
        }
        this.unpackVaadinAddonsThemes(themesTmp);
        this.unpackThemesDependencies(themesTmp, vaadinThemesRoot);
        for (String themeDirName : themes) {
            this.buildTheme(themeDirName, stylesDirectory, vaadinThemesRoot);
        }
        File destinationDirectory = this.getOutputDirectory();
        this.copyResources(themesTmp, destinationDirectory);
        if (this.cleanup) {
            this.removeEmptyDirs(destinationDirectory);
        }
        for (String themeName : this.excludedThemes) {
            File themeDestDir = new File(destinationDirectory, themeName);
            this.getLogger().info("[ThemeCompile] excluded theme '{}'", (Object)themeName);
            FileUtils.deleteQuietly((File)themeDestDir);
        }
        for (String path : this.excludePaths) {
            File pathFile = new File(destinationDirectory, path);
            this.getLogger().info("[ThemeCompile] excluded path '{}'", (Object)path);
            FileUtils.deleteQuietly((File)pathFile);
        }
    }

    protected void unpackVaadinAddonsThemes(File themesTmp) {
        Configuration compileConfiguration = (Configuration)this.getProject().getConfigurations().findByName(COMPILE_CLASSPATH_CONFIGURATION);
        if (compileConfiguration == null) {
            return;
        }
        Set resolvedArtifacts = compileConfiguration.getResolvedConfiguration().getResolvedArtifacts();
        resolvedArtifacts.stream().map(ResolvedArtifact::getFile).filter(f -> f.exists() && f.isFile() && f.getName().endsWith(".jar")).forEach(jarFile -> {
            try (FileInputStream is = new FileInputStream((File)jarFile);
                 JarInputStream jarStream = new JarInputStream(is);){
                String vaadinStylesheets = this.getVaadinStylesheets(jarStream);
                if (vaadinStylesheets != null) {
                    this.getLogger().info("[ThemeCompile] unpack Vaadin addon styles {}", (Object)jarFile.getName());
                    this.getProject().copy(copySpec -> copySpec.from(new Object[]{this.getProject().zipTree(jarFile)}).into((Object)themesTmp).include(new String[]{"VAADIN/**"}));
                }
            }
            catch (IOException e) {
                throw new GradleException("Unable to read JAR with theme", (Throwable)e);
            }
        });
    }

    protected void unpackThemesDependencies(File themesTmp, File vaadinThemesRoot) {
        Configuration themesConf = (Configuration)this.getProject().getConfigurations().findByName("themes");
        if (themesConf != null) {
            List<File> themeArchives = this.collectThemeArchives(themesConf);
            for (File archive : themeArchives) {
                if (archive.getName().startsWith("vaadin-themes")) {
                    this.getLogger().info("[ThemeCompile] unpack vaadin-themes artifact {}", (Object)archive.getName());
                    this.getProject().copy(copySpec -> copySpec.from(new Object[]{this.getProject().zipTree((Object)archive)}).into((Object)themesTmp).include(new String[]{"VAADIN/**"}).setExcludes(this.doNotUnpackPaths));
                    continue;
                }
                this.getLogger().info("[ThemeCompile] unpack themes artifact {}", (Object)archive.getName());
                this.getProject().copy(copySpec -> copySpec.from(new Object[]{this.getProject().zipTree((Object)archive)}).into((Object)vaadinThemesRoot).setExcludes(this.doNotUnpackPaths));
            }
        }
    }

    protected List<File> collectThemeArchives(Configuration themesConf) {
        Set firstLevelModuleDependencies = themesConf.getResolvedConfiguration().getFirstLevelModuleDependencies();
        ArrayList<File> files = new ArrayList<File>();
        HashSet<ResolvedArtifact> passedArtifacts = new HashSet<ResolvedArtifact>();
        for (ResolvedDependency dependency : firstLevelModuleDependencies) {
            this.collectThemeArchives(dependency, passedArtifacts, files);
        }
        return files;
    }

    protected void collectThemeArchives(ResolvedDependency dependency, Set<ResolvedArtifact> passedArtifacts, List<File> files) {
        for (ResolvedDependency child : dependency.getChildren()) {
            this.collectThemeArchives(child, passedArtifacts, files);
        }
        for (ResolvedArtifact artifact : dependency.getModuleArtifacts()) {
            if (passedArtifacts.contains(artifact)) continue;
            passedArtifacts.add(artifact);
            files.add(artifact.getFile());
        }
    }

    protected void buildTheme(String themeDirName, File stylesDirectory, File vaadinThemesRoot) throws FileNotFoundException {
        this.getLogger().info("[ThemeCompile] build theme '{}'", (Object)themeDirName);
        File themeDir = new File(stylesDirectory, themeDirName);
        if (!themeDir.exists()) {
            throw new FileNotFoundException("Unable to find theme directory: " + themeDir.getAbsolutePath());
        }
        File themeBuildDir = new File(vaadinThemesRoot, themeDirName);
        this.getLogger().info("[ThemeCompile] copy theme '{}' to build directory", (Object)themeDir.getName());
        this.getProject().copy(copySpec -> copySpec.from(new Object[]{themeDir}).into((Object)themeBuildDir).exclude(element -> element.getFile().getName().startsWith(".")));
        this.generateAddonIncludes(themeBuildDir);
        this.getLogger().info("[ThemeCompile] compile theme '{}'", (Object)themeDir.getName());
        File scssFile = new File(themeBuildDir, "styles.scss");
        File cssFile = new File(themeBuildDir, "styles.css");
        this.compileScss(scssFile, cssFile);
        if (this.compress) {
            this.performCssCompression(themeDir, cssFile);
        }
        if (this.gzip) {
            this.createGzipCss(themeBuildDir, cssFile);
        }
        this.getLogger().info("[ThemeCompile] successfully compiled theme '{}'", (Object)themeDir.getName());
    }

    protected void compileScss(File scssFile, File cssFile) {
        ScssContext.UrlMode urlMode = ScssContext.UrlMode.MIXED;
        SCSSErrorHandler errorHandler = new SCSSErrorHandler(){
            boolean[] hasErrors = new boolean[]{false};

            public void error(CSSParseException e) throws CSSException {
                ThemeCompile.this.getLogger().error("[ThemeCompile] Error when parsing file \n{} on line {}, column {}", new Object[]{e.getURI(), e.getLineNumber(), e.getColumnNumber(), e});
                this.hasErrors[0] = true;
            }

            public void fatalError(CSSParseException e) throws CSSException {
                ThemeCompile.this.getLogger().error("[ThemeCompile] Error when parsing file \n{} on line {}, column {}", new Object[]{e.getURI(), e.getLineNumber(), e.getColumnNumber(), e});
                this.hasErrors[0] = true;
            }

            public void warning(CSSParseException e) throws CSSException {
                ThemeCompile.this.getLogger().error("[ThemeCompile] Warning when parsing file \n{} on line {}, column {}", new Object[]{e.getURI(), e.getLineNumber(), e.getColumnNumber(), e});
            }

            public void traverseError(Exception e) {
                ThemeCompile.this.getLogger().error("[ThemeCompile] Error on SCSS traverse", (Throwable)e);
                this.hasErrors[0] = true;
            }

            public void traverseError(String message) {
                ThemeCompile.this.getLogger().error("[ThemeCompile] {}", (Object)message);
                this.hasErrors[0] = true;
            }

            public boolean isErrorsDetected() {
                return super.isErrorsDetected() || this.hasErrors[0];
            }
        };
        errorHandler.setWarningsAreErrors(false);
        try {
            ScssStylesheet scss = ScssStylesheet.get((String)scssFile.getAbsolutePath(), null, (SCSSDocumentHandler)new SCSSDocumentHandlerImpl(), (SCSSErrorHandler)errorHandler);
            if (scss == null) {
                throw new GradleException("Unable to find SCSS file " + scssFile.getAbsolutePath());
            }
            scss.compile(urlMode);
            FileWriter writer = new FileWriter(cssFile);
            scss.write((Writer)writer, false);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new GradleException("Unable to build theme " + scssFile.getAbsolutePath(), (Throwable)e);
        }
        if (errorHandler.isErrorsDetected()) {
            throw new GradleException("Unable to build theme " + scssFile.getAbsolutePath());
        }
    }

    protected void createGzipCss(File themeBuildDir, File cssFile) {
        this.getLogger().info("[ThemeCompile] compress css file 'styles.css'");
        File cssGzFile = new File(themeBuildDir, "styles.css.gz");
        try (FileInputStream uncompressedStream = new FileInputStream(cssFile);
             GZIPOutputStream gzos = new GZIPOutputStream(new FileOutputStream(cssGzFile));){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = uncompressedStream.read(buffer)) > 0) {
                gzos.write(buffer, 0, len);
            }
            gzos.finish();
        }
        catch (IOException e) {
            throw new GradleException("Unable to GZIP theme CSS", (Throwable)e);
        }
    }

    protected void performCssCompression(File themeDir, File cssFile) {
        this.getLogger().info("[ThemeCompile] compress theme '{}'", (Object)themeDir.getName());
        File compressedFile = new File(cssFile.getAbsolutePath() + ".compressed");
        try (FileReader cssReader = new FileReader(cssFile);
             BufferedWriter out = new BufferedWriter(new FileWriter(compressedFile));){
            CssCompressor compressor = new CssCompressor((Reader)cssReader);
            compressor.compress((Writer)out, 0);
        }
        catch (IOException e) {
            throw new GradleException("Unable to minify CSS theme " + themeDir.getName(), (Throwable)e);
        }
        if (compressedFile.exists()) {
            try {
                FileUtils.forceDelete((File)cssFile);
            }
            catch (IOException e) {
                throw new GradleException("Unable to delete CSS file " + cssFile.getAbsolutePath(), (Throwable)e);
            }
            boolean renamed = compressedFile.renameTo(cssFile);
            if (!renamed) {
                throw new GradleException("Unable to move file " + cssFile.getAbsolutePath());
            }
        }
    }

    protected void generateAddonIncludes(File themeBuildDir) {
        Configuration compileConfiguration;
        File addonIncludesFile = new File(themeBuildDir, "addons.scss");
        if (addonIncludesFile.exists()) {
            this.getLogger().info("[ThemeCompile] there is the customized addons.scss file in the project");
            return;
        }
        this.getLogger().info("[ThemeCompile] include styles from addons for '{}'", (Object)themeBuildDir.getName());
        StringBuilder includesBuilder = new StringBuilder();
        includesBuilder.append("/* This file is automatically managed and will be overwritten */\n\n");
        HashSet<ResolvedArtifact> addedArtifacts = new HashSet<ResolvedArtifact>();
        HashSet<String> includedPaths = new HashSet<String>();
        ArrayList<String> includeMixins = new ArrayList<String>();
        ConfigurationContainer configurations = this.getProject().getConfigurations();
        Configuration themesConfiguration = (Configuration)configurations.findByName("themes");
        if (themesConfiguration != null) {
            this.collectAddonIncludes(themesConfiguration, includesBuilder, addedArtifacts, includeMixins, includedPaths);
        }
        if ((compileConfiguration = (Configuration)configurations.findByName(COMPILE_CLASSPATH_CONFIGURATION)) != null) {
            this.collectAddonIncludes(compileConfiguration, includesBuilder, addedArtifacts, includeMixins, includedPaths);
        }
        includesBuilder.append("\n@mixin addons {\n");
        for (String mixin : includeMixins) {
            includesBuilder.append("  @include ").append(mixin).append(";\n");
        }
        includesBuilder.append('}');
        try {
            FileUtils.write((File)addonIncludesFile, (CharSequence)includesBuilder.toString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new GradleException("Unable to write addons.scss in " + themeBuildDir.getAbsolutePath(), (Throwable)e);
        }
    }

    protected void collectAddonIncludes(Configuration configuration, StringBuilder appComponentsIncludeBuilder, Set<ResolvedArtifact> addedArtifacts, List<String> includeMixins, Set<String> includedPaths) {
        Set dependencies = configuration.getResolvedConfiguration().getFirstLevelModuleDependencies();
        HashSet<ResolvedDependency> visitedDependencies = new HashSet<ResolvedDependency>();
        this.walkDependencies(dependencies, visitedDependencies, addedArtifacts, artifact -> {
            File file = artifact.getFile();
            try (FileInputStream is = new FileInputStream(file);
                 JarInputStream jarStream = new JarInputStream(is);){
                String vaadinStylesheets = this.getVaadinStylesheets(jarStream);
                if (vaadinStylesheets != null) {
                    this.includeVaadinStyles(vaadinStylesheets, includeMixins, includedPaths, appComponentsIncludeBuilder);
                }
            }
            catch (IOException e) {
                throw new GradleException("Unable to read SCSS theme includes", (Throwable)e);
            }
        });
    }

    protected void includeVaadinStyles(String vaadinStylesheets, List<String> includeMixins, Set<String> includedPaths, StringBuilder includeBuilder) {
        List vAddonIncludes = Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)vaadinStylesheets);
        for (String include : new LinkedHashSet(vAddonIncludes)) {
            if (!include.startsWith("/")) {
                include = '/' + include;
            }
            if (includedPaths.contains(include)) continue;
            includedPaths.add(include);
            this.getLogger().info("[ThemeCompile] include vaadin addons styles '{}'", (Object)include);
            if (include.endsWith(".css")) {
                includeBuilder.append(String.format("@import url(\"../../..%s\");\n", include));
                continue;
            }
            String mixin = include.substring(include.lastIndexOf("/") + 1, include.length() - ".scss".length());
            includeBuilder.append(String.format("@import \"../../..%s\";\n", include));
            includeMixins.add(mixin);
        }
    }

    protected void walkDependencies(Set<ResolvedDependency> dependencies, Set<ResolvedDependency> visitedDependencies, Set<ResolvedArtifact> addedArtifacts, Consumer<ResolvedArtifact> artifactAction) {
        for (ResolvedDependency dependency : dependencies) {
            if (visitedDependencies.contains(dependency)) continue;
            visitedDependencies.add(dependency);
            this.walkDependencies(dependency.getChildren(), visitedDependencies, addedArtifacts, artifactAction);
            for (ResolvedArtifact artifact : dependency.getModuleArtifacts()) {
                if (addedArtifacts.contains(artifact)) continue;
                addedArtifacts.add(artifact);
                if (!artifact.getFile().getName().endsWith(".jar")) continue;
                artifactAction.accept(artifact);
            }
        }
    }

    @Nullable
    protected String getVaadinStylesheets(JarInputStream jarStream) {
        Manifest mf = jarStream.getManifest();
        if (mf != null && mf.getMainAttributes() != null) {
            return mf.getMainAttributes().getValue(VAADIN_STYLESHEETS_MANIFEST_KEY);
        }
        return null;
    }

    protected void copyResources(File themesBuildDir, File themesDestDir) {
        this.getProject().copy(copySpec -> copySpec.from(new Object[]{themesBuildDir}).into((Object)themesDestDir).exclude(element -> {
            String name = element.getFile().getName();
            return name.startsWith(".") || name.endsWith(".scss");
        }));
    }

    protected void removeEmptyDirs(File themesDestDir) {
        this.recursiveVisitDir(themesDestDir, f -> {
            String[] list = f.list();
            if (list == null) {
                return;
            }
            if (list.length == 0) {
                Path relativePath = themesDestDir.toPath().relativize(f.toPath());
                this.getLogger().debug("[CubaWebScssThemeCreation] remove empty dir {} in '{}'", (Object)relativePath, (Object)themesDestDir.getName());
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException e) {
                    throw new GradleException("Unable to delete empty dir", (Throwable)e);
                }
            }
        });
    }

    protected void recursiveVisitDir(File dir, Consumer<File> apply) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (!f.exists() || !f.isDirectory()) continue;
            this.recursiveVisitDir(f, apply);
            apply.accept(f);
        }
    }
}

