/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import io.jmix.gradle.ClassPathCommandLine;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ClassPathUtil {
    public static void createClassPathFile(File classPathFile, List<File> classPath) {
        try (PrintWriter writer = new PrintWriter(classPathFile);){
            for (File file : classPath) {
                writer.println(file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write classpath to temporary file", e);
        }
    }

    public static void createFormattedClassPathFile(File classPathFile, List<File> classPath) {
        try (PrintWriter writer = new PrintWriter(classPathFile);){
            writer.print("-cp ");
            for (int i = 0; i < classPath.size(); ++i) {
                File file = classPath.get(i);
                String path = file.getAbsolutePath().replace(" ", "\" \"");
                writer.print(path + ";");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write classpath to temporary file", e);
        }
    }

    public static List<File> getCommandLineClassPath() {
        ClassLoader classLoader = ClassPathCommandLine.class.getClassLoader();
        if (classLoader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)ClassPathCommandLine.class.getClassLoader()).getURLs();
            return Arrays.stream(urls).map(url -> new File(url.getPath())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> getExtendedCommandLineAgs(String classPathFile, String mainClass, List<String> args) {
        ArrayList<String> extendedArgs = new ArrayList<String>();
        extendedArgs.add(classPathFile);
        extendedArgs.add(mainClass);
        extendedArgs.addAll(args);
        return extendedArgs;
    }
}

