/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import com.google.common.base.Strings;
import io.jmix.gradle.MetaModelUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.annotation.Nullable;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorGenerationUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DescriptorGenerationUtils.class);
    private static final String ORM_XMLNS = "http://xmlns.jcp.org/xml/ns/persistence/orm";
    private static final String ORM_SCHEMA_LOCATION = "http://xmlns.jcp.org/xml/ns/persistence/orm http://xmlns.jcp.org/xml/ns/persistence/orm_2_2.xsd";
    private static final String PERSISTENCE_XMLNS = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final String PERSISTENCE_SCHEMA_LOCATION = "http://xmlns.jcp.org/xml/ns/persistence http://xmlns.jcp.org/xml/ns/persistence/persistence_2_2.xsd";
    private static final String PERSISTENCE_VER = "2.2";
    public static final String ONE_TO_ONE_ANNOTATION = "javax.persistence.OneToOne";
    public static final String ONE_TO_MANY_ANNOTATION = "javax.persistence.OneToMany";
    public static final String MANY_TO_ONE_ANNOTATION = "javax.persistence.ManyToOne";
    public static final String MANY_TO_MANY_ANNOTATION = "javax.persistence.ManyToMany";
    static final String CONVERTERS_LIST_PROPERTY = "io.jmix.enhancing.converters-list";

    public static File constructPersistenceXml(String persistenceFileName, String storeName, String ormRelativeFileName, Set<String> jpaEntitiesAndConverters, Set<String> converters) {
        File file = new File(persistenceFileName);
        file.getParentFile().mkdirs();
        Document doc = DocumentHelper.createDocument();
        Element rootEl = doc.addElement("persistence", PERSISTENCE_XMLNS);
        Namespace xsi = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootEl.add(xsi);
        rootEl.addAttribute(new QName("schemaLocation", xsi), PERSISTENCE_SCHEMA_LOCATION);
        rootEl.addAttribute("version", PERSISTENCE_VER);
        Element persistenceUnit = rootEl.addElement("persistence-unit");
        persistenceUnit.addAttribute("name", storeName);
        persistenceUnit.addElement("provider").addText("io.jmix.data.impl.JmixPersistenceProvider");
        persistenceUnit.addElement("mapping-file").addText(ormRelativeFileName);
        for (String name : jpaEntitiesAndConverters) {
            persistenceUnit.addElement("class").addText(name);
        }
        persistenceUnit.addElement("exclude-unlisted-classes");
        Element properties = persistenceUnit.addElement("properties");
        properties.addElement("property").addAttribute("name", "eclipselink.weaving").addAttribute("value", "static");
        properties.addElement("property").addAttribute("name", CONVERTERS_LIST_PROPERTY).addAttribute("value", String.join((CharSequence)";", converters));
        DescriptorGenerationUtils.writeDocument(doc, file);
        return file;
    }

    public static File constructOrmXml(String fileName, Set<String> mappedStoreClasses, ClassPool classPool) throws NotFoundException, BadBytecode {
        ArrayList<CtClass> persistentClasses = new ArrayList<CtClass>();
        HashMap<CtClass, CtClass> extendedClasses = new HashMap<CtClass, CtClass>();
        DescriptorGenerationUtils.findExtendedClasses(mappedStoreClasses, classPool, persistentClasses, extendedClasses);
        LinkedHashMap<CtClass, List<Attr>> mappings = new LinkedHashMap<CtClass, List<Attr>>();
        for (CtClass aClass : persistentClasses) {
            List<Attr> attrList = DescriptorGenerationUtils.processClass(aClass, extendedClasses, classPool);
            if (attrList.isEmpty()) continue;
            mappings.put(aClass, attrList);
        }
        LOG.debug("Found " + mappings.size() + " entities containing extended associations");
        return DescriptorGenerationUtils.createOrmFile(mappings, fileName);
    }

    protected static void findExtendedClasses(Set<String> mappedStoreClasses, ClassPool classPool, List<CtClass> persistentClasses, Map<CtClass, CtClass> extendedClasses) throws NotFoundException {
        HashMap<CtClass, CtClass> foundExtensions = new HashMap<CtClass, CtClass>();
        for (String string : mappedStoreClasses) {
            CtClass aClass = classPool.get(string);
            persistentClasses.add(aClass);
            String replacedEntity = MetaModelUtil.findReplacedEntity(aClass);
            if (replacedEntity == null) continue;
            foundExtensions.put(classPool.get(replacedEntity), aClass);
        }
        for (Map.Entry entry : foundExtensions.entrySet()) {
            CtClass originalClass = (CtClass)entry.getKey();
            CtClass extClass = (CtClass)entry.getValue();
            CtClass lastExtClass = null;
            CtClass aClass = (CtClass)foundExtensions.get(extClass);
            while (aClass != null) {
                lastExtClass = aClass;
                aClass = (CtClass)foundExtensions.get(aClass);
            }
            if (lastExtClass != null) {
                extendedClasses.put(originalClass, lastExtClass);
                continue;
            }
            extendedClasses.put(originalClass, extClass);
        }
    }

    protected static File createOrmFile(Map<CtClass, List<Attr>> mappings, String fileName) {
        Element entityEl;
        Document doc = DescriptorGenerationUtils.createEmptyDocument();
        Element rootEl = doc.getRootElement();
        for (Map.Entry<CtClass, List<Attr>> entry : mappings.entrySet()) {
            if (!MetaModelUtil.isJpaMappedSuperclass(entry.getKey())) continue;
            entityEl = rootEl.addElement("mapped-superclass", ORM_XMLNS);
            entityEl.addAttribute("class", entry.getKey().getName());
            DescriptorGenerationUtils.createAttributes(entry, entityEl);
        }
        for (Map.Entry<CtClass, List<Attr>> entry : mappings.entrySet()) {
            if (!MetaModelUtil.isJpaEntity(entry.getKey())) continue;
            entityEl = rootEl.addElement("entity", ORM_XMLNS);
            entityEl.addAttribute("class", entry.getKey().getName());
            AnnotationsAttribute attribute = (AnnotationsAttribute)entry.getKey().getClassFile().getAttribute("RuntimeVisibleAnnotations");
            Annotation annotation = attribute.getAnnotation("javax.persistence.Entity");
            StringMemberValue memberValue = (StringMemberValue)annotation.getMemberValue("name");
            entityEl.addAttribute("name", memberValue.getValue());
            DescriptorGenerationUtils.createAttributes(entry, entityEl);
        }
        for (Map.Entry<CtClass, List<Attr>> entry : mappings.entrySet()) {
            if (!MetaModelUtil.isJpaEmbeddable(entry.getKey())) continue;
            entityEl = rootEl.addElement("embeddable", ORM_XMLNS);
            entityEl.addAttribute("class", entry.getKey().getName());
            DescriptorGenerationUtils.createAttributes(entry, entityEl);
        }
        File ormFile = new File(fileName);
        ormFile.getParentFile().mkdirs();
        DescriptorGenerationUtils.writeDocument(doc, ormFile);
        return ormFile;
    }

    private static void writeDocument(Document doc, File file) {
        LOG.info("Creating file " + file);
        try (FileOutputStream os = new FileOutputStream(file);){
            OutputFormat format = OutputFormat.createPrettyPrint();
            new XMLWriter((OutputStream)os, format).write(doc);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write " + file.getName(), e);
        }
    }

    private static void createAttributes(Map.Entry<CtClass, List<Attr>> entry, Element entityEl) {
        Element attributesEl = entityEl.addElement("attributes", ORM_XMLNS);
        Collections.sort(entry.getValue(), Comparator.comparingInt(a -> ((Attr)a).type.order));
        for (Attr attr : entry.getValue()) {
            attr.toXml(attributesEl);
        }
    }

    private static Document createEmptyDocument() {
        Document doc = DocumentHelper.createDocument();
        Element rootEl = doc.addElement("entity-mappings", ORM_XMLNS);
        Namespace xsi = new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootEl.add(xsi);
        rootEl.addAttribute(new QName("schemaLocation", xsi), ORM_SCHEMA_LOCATION);
        rootEl.addAttribute("version", PERSISTENCE_VER);
        return doc;
    }

    private static List<Attr> processClass(CtClass aClass, Map<CtClass, CtClass> extendedClasses, ClassPool classPool) throws NotFoundException, BadBytecode {
        ArrayList<Attr> list = new ArrayList<Attr>();
        for (CtField field : aClass.getDeclaredFields()) {
            Attr.Type type = DescriptorGenerationUtils.getAttrType(field);
            if (type == null) continue;
            CtClass fieldType = field.getType();
            CtClass extClass = null;
            if (MetaModelUtil.isCollection(field)) {
                String genericSignature = field.getGenericSignature();
                SignatureAttribute.ClassType objectType = (SignatureAttribute.ClassType)SignatureAttribute.toFieldSignature((String)genericSignature);
                if (objectType.getTypeArguments().length == 1) {
                    String argType = objectType.getTypeArguments()[0].getType().toString();
                    extClass = extendedClasses.get(classPool.get(argType));
                }
            } else {
                extClass = extendedClasses.get(fieldType);
            }
            if (extClass == null) continue;
            Attr attr = new Attr(type, field, extClass.getName());
            attr.type.getCascade(field);
            list.add(attr);
        }
        return list;
    }

    @Nullable
    private static Attr.Type getAttrType(CtField field) {
        if (MetaModelUtil.hasAnnotationOnField(field, ONE_TO_ONE_ANNOTATION)) {
            return Attr.Type.ONE_TO_ONE;
        }
        if (MetaModelUtil.hasAnnotationOnField(field, ONE_TO_MANY_ANNOTATION)) {
            return Attr.Type.ONE_TO_MANY;
        }
        if (MetaModelUtil.hasAnnotationOnField(field, MANY_TO_ONE_ANNOTATION)) {
            return Attr.Type.MANY_TO_ONE;
        }
        if (MetaModelUtil.hasAnnotationOnField(field, MANY_TO_MANY_ANNOTATION)) {
            return Attr.Type.MANY_TO_MANY;
        }
        return null;
    }

    private static class OrderByHandler
    extends AnnotationHandler {
        private OrderByHandler(Annotation annotation) {
            super(annotation);
        }

        private void toXml(Element parentEl) {
            if (this.annotation == null) {
                return;
            }
            Element el = parentEl.addElement("order-by");
            el.setText(this.getStringAttribute("value"));
        }
    }

    private static class MapsIdHandler
    extends AnnotationHandler {
        private MapsIdHandler(Annotation annotation) {
            super(annotation);
        }

        private void toXml(Element parentEl) {
            if (this.annotation == null) {
                return;
            }
            parentEl.addAttribute("maps-id", this.getStringAttribute("value"));
        }
    }

    private static class JoinTableHandler
    extends AnnotationHandler {
        private JoinTableHandler(Annotation annotation) {
            super(annotation);
        }

        private void toXml(Element parentEl) {
            if (this.annotation == null) {
                return;
            }
            Element el = parentEl.addElement("join-table");
            el.addAttribute("name", this.getStringAttribute("name"));
            for (Annotation joinColumnAnnot : this.getAnnotationArrayAttribute("joinColumns")) {
                new JoinColumnHandler(joinColumnAnnot).toXml(el);
            }
            for (Annotation joinColumnAnnot : this.getAnnotationArrayAttribute("inverseJoinColumns")) {
                new InverseJoinColumnHandler(joinColumnAnnot).toXml(el);
            }
        }
    }

    private static class InverseJoinColumnHandler
    extends JoinColumnHandler {
        private InverseJoinColumnHandler(Annotation annotation) {
            super(annotation);
        }

        @Override
        protected String getElementName() {
            return "inverse-join-column";
        }
    }

    private static class JoinColumnHandler
    extends AnnotationHandler {
        private JoinColumnHandler(Annotation annotation) {
            super(annotation);
        }

        protected void toXml(Element parentEl) {
            if (this.annotation == null) {
                return;
            }
            Element el = parentEl.addElement(this.getElementName());
            el.addAttribute("name", this.getStringAttribute("name"));
            String referencedColumnName = this.getStringAttribute("referencedColumnName");
            if (!Strings.isNullOrEmpty((String)referencedColumnName)) {
                el.addAttribute("referenced-column-name", referencedColumnName);
            }
            if (this.getBooleanAttribute("unique", false)) {
                el.addAttribute("unique", "true");
            }
            if (!this.getBooleanAttribute("nullable", true)) {
                el.addAttribute("nullable", "false");
            }
            if (!this.getBooleanAttribute("insertable", true)) {
                el.addAttribute("insertable", "false");
            }
            if (!this.getBooleanAttribute("updatable", true)) {
                el.addAttribute("updatable", "false");
            }
        }

        protected String getElementName() {
            return "join-column";
        }
    }

    private static class AnnotationHandler {
        protected Annotation annotation;

        public AnnotationHandler(Annotation annotation) {
            this.annotation = annotation;
        }

        protected String getStringAttribute(String name) {
            return this.getStringAttribute(name, "");
        }

        protected String getStringAttribute(String name, String defaultValue) {
            StringMemberValue memberValue = (StringMemberValue)this.annotation.getMemberValue(name);
            return memberValue != null ? memberValue.getValue() : defaultValue;
        }

        protected boolean getBooleanAttribute(String name, Boolean defaultValue) {
            BooleanMemberValue memberValue = (BooleanMemberValue)this.annotation.getMemberValue(name);
            return memberValue != null ? memberValue.getValue() : defaultValue.booleanValue();
        }

        protected List<Annotation> getAnnotationArrayAttribute(String name) {
            ArrayMemberValue memberValues = (ArrayMemberValue)this.annotation.getMemberValue(name);
            ArrayList<Annotation> result = new ArrayList<Annotation>();
            if (memberValues != null) {
                for (MemberValue value : memberValues.getValue()) {
                    result.add(((AnnotationMemberValue)value).getValue());
                }
            }
            return result;
        }
    }

    private static class Attr {
        private final Type type;
        private final CtField field;
        private final String targetEntity;

        private Attr(Type type, CtField field, String targetEntity) {
            this.type = type;
            this.field = field;
            this.targetEntity = targetEntity;
        }

        private Element toXml(Element parentEl) {
            Element el = parentEl.addElement(this.type.xml, DescriptorGenerationUtils.ORM_XMLNS);
            el.addAttribute("name", this.field.getName());
            el.addAttribute("target-entity", this.targetEntity);
            el.addAttribute("fetch", this.type.getFetch(this.field));
            String mappedBy = this.type.getMappedBy(this.field);
            if (!Strings.isNullOrEmpty((String)mappedBy)) {
                el.addAttribute("mapped-by", mappedBy);
            }
            new JoinColumnHandler(Attr.getAnnotation(this.field, "javax.persistence.JoinColumn")).toXml(el);
            new OrderByHandler(Attr.getAnnotation(this.field, "javax.persistence.OrderBy")).toXml(el);
            new JoinTableHandler(Attr.getAnnotation(this.field, "javax.persistence.JoinTable")).toXml(el);
            new MapsIdHandler(Attr.getAnnotation(this.field, "javax.persistence.MapsId")).toXml(el);
            List<String> cascadeTypes = this.type.getCascade(this.field);
            if (cascadeTypes != null && cascadeTypes.size() > 0) {
                Element cascadeTypeEl = el.addElement("cascade", DescriptorGenerationUtils.ORM_XMLNS);
                for (String cascadeType : cascadeTypes) {
                    cascadeTypeEl.addElement("cascade-" + cascadeType.toLowerCase());
                }
            }
            return el;
        }

        protected static Annotation getAnnotation(CtField ctField, String annotationName) {
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)ctField.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
            return annotationsAttribute.getAnnotation(annotationName);
        }

        protected static enum Type {
            MANY_TO_ONE(1, "many-to-one", "javax.persistence.ManyToOne", "EAGER"),
            ONE_TO_MANY(2, "one-to-many", "javax.persistence.OneToMany"),
            ONE_TO_ONE(3, "one-to-one", "javax.persistence.OneToOne", "EAGER"),
            MANY_TO_MANY(4, "many-to-many", "javax.persistence.ManyToMany");

            private int order;
            private String xml;
            private String annotationName;
            private String defaultFetch = "LAZY";

            private Type(int order, String xml, String annotationName) {
                this.order = order;
                this.xml = xml;
                this.annotationName = annotationName;
            }

            private Type(int order, String xml, String annotationName, String defaultFetch) {
                this(order, xml, annotationName);
                this.defaultFetch = defaultFetch;
            }

            protected String getFetch(CtField ctField) {
                Annotation annotation = this.getAnnotation(ctField);
                EnumMemberValue memberValue = (EnumMemberValue)annotation.getMemberValue("fetch");
                String fetchType = this.defaultFetch;
                if (memberValue != null && !Strings.isNullOrEmpty((String)memberValue.getValue())) {
                    fetchType = memberValue.getValue();
                }
                return fetchType;
            }

            protected String getMappedBy(CtField ctField) {
                StringMemberValue value = (StringMemberValue)this.getAnnotation(ctField).getMemberValue("mappedBy");
                return value != null ? value.getValue() : null;
            }

            protected List<String> getCascade(CtField ctField) {
                ArrayMemberValue value = (ArrayMemberValue)this.getAnnotation(ctField).getMemberValue("cascade");
                List result = null;
                if (value != null) {
                    result = Arrays.stream(value.getValue()).map(v -> ((EnumMemberValue)v).getValue()).collect(Collectors.toList());
                }
                return result;
            }

            protected Annotation getAnnotation(CtField ctField) {
                return Attr.getAnnotation(ctField, this.annotationName);
            }
        }
    }
}

