/*
 * Decompiled with CFR 0.152.
 */
package io.jmix.gradle;

import io.jmix.gradle.EnhancingException;
import io.jmix.gradle.EnhancingStep;
import io.jmix.gradle.MetaModelUtil;
import java.io.IOException;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.gradle.api.logging.Logger;

public abstract class BaseEnhancingStep
implements EnhancingStep {
    protected ClassPool classPool;
    protected String outputDir;
    protected Logger logger;

    @Override
    public void execute(String className) {
        try {
            CtClass ctClass = this.classPool.get(className);
            if (this.isAlreadyEnhanced(ctClass)) {
                this.logger.info(String.format("[%s] %s has already been enhanced", this.getEnhancingType(), className));
                return;
            }
            if (MetaModelUtil.isEnhancingDisabled(ctClass)) {
                this.logger.info(String.format("[%s] Enhancing disabled for %s entity", this.getEnhancingType(), className));
                return;
            }
            if (MetaModelUtil.isJpaConverter(ctClass)) {
                return;
            }
            if (!this.isEnhancingSupported(ctClass)) {
                this.logger.info(String.format("[%s] %s is not an Entity and should not be enhanced", this.getEnhancingType(), className));
                return;
            }
            this.logger.info(String.format("[%s] Enhance class %s...", this.getEnhancingType(), className));
            this.executeInternal(ctClass);
            ctClass.writeFile(this.outputDir);
        }
        catch (IOException | CannotCompileException | NotFoundException e) {
            throw new EnhancingException(String.format("Error while enhancing class %s: %s", className, e.getMessage()), e);
        }
    }

    public boolean isEnhancingSupported(CtClass ctClass) {
        return MetaModelUtil.isJpaEntity(ctClass) || MetaModelUtil.isJpaEmbeddable(ctClass) || MetaModelUtil.isJpaMappedSuperclass(ctClass) || MetaModelUtil.isJmixEntity(ctClass);
    }

    @Override
    public void setClassPool(ClassPool classPool) {
        this.classPool = classPool;
    }

    @Override
    public void setOutputDir(String outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected abstract boolean isAlreadyEnhanced(CtClass var1) throws NotFoundException;

    protected abstract String getEnhancingType();

    protected abstract void executeInternal(CtClass var1) throws IOException, CannotCompileException, NotFoundException;
}

